/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerationStrategy;
import org.hibernate.id.UUIDGenerator;
import org.jboss.logging.Logger;

public class GUIDGenerator
implements IdentifierGenerator {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)GUIDGenerator.class.getName());
    private static boolean warned = false;

    public GUIDGenerator() {
        if (!warned) {
            warned = true;
            LOG.deprecatedUuidGenerator(UUIDGenerator.class.getName(), UUIDGenerationStrategy.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable generate(SessionImplementor session, Object obj) throws HibernateException {
        String string;
        String sql = session.getFactory().getDialect().getSelectGUIDString();
        PreparedStatement st = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(sql);
        try {
            String result;
            ResultSet rs = st.executeQuery();
            try {
                rs.next();
                result = rs.getString(1);
            }
            finally {
                rs.close();
            }
            LOG.guidGenerated(result);
            string = result;
        }
        catch (Throwable throwable) {
            try {
                st.close();
                throw throwable;
            }
            catch (SQLException sqle) {
                throw session.getFactory().getSQLExceptionHelper().convert(sqle, "could not retrieve GUID", sql);
            }
        }
        st.close();
        return string;
    }
}

