/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.exec;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.sql.Connection;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.action.BulkOperationCleanupAction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.event.EventSource;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.exec.StatementExecutor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jdbc.Work;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.InsertSelect;
import org.hibernate.sql.Select;
import org.hibernate.sql.SelectFragment;
import org.jboss.logging.Logger;

public abstract class AbstractStatementExecutor
implements StatementExecutor {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)AbstractStatementExecutor.class.getName());
    private final HqlSqlWalker walker;
    private List idSelectParameterSpecifications = Collections.EMPTY_LIST;
    private static SqlExceptionHelper.WarningHandler CREATION_WARNING_HANDLER = new SqlExceptionHelper.WarningHandlerLoggingSupport(){

        @Override
        public boolean doProcess() {
            return LOG.isDebugEnabled();
        }

        @Override
        public void prepare(SQLWarning warning) {
            LOG.warningsCreatingTempTable(warning);
        }

        @Override
        protected void logWarning(String description, String message) {
            LOG.debugf(description, new Object[0]);
            LOG.debugf(message, new Object[0]);
        }
    };

    public AbstractStatementExecutor(HqlSqlWalker walker, HibernateLogger log) {
        this.walker = walker;
    }

    protected HqlSqlWalker getWalker() {
        return this.walker;
    }

    protected SessionFactoryImplementor getFactory() {
        return this.walker.getSessionFactoryHelper().getFactory();
    }

    protected List getIdSelectParameterSpecifications() {
        return this.idSelectParameterSpecifications;
    }

    protected abstract Queryable[] getAffectedQueryables();

    protected String generateIdInsertSelect(Queryable persister, String tableAlias, AST whereClause) {
        Select select = new Select(this.getFactory().getDialect());
        SelectFragment selectFragment = new SelectFragment().addColumns(tableAlias, persister.getIdentifierColumnNames(), persister.getIdentifierColumnNames());
        select.setSelectClause(selectFragment.toFragmentString().substring(2));
        String rootTableName = persister.getTableName();
        String fromJoinFragment = persister.fromJoinFragment(tableAlias, true, false);
        String whereJoinFragment = persister.whereJoinFragment(tableAlias, true, false);
        select.setFromClause(rootTableName + ' ' + tableAlias + fromJoinFragment);
        if (whereJoinFragment == null) {
            whereJoinFragment = "";
        } else if ((whereJoinFragment = whereJoinFragment.trim()).startsWith("and")) {
            whereJoinFragment = whereJoinFragment.substring(4);
        }
        String userWhereClause = "";
        if (whereClause.getNumberOfChildren() != 0) {
            try {
                SqlGenerator sqlGenerator = new SqlGenerator(this.getFactory());
                sqlGenerator.whereClause(whereClause);
                userWhereClause = sqlGenerator.getSQL().substring(7);
                this.idSelectParameterSpecifications = sqlGenerator.getCollectedParameters();
            }
            catch (RecognitionException e) {
                throw new HibernateException("Unable to generate id select for DML operation", e);
            }
            if (whereJoinFragment.length() > 0) {
                whereJoinFragment = whereJoinFragment + " and ";
            }
        }
        select.setWhereClause(whereJoinFragment + userWhereClause);
        InsertSelect insert = new InsertSelect(this.getFactory().getDialect());
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            insert.setComment("insert-select for " + persister.getEntityName() + " ids");
        }
        insert.setTableName(persister.getTemporaryIdTableName());
        insert.setSelect(select);
        return insert.toStatementString();
    }

    protected String generateIdSubselect(Queryable persister) {
        return "select " + StringHelper.join(", ", persister.getIdentifierColumnNames()) + " from " + persister.getTemporaryIdTableName();
    }

    protected void createTemporaryTableIfNecessary(Queryable persister, SessionImplementor session) {
        TemporaryTableCreationWork work = new TemporaryTableCreationWork(persister);
        if (this.shouldIsolateTemporaryTableDDL()) {
            session.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork(work, this.getFactory().getSettings().isDataDefinitionInTransactionSupported());
        } else {
            Connection connection = session.getTransactionCoordinator().getJdbcCoordinator().getLogicalConnection().getShareableConnectionProxy();
            work.execute(connection);
            session.getTransactionCoordinator().getJdbcCoordinator().getLogicalConnection().afterStatementExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropTemporaryTableIfNecessary(Queryable persister, SessionImplementor session) {
        if (this.getFactory().getDialect().dropTemporaryTableAfterUse()) {
            TemporaryTableDropWork work = new TemporaryTableDropWork(persister, session);
            if (this.shouldIsolateTemporaryTableDDL()) {
                session.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork(work, this.getFactory().getSettings().isDataDefinitionInTransactionSupported());
            } else {
                Connection connection = session.getTransactionCoordinator().getJdbcCoordinator().getLogicalConnection().getShareableConnectionProxy();
                work.execute(connection);
                session.getTransactionCoordinator().getJdbcCoordinator().getLogicalConnection().afterStatementExecution();
            }
        } else {
            Statement ps = null;
            try {
                String sql = "delete from " + persister.getTemporaryIdTableName();
                ps = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(sql, false);
                ps.executeUpdate();
            }
            catch (Throwable t) {
                LOG.unableToCleanupTemporaryIdTable(t);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
        }
    }

    protected void coordinateSharedCacheCleanup(SessionImplementor session) {
        BulkOperationCleanupAction action = new BulkOperationCleanupAction(session, this.getAffectedQueryables());
        if (session.isEventSource()) {
            ((EventSource)session).getActionQueue().addAction(action);
        } else {
            action.getAfterTransactionCompletionProcess().doAfterTransactionCompletion(true, session);
        }
    }

    protected boolean shouldIsolateTemporaryTableDDL() {
        Boolean dialectVote = this.getFactory().getDialect().performTemporaryTableDDLInIsolation();
        if (dialectVote != null) {
            return dialectVote;
        }
        return this.getFactory().getSettings().isDataDefinitionImplicitCommit();
    }

    private static class TemporaryTableDropWork
    implements Work {
        private final Queryable persister;
        private final SessionImplementor session;

        private TemporaryTableDropWork(Queryable persister, SessionImplementor session) {
            this.persister = persister;
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Connection connection) {
            String command = this.session.getFactory().getDialect().getDropTemporaryTableString() + ' ' + this.persister.getTemporaryIdTableName();
            try {
                Statement statement = connection.createStatement();
                try {
                    statement = connection.createStatement();
                    statement.executeUpdate(command);
                }
                finally {
                    try {
                        statement.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
            catch (Exception e) {
                LOG.warn("unable to drop temporary id table after use [" + e.getMessage() + "]");
            }
        }
    }

    private static class TemporaryTableCreationWork
    implements Work {
        private final Queryable persister;

        private TemporaryTableCreationWork(Queryable persister) {
            this.persister = persister;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Connection connection) {
            try {
                Statement statement = connection.createStatement();
                try {
                    statement.executeUpdate(this.persister.getTemporaryIdTableDDL());
                    this.persister.getFactory().getServiceRegistry().getService(JdbcServices.class).getSqlExceptionHelper().handleAndClearWarnings(statement, CREATION_WARNING_HANDLER);
                }
                finally {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Exception e) {
                LOG.debug("unable to create temporary id table [" + e.getMessage() + "]");
            }
        }
    }
}

