/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.LockMode;
import org.hibernate.PersistentObjectException;
import org.hibernate.TransientObjectException;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.EventSource;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.event.def.AbstractSaveEventListener;
import org.hibernate.event.def.OnUpdateVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.jboss.logging.Logger;

public class DefaultSaveOrUpdateEventListener
extends AbstractSaveEventListener
implements SaveOrUpdateEventListener {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)DefaultSaveOrUpdateEventListener.class.getName());

    @Override
    public void onSaveOrUpdate(SaveOrUpdateEvent event) {
        EventSource source = event.getSession();
        Object object = event.getObject();
        Serializable requestedId = event.getRequestedId();
        if (requestedId != null && object instanceof HibernateProxy) {
            ((HibernateProxy)object).getHibernateLazyInitializer().setIdentifier(requestedId);
        }
        if (this.reassociateIfUninitializedProxy(object, source)) {
            LOG.trace("Reassociated uninitialized proxy");
        } else {
            Object entity = source.getPersistenceContext().unproxyAndReassociate(object);
            event.setEntity(entity);
            event.setEntry(source.getPersistenceContext().getEntry(entity));
            event.setResultId(this.performSaveOrUpdate(event));
        }
    }

    protected boolean reassociateIfUninitializedProxy(Object object, SessionImplementor source) {
        return source.getPersistenceContext().reassociateIfUninitializedProxy(object);
    }

    protected Serializable performSaveOrUpdate(SaveOrUpdateEvent event) {
        int entityState = this.getEntityState(event.getEntity(), event.getEntityName(), event.getEntry(), event.getSession());
        switch (entityState) {
            case 2: {
                this.entityIsDetached(event);
                return null;
            }
            case 0: {
                return this.entityIsPersistent(event);
            }
        }
        return this.entityIsTransient(event);
    }

    protected Serializable entityIsPersistent(SaveOrUpdateEvent event) throws HibernateException {
        Serializable savedId;
        LOG.trace("Ignoring persistent instance");
        EntityEntry entityEntry = event.getEntry();
        if (entityEntry == null) {
            throw new AssertionFailure("entity was transient or detached");
        }
        if (entityEntry.getStatus() == Status.DELETED) {
            throw new AssertionFailure("entity was deleted");
        }
        SessionFactoryImplementor factory = event.getSession().getFactory();
        Serializable requestedId = event.getRequestedId();
        if (requestedId == null) {
            savedId = entityEntry.getId();
        } else {
            boolean isEqual;
            boolean bl = isEqual = !entityEntry.getPersister().getIdentifierType().isEqual(requestedId, entityEntry.getId(), event.getSession().getEntityMode(), factory);
            if (isEqual) {
                throw new PersistentObjectException("object passed to save() was already persistent: " + MessageHelper.infoString(entityEntry.getPersister(), requestedId, factory));
            }
            savedId = requestedId;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Object already associated with session: " + MessageHelper.infoString(entityEntry.getPersister(), savedId, factory));
        }
        return savedId;
    }

    protected Serializable entityIsTransient(SaveOrUpdateEvent event) {
        LOG.trace("Saving transient instance");
        EventSource source = event.getSession();
        EntityEntry entityEntry = event.getEntry();
        if (entityEntry != null) {
            if (entityEntry.getStatus() == Status.DELETED) {
                source.forceFlush(entityEntry);
            } else {
                throw new AssertionFailure("entity was persistent");
            }
        }
        Serializable id = this.saveWithGeneratedOrRequestedId(event);
        source.getPersistenceContext().reassociateProxy(event.getObject(), id);
        return id;
    }

    protected Serializable saveWithGeneratedOrRequestedId(SaveOrUpdateEvent event) {
        return this.saveWithGeneratedId(event.getEntity(), event.getEntityName(), null, event.getSession(), true);
    }

    protected void entityIsDetached(SaveOrUpdateEvent event) {
        LOG.trace("Updating detached instance");
        if (event.getSession().getPersistenceContext().isEntryFor(event.getEntity())) {
            throw new AssertionFailure("entity was persistent");
        }
        Object entity = event.getEntity();
        EntityPersister persister = event.getSession().getEntityPersister(event.getEntityName(), entity);
        event.setRequestedId(this.getUpdateId(entity, persister, event.getRequestedId(), event.getSession()));
        this.performUpdate(event, entity, persister);
    }

    protected Serializable getUpdateId(Object entity, EntityPersister persister, Serializable requestedId, SessionImplementor session) {
        Serializable id = persister.getIdentifier(entity, session);
        if (id == null) {
            throw new TransientObjectException("The given object has a null identifier: " + persister.getEntityName());
        }
        return id;
    }

    protected void performUpdate(SaveOrUpdateEvent event, Object entity, EntityPersister persister) throws HibernateException {
        if (!persister.isMutable()) {
            LOG.trace("Immutable instance passed to performUpdate()");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Updating " + MessageHelper.infoString(persister, event.getRequestedId(), event.getSession().getFactory()));
        }
        EventSource source = event.getSession();
        EntityKey key = new EntityKey(event.getRequestedId(), persister, source.getEntityMode());
        source.getPersistenceContext().checkUniqueness(key, entity);
        if (this.invokeUpdateLifecycle(entity, persister, source)) {
            this.reassociate(event, event.getObject(), event.getRequestedId(), persister);
            return;
        }
        new OnUpdateVisitor(source, event.getRequestedId(), entity).process(entity, persister);
        source.getPersistenceContext().addEntity(entity, persister.isMutable() ? Status.MANAGED : Status.READ_ONLY, null, key, persister.getVersion(entity, source.getEntityMode()), LockMode.NONE, true, persister, false, true);
        persister.afterReassociate(entity, source);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Updating " + MessageHelper.infoString(persister, event.getRequestedId(), source.getFactory()));
        }
        this.cascadeOnUpdate(event, persister, entity);
    }

    protected boolean invokeUpdateLifecycle(Object entity, EntityPersister persister, EventSource source) {
        if (persister.implementsLifecycle(source.getEntityMode())) {
            LOG.debugf("Calling onUpdate()", new Object[0]);
            if (((Lifecycle)entity).onUpdate(source)) {
                LOG.debugf("Update vetoed by onUpdate()", new Object[0]);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnUpdate(SaveOrUpdateEvent event, EntityPersister persister, Object entity) {
        EventSource source = event.getSession();
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(CascadingAction.SAVE_UPDATE, 0, source).cascade(persister, entity);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    @Override
    protected CascadingAction getCascadeAction() {
        return CascadingAction.SAVE_UPDATE;
    }
}

