/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.PersistentObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.CacheKey;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.RefreshEvent;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.event.def.EvictVisitor;
import org.hibernate.internal.util.collections.IdentityMap;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class DefaultRefreshEventListener
implements RefreshEventListener {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)DefaultRefreshEventListener.class.getName());

    @Override
    public void onRefresh(RefreshEvent event) throws HibernateException {
        this.onRefresh(event, IdentityMap.instantiate(10));
    }

    @Override
    public void onRefresh(RefreshEvent event, Map refreshedAlready) {
        EntityKey key;
        Serializable id;
        EntityPersister persister;
        boolean isTransient;
        EventSource source = event.getSession();
        boolean bl = isTransient = !source.contains(event.getObject());
        if (source.getPersistenceContext().reassociateIfUninitializedProxy(event.getObject())) {
            if (isTransient) {
                source.setReadOnly(event.getObject(), source.isDefaultReadOnly());
            }
            return;
        }
        Object object = source.getPersistenceContext().unproxyAndReassociate(event.getObject());
        if (refreshedAlready.containsKey(object)) {
            LOG.trace("Already refreshed");
            return;
        }
        EntityEntry e = source.getPersistenceContext().getEntry(object);
        if (e == null) {
            persister = source.getEntityPersister(null, object);
            id = persister.getIdentifier(object, event.getSession());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Refreshing transient " + MessageHelper.infoString(persister, id, source.getFactory()));
            }
            key = new EntityKey(id, persister, source.getEntityMode());
            if (source.getPersistenceContext().getEntry(key) != null) {
                throw new PersistentObjectException("attempted to refresh transient instance when persistent instance was already associated with the Session: " + MessageHelper.infoString(persister, id, source.getFactory()));
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Refreshing " + MessageHelper.infoString(e.getPersister(), e.getId(), source.getFactory()));
            }
            if (!e.isExistsInDatabase()) {
                throw new HibernateException("this instance does not yet exist as a row in the database");
            }
            persister = e.getPersister();
            id = e.getId();
        }
        refreshedAlready.put(object, object);
        new Cascade(CascadingAction.REFRESH, 0, source).cascade(persister, object, refreshedAlready);
        if (e != null) {
            key = new EntityKey(id, persister, source.getEntityMode());
            source.getPersistenceContext().removeEntity(key);
            if (persister.hasCollections()) {
                new EvictVisitor(source).process(object, persister);
            }
        }
        if (persister.hasCache()) {
            CacheKey ck = new CacheKey(id, persister.getIdentifierType(), persister.getRootEntityName(), source.getEntityMode(), source.getFactory());
            persister.getCacheAccessStrategy().evict(ck);
        }
        this.evictCachedCollections(persister, id, source.getFactory());
        String previousFetchProfile = source.getFetchProfile();
        source.setFetchProfile("refresh");
        Object result = persister.load(id, object, event.getLockOptions(), (SessionImplementor)source);
        if (result != null) {
            if (!persister.isMutable()) {
                source.setReadOnly(result, true);
            } else {
                source.setReadOnly(result, e == null ? source.isDefaultReadOnly() : e.isReadOnly());
            }
        }
        source.setFetchProfile(previousFetchProfile);
        UnresolvableObjectException.throwIfNull(result, id, persister.getEntityName());
    }

    private void evictCachedCollections(EntityPersister persister, Serializable id, SessionFactoryImplementor factory) {
        this.evictCachedCollections(persister.getPropertyTypes(), id, factory);
    }

    private void evictCachedCollections(Type[] types, Serializable id, SessionFactoryImplementor factory) throws HibernateException {
        for (int i = 0; i < types.length; ++i) {
            if (types[i].isCollectionType()) {
                factory.evictCollection(((CollectionType)types[i]).getRole(), id);
                continue;
            }
            if (!types[i].isComponentType()) continue;
            CompositeType actype = (CompositeType)types[i];
            this.evictCachedCollections(actype.getSubtypes(), id, factory);
        }
    }
}

