/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.jboss.logging.Logger;

public class JdbcIsolationDelegate
implements IsolationDelegate {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)JdbcIsolationDelegate.class.getName());
    private final TransactionCoordinator transactionCoordinator;

    public JdbcIsolationDelegate(TransactionCoordinator transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
    }

    protected ConnectionProvider connectionProvider() {
        return this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().getJdbcServices().getConnectionProvider();
    }

    protected SqlExceptionHelper sqlExceptionHelper() {
        return this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().getJdbcServices().getSqlExceptionHelper();
    }

    @Override
    public void delegateWork(Work work, boolean transacted) throws HibernateException {
        boolean wasAutoCommit = false;
        try {
            Connection connection = this.connectionProvider().getConnection();
            try {
                if (transacted && connection.getAutoCommit()) {
                    wasAutoCommit = true;
                    connection.setAutoCommit(false);
                }
                work.execute(connection);
                if (transacted) {
                    connection.commit();
                }
            }
            catch (Exception e) {
                try {
                    if (transacted && !connection.isClosed()) {
                        connection.rollback();
                    }
                }
                catch (Exception ignore) {
                    LOG.unableToRollbackConnection(ignore);
                }
                if (e instanceof HibernateException) {
                    throw (HibernateException)e;
                }
                if (e instanceof SQLException) {
                    throw this.sqlExceptionHelper().convert((SQLException)e, "error performing isolated work");
                }
                throw new HibernateException("error performing isolated work", e);
            }
            finally {
                if (transacted && wasAutoCommit) {
                    try {
                        connection.setAutoCommit(true);
                    }
                    catch (Exception ignore) {
                        LOG.trace("was unable to reset connection back to auto-commit");
                    }
                }
                try {
                    this.connectionProvider().closeConnection(connection);
                }
                catch (Exception ignore) {
                    LOG.unableToReleaseIsolatedConnection(ignore);
                }
            }
        }
        catch (SQLException sqle) {
            throw this.sqlExceptionHelper().convert(sqle, "unable to obtain isolated JDBC connection");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T delegateWork(ReturningWork<T> work, boolean transacted) throws HibernateException {
        boolean wasAutoCommit = false;
        try {
            Connection connection = this.connectionProvider().getConnection();
            try {
                if (transacted && connection.getAutoCommit()) {
                    wasAutoCommit = true;
                    connection.setAutoCommit(false);
                }
                T result = work.execute(connection);
                if (transacted) {
                    connection.commit();
                }
                T t = result;
                return t;
            }
            catch (Exception e) {
                try {
                    if (transacted && !connection.isClosed()) {
                        connection.rollback();
                    }
                }
                catch (Exception ignore) {
                    LOG.unableToRollbackConnection(ignore);
                }
                if (e instanceof HibernateException) {
                    throw (HibernateException)e;
                }
                if (!(e instanceof SQLException)) throw new HibernateException("error performing isolated work", e);
                throw this.sqlExceptionHelper().convert((SQLException)e, "error performing isolated work");
            }
            finally {
                if (transacted && wasAutoCommit) {
                    try {
                        connection.setAutoCommit(true);
                    }
                    catch (Exception ignore) {
                        LOG.trace("was unable to reset connection back to auto-commit");
                    }
                }
                try {
                    this.connectionProvider().closeConnection(connection);
                }
                catch (Exception ignore) {
                    LOG.unableToReleaseIsolatedConnection(ignore);
                }
            }
        }
        catch (SQLException sqle) {
            throw this.sqlExceptionHelper().convert(sqle, "unable to obtain isolated JDBC connection");
        }
    }
}

