/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal.proxy;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Arrays;
import org.hibernate.HibernateLogger;
import org.hibernate.engine.jdbc.internal.proxy.AbstractStatementProxyHandler;
import org.hibernate.engine.jdbc.internal.proxy.ConnectionProxyHandler;
import org.jboss.logging.Logger;

public class PreparedStatementProxyHandler
extends AbstractStatementProxyHandler {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)PreparedStatementProxyHandler.class.getName());
    private final String sql;

    protected PreparedStatementProxyHandler(String sql, Statement statement, ConnectionProxyHandler connectionProxyHandler, Connection connectionProxy) {
        super(statement, connectionProxyHandler, connectionProxy);
        connectionProxyHandler.getJdbcServices().getSqlStatementLogger().logStatement(sql);
        this.sql = sql;
    }

    @Override
    protected void beginningInvocationHandling(Method method, Object[] args) {
        if (this.isExecution(method)) {
            this.logExecution();
        } else {
            this.journalPossibleParameterBind(method, args);
        }
    }

    private void journalPossibleParameterBind(Method method, Object[] args) {
        String methodName = method.getName();
        if (methodName.startsWith("set") && args != null && args.length >= 2) {
            this.journalParameterBind(method, args);
        }
    }

    private void journalParameterBind(Method method, Object[] args) {
        LOG.trace("Binding via " + method.getName() + ": " + Arrays.asList(args));
    }

    private boolean isExecution(Method method) {
        return false;
    }

    private void logExecution() {
    }
}

