/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.batch.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.engine.jdbc.batch.internal.AbstractBatchImpl;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.jboss.logging.Logger;

public class BatchingBatch
extends AbstractBatchImpl {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)BatchingBatch.class.getName());
    private final int batchSize;
    private int batchPosition;
    private int statementPosition;
    private String currentStatementSql;
    private PreparedStatement currentStatement;

    public BatchingBatch(BatchKey key, JdbcCoordinator jdbcCoordinator, int batchSize) {
        super(key, jdbcCoordinator);
        if (!key.getExpectation().canBeBatched()) {
            throw new HibernateException("attempting to batch an operation which cannot be batched");
        }
        this.batchSize = batchSize;
    }

    @Override
    public PreparedStatement getBatchStatement(String sql, boolean callable) {
        this.currentStatementSql = sql;
        this.currentStatement = super.getBatchStatement(sql, callable);
        return this.currentStatement;
    }

    @Override
    public void addToBatch() {
        try {
            this.currentStatement.addBatch();
        }
        catch (SQLException e) {
            LOG.debugf("SQLException escaped proxy", e);
            throw this.sqlExceptionHelper().convert(e, "could not perform addBatch", this.currentStatementSql);
        }
        ++this.statementPosition;
        if (this.statementPosition >= this.getKey().getBatchedStatementCount()) {
            ++this.batchPosition;
            if (this.batchPosition == this.batchSize) {
                this.notifyObserversImplicitExecution();
                this.performExecution();
                this.batchPosition = 0;
            }
            this.statementPosition = 0;
        }
    }

    @Override
    protected void doExecuteBatch() {
        if (this.batchPosition == 0) {
            LOG.debugf("No batched statements to execute", new Object[0]);
        } else {
            LOG.debugf("Executing batch size: %s", this.batchPosition);
            this.performExecution();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performExecution() {
        try {
            for (Map.Entry<String, PreparedStatement> entry : this.getStatements().entrySet()) {
                try {
                    PreparedStatement statement = entry.getValue();
                    this.checkRowCounts(statement.executeBatch(), statement);
                }
                catch (SQLException e) {
                    LOG.debugf("SQLException escaped proxy", e);
                    throw this.sqlExceptionHelper().convert(e, "could not perform addBatch", entry.getKey());
                    return;
                }
            }
        }
        catch (RuntimeException re) {
            LOG.unableToExecuteBatch(re.getMessage());
            throw re;
        }
        finally {
            this.batchPosition = 0;
        }
    }

    private void checkRowCounts(int[] rowCounts, PreparedStatement ps) throws SQLException, HibernateException {
        int numberOfRowCounts = rowCounts.length;
        if (numberOfRowCounts != this.batchPosition) {
            LOG.unexpectedRowCounts();
        }
        for (int i = 0; i < numberOfRowCounts; ++i) {
            this.getKey().getExpectation().verifyOutcome(rowCounts[i], ps, i);
        }
    }
}

