/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.MappingException;
import org.hibernate.internal.util.StringHelper;

public class TypeNames {
    private Map<Integer, Map<Integer, String>> weighted = new HashMap<Integer, Map<Integer, String>>();
    private Map<Integer, String> defaults = new HashMap<Integer, String>();

    public String get(int typecode) throws MappingException {
        String result = this.defaults.get(typecode);
        if (result == null) {
            throw new MappingException("No Dialect mapping for JDBC type: " + typecode);
        }
        return result;
    }

    public String get(int typecode, int size, int precision, int scale) throws MappingException {
        Map<Integer, String> map = this.weighted.get(typecode);
        if (map != null && map.size() > 0) {
            for (Map.Entry<Integer, String> entry : map.entrySet()) {
                if (size > entry.getKey()) continue;
                return TypeNames.replace(entry.getValue(), size, precision, scale);
            }
        }
        return TypeNames.replace(this.get(typecode), size, precision, scale);
    }

    private static String replace(String type, int size, int precision, int scale) {
        type = StringHelper.replaceOnce(type, "$s", Integer.toString(scale));
        type = StringHelper.replaceOnce(type, "$l", Integer.toString(size));
        return StringHelper.replaceOnce(type, "$p", Integer.toString(precision));
    }

    public void put(int typecode, int capacity, String value) {
        Map<Integer, String> map = this.weighted.get(typecode);
        if (map == null) {
            map = new TreeMap<Integer, String>();
            this.weighted.put(typecode, map);
        }
        map.put(new Integer(capacity), value);
    }

    public void put(int typecode, String value) {
        this.defaults.put(typecode, value);
    }
}

