/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.bytecode.BytecodeProvider;
import org.hibernate.bytecode.cglib.BytecodeProviderImpl;
import org.hibernate.cache.QueryCacheFactory;
import org.hibernate.cache.RegionFactory;
import org.hibernate.cache.impl.NoCachingRegionFactory;
import org.hibernate.cache.impl.bridge.RegionFactoryCacheProviderBridge;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.jdbc.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.hql.QueryTranslatorFactory;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.hibernate.service.spi.ServiceRegistry;
import org.jboss.logging.Logger;

public class SettingsFactory
implements Serializable {
    private static final long serialVersionUID = -1194386144994524825L;
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)SettingsFactory.class.getName());
    public static final String DEF_CACHE_REG_FACTORY = NoCachingRegionFactory.class.getName();

    protected SettingsFactory() {
    }

    public Settings buildSettings(Properties props, ServiceRegistry serviceRegistry) {
        ConnectionReleaseMode releaseMode;
        JdbcServices jdbcServices = serviceRegistry.getService(JdbcServices.class);
        Settings settings = new Settings();
        String sessionFactoryName = props.getProperty("hibernate.session_factory_name");
        settings.setSessionFactoryName(sessionFactoryName);
        ExtractedDatabaseMetaData meta = jdbcServices.getExtractedMetaDataSupport();
        settings.setDataDefinitionImplicitCommit(meta.doesDataDefinitionCauseTransactionCommit());
        settings.setDataDefinitionInTransactionSupported(meta.supportsDataDefinitionInTransaction());
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)jdbcServices.getDialect().getDefaultProperties());
        properties.putAll((Map<?, ?>)props);
        settings.setJtaPlatform(serviceRegistry.getService(JtaPlatform.class));
        boolean flushBeforeCompletion = ConfigurationHelper.getBoolean("hibernate.transaction.flush_before_completion", properties);
        LOG.autoFlush(SettingsFactory.enabledDisabled(flushBeforeCompletion));
        settings.setFlushBeforeCompletionEnabled(flushBeforeCompletion);
        boolean autoCloseSession = ConfigurationHelper.getBoolean("hibernate.transaction.auto_close_session", properties);
        LOG.autoSessionClose(SettingsFactory.enabledDisabled(autoCloseSession));
        settings.setAutoCloseSessionEnabled(autoCloseSession);
        int batchSize = ConfigurationHelper.getInt("hibernate.jdbc.batch_size", properties, 0);
        if (!meta.supportsBatchUpdates()) {
            batchSize = 0;
        }
        if (batchSize > 0) {
            LOG.jdbcBatchSize(batchSize);
        }
        settings.setJdbcBatchSize(batchSize);
        boolean jdbcBatchVersionedData = ConfigurationHelper.getBoolean("hibernate.jdbc.batch_versioned_data", properties, false);
        if (batchSize > 0) {
            LOG.jdbcBatchUpdates(SettingsFactory.enabledDisabled(jdbcBatchVersionedData));
        }
        settings.setJdbcBatchVersionedData(jdbcBatchVersionedData);
        boolean useScrollableResultSets = ConfigurationHelper.getBoolean("hibernate.jdbc.use_scrollable_resultset", properties, meta.supportsScrollableResults());
        LOG.scrollabelResultSets(SettingsFactory.enabledDisabled(useScrollableResultSets));
        settings.setScrollableResultSetsEnabled(useScrollableResultSets);
        boolean wrapResultSets = ConfigurationHelper.getBoolean("hibernate.jdbc.wrap_result_sets", properties, false);
        LOG.wrapResultSets(SettingsFactory.enabledDisabled(wrapResultSets));
        settings.setWrapResultSetsEnabled(wrapResultSets);
        boolean useGetGeneratedKeys = ConfigurationHelper.getBoolean("hibernate.jdbc.use_get_generated_keys", properties, meta.supportsGetGeneratedKeys());
        LOG.jdbc3GeneratedKeys(SettingsFactory.enabledDisabled(useGetGeneratedKeys));
        settings.setGetGeneratedKeysEnabled(useGetGeneratedKeys);
        Integer statementFetchSize = ConfigurationHelper.getInteger("hibernate.jdbc.fetch_size", properties);
        if (statementFetchSize != null) {
            LOG.jdbcResultSetFetchSize(statementFetchSize);
        }
        settings.setJdbcFetchSize(statementFetchSize);
        String releaseModeName = ConfigurationHelper.getString("hibernate.connection.release_mode", properties, "auto");
        LOG.connectionReleaseMode(releaseModeName);
        if ("auto".equals(releaseModeName)) {
            releaseMode = serviceRegistry.getService(TransactionFactory.class).getDefaultReleaseMode();
        } else {
            releaseMode = ConnectionReleaseMode.parse(releaseModeName);
            if (releaseMode == ConnectionReleaseMode.AFTER_STATEMENT && !jdbcServices.getConnectionProvider().supportsAggressiveRelease()) {
                LOG.unsupportedAfterStatement();
                releaseMode = ConnectionReleaseMode.AFTER_TRANSACTION;
            }
        }
        settings.setConnectionReleaseMode(releaseMode);
        String defaultSchema = properties.getProperty("hibernate.default_schema");
        String defaultCatalog = properties.getProperty("hibernate.default_catalog");
        if (defaultSchema != null) {
            LOG.defaultSchema(defaultSchema);
        }
        if (defaultCatalog != null) {
            LOG.defaultCatalog(defaultCatalog);
        }
        settings.setDefaultSchemaName(defaultSchema);
        settings.setDefaultCatalogName(defaultCatalog);
        Integer maxFetchDepth = ConfigurationHelper.getInteger("hibernate.max_fetch_depth", properties);
        if (maxFetchDepth != null) {
            LOG.maxOuterJoinFetchDepth(maxFetchDepth);
        }
        settings.setMaximumFetchDepth(maxFetchDepth);
        int batchFetchSize = ConfigurationHelper.getInt("hibernate.default_batch_fetch_size", properties, 1);
        LOG.defaultBatchFetchSize(batchFetchSize);
        settings.setDefaultBatchFetchSize(batchFetchSize);
        boolean comments = ConfigurationHelper.getBoolean("hibernate.use_sql_comments", properties);
        LOG.generateSqlWithComments(SettingsFactory.enabledDisabled(comments));
        settings.setCommentsEnabled(comments);
        boolean orderUpdates = ConfigurationHelper.getBoolean("hibernate.order_updates", properties);
        LOG.orderSqlUpdatesByPrimaryKey(SettingsFactory.enabledDisabled(orderUpdates));
        settings.setOrderUpdatesEnabled(orderUpdates);
        boolean orderInserts = ConfigurationHelper.getBoolean("hibernate.order_inserts", properties);
        LOG.orderSqlInsertsForBatching(SettingsFactory.enabledDisabled(orderInserts));
        settings.setOrderInsertsEnabled(orderInserts);
        settings.setQueryTranslatorFactory(this.createQueryTranslatorFactory(properties));
        Map querySubstitutions = ConfigurationHelper.toMap("hibernate.query.substitutions", " ,=;:\n\t\r\f", properties);
        LOG.queryLanguageSubstitutions(querySubstitutions);
        settings.setQuerySubstitutions(querySubstitutions);
        boolean jpaqlCompliance = ConfigurationHelper.getBoolean("hibernate.query.jpaql_strict_compliance", properties, false);
        settings.setStrictJPAQLCompliance(jpaqlCompliance);
        LOG.jpaQlStrictCompliance(SettingsFactory.enabledDisabled(jpaqlCompliance));
        boolean useSecondLevelCache = ConfigurationHelper.getBoolean("hibernate.cache.use_second_level_cache", properties, true);
        LOG.secondLevelCache(SettingsFactory.enabledDisabled(useSecondLevelCache));
        settings.setSecondLevelCacheEnabled(useSecondLevelCache);
        boolean useQueryCache = ConfigurationHelper.getBoolean("hibernate.cache.use_query_cache", properties);
        LOG.queryCache(SettingsFactory.enabledDisabled(useQueryCache));
        settings.setQueryCacheEnabled(useQueryCache);
        settings.setRegionFactory(SettingsFactory.createRegionFactory(properties, useSecondLevelCache || useQueryCache));
        boolean useMinimalPuts = ConfigurationHelper.getBoolean("hibernate.cache.use_minimal_puts", properties, settings.getRegionFactory().isMinimalPutsEnabledByDefault());
        LOG.optimizeCacheForMinimalInputs(SettingsFactory.enabledDisabled(useMinimalPuts));
        settings.setMinimalPutsEnabled(useMinimalPuts);
        String prefix = properties.getProperty("hibernate.cache.region_prefix");
        if (StringHelper.isEmpty(prefix)) {
            prefix = null;
        }
        if (prefix != null) {
            LOG.cacheRegionPrefix(prefix);
        }
        settings.setCacheRegionPrefix(prefix);
        boolean useStructuredCacheEntries = ConfigurationHelper.getBoolean("hibernate.cache.use_structured_entries", properties, false);
        LOG.structuredSecondLevelCacheEntries(SettingsFactory.enabledDisabled(useStructuredCacheEntries));
        settings.setStructuredCacheEntriesEnabled(useStructuredCacheEntries);
        if (useQueryCache) {
            settings.setQueryCacheFactory(this.createQueryCacheFactory(properties));
        }
        boolean useStatistics = ConfigurationHelper.getBoolean("hibernate.generate_statistics", properties);
        LOG.statistics(SettingsFactory.enabledDisabled(useStatistics));
        settings.setStatisticsEnabled(useStatistics);
        boolean useIdentifierRollback = ConfigurationHelper.getBoolean("hibernate.use_identifier_rollback", properties);
        LOG.deletedEntitySyntheticIdentifierRollback(SettingsFactory.enabledDisabled(useIdentifierRollback));
        settings.setIdentifierRollbackEnabled(useIdentifierRollback);
        String autoSchemaExport = properties.getProperty("hibernate.hbm2ddl.auto");
        if ("validate".equals(autoSchemaExport)) {
            settings.setAutoValidateSchema(true);
        }
        if ("update".equals(autoSchemaExport)) {
            settings.setAutoUpdateSchema(true);
        }
        if ("create".equals(autoSchemaExport)) {
            settings.setAutoCreateSchema(true);
        }
        if ("create-drop".equals(autoSchemaExport)) {
            settings.setAutoCreateSchema(true);
            settings.setAutoDropSchema(true);
        }
        settings.setImportFiles(properties.getProperty("hibernate.hbm2ddl.import_files"));
        EntityMode defaultEntityMode = EntityMode.parse(properties.getProperty("hibernate.default_entity_mode"));
        LOG.defaultEntityMode(defaultEntityMode);
        settings.setDefaultEntityMode(defaultEntityMode);
        boolean namedQueryChecking = ConfigurationHelper.getBoolean("hibernate.query.startup_check", properties, true);
        LOG.namedQueryChecking(SettingsFactory.enabledDisabled(namedQueryChecking));
        settings.setNamedQueryStartupCheckingEnabled(namedQueryChecking);
        boolean checkNullability = ConfigurationHelper.getBoolean("hibernate.check_nullability", properties, true);
        LOG.checkNullability(SettingsFactory.enabledDisabled(checkNullability));
        settings.setCheckNullability(checkNullability);
        return settings;
    }

    protected BytecodeProvider buildBytecodeProvider(String providerName) {
        if ("javassist".equals(providerName)) {
            return new org.hibernate.bytecode.javassist.BytecodeProviderImpl();
        }
        if ("cglib".equals(providerName)) {
            return new BytecodeProviderImpl();
        }
        LOG.debugf("Using javassist as bytecode provider by default", new Object[0]);
        return new org.hibernate.bytecode.javassist.BytecodeProviderImpl();
    }

    private static String enabledDisabled(boolean value) {
        return value ? "enabled" : "disabled";
    }

    protected QueryCacheFactory createQueryCacheFactory(Properties properties) {
        String queryCacheFactoryClassName = ConfigurationHelper.getString("hibernate.cache.query_cache_factory", properties, "org.hibernate.cache.StandardQueryCacheFactory");
        LOG.queryCacheFactory(queryCacheFactoryClassName);
        try {
            return (QueryCacheFactory)ReflectHelper.classForName(queryCacheFactoryClassName).newInstance();
        }
        catch (Exception cnfe) {
            throw new HibernateException("could not instantiate QueryCacheFactory: " + queryCacheFactoryClassName, cnfe);
        }
    }

    public static RegionFactory createRegionFactory(Properties properties, boolean cachingEnabled) {
        String providerClassName;
        String regionFactoryClassName = ConfigurationHelper.getString("hibernate.cache.region.factory_class", properties, null);
        if (regionFactoryClassName == null && cachingEnabled && (providerClassName = ConfigurationHelper.getString("hibernate.cache.provider_class", properties, null)) != null) {
            regionFactoryClassName = RegionFactoryCacheProviderBridge.class.getName();
        }
        if (regionFactoryClassName == null) {
            regionFactoryClassName = DEF_CACHE_REG_FACTORY;
        }
        LOG.cacheRegionFactory(regionFactoryClassName);
        try {
            try {
                return (RegionFactory)ReflectHelper.classForName(regionFactoryClassName).getConstructor(Properties.class).newInstance(properties);
            }
            catch (NoSuchMethodException nsme) {
                LOG.constructorWithPropertiesNotFound(regionFactoryClassName);
                return (RegionFactory)ReflectHelper.classForName(regionFactoryClassName).newInstance();
            }
        }
        catch (Exception e) {
            throw new HibernateException("could not instantiate RegionFactory [" + regionFactoryClassName + "]", e);
        }
    }

    protected QueryTranslatorFactory createQueryTranslatorFactory(Properties properties) {
        String className = ConfigurationHelper.getString("hibernate.query.factory_class", properties, "org.hibernate.hql.ast.ASTQueryTranslatorFactory");
        LOG.queryTranslator(className);
        try {
            return (QueryTranslatorFactory)ReflectHelper.classForName(className).newInstance();
        }
        catch (Exception cnfe) {
            throw new HibernateException("could not instantiate QueryTranslatorFactory: " + className, cnfe);
        }
    }
}

