/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.impl.bridge;

import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.cfg.Settings;

public class CollectionAccessStrategyAdapter
implements CollectionRegionAccessStrategy {
    private final CollectionRegion region;
    private final CacheConcurrencyStrategy ccs;
    private final Settings settings;

    public CollectionAccessStrategyAdapter(CollectionRegion region, CacheConcurrencyStrategy ccs, Settings settings) {
        this.region = region;
        this.ccs = ccs;
        this.settings = settings;
    }

    @Override
    public CollectionRegion getRegion() {
        return this.region;
    }

    @Override
    public Object get(Object key, long txTimestamp) throws CacheException {
        return this.ccs.get(key, txTimestamp);
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.putFromLoad(key, value, txTimestamp, version, this.settings.isMinimalPutsEnabled());
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.ccs.put(key, value, txTimestamp, version, this.region.getCacheDataDescription().getVersionComparator(), minimalPutOverride);
    }

    @Override
    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return this.ccs.lock(key, version);
    }

    @Override
    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        this.ccs.release(key, lock);
    }

    @Override
    public void unlockRegion(SoftLock lock) throws CacheException {
        if (!this.region.isTransactionAware()) {
            this.ccs.clear();
        }
    }

    @Override
    public void remove(Object key) throws CacheException {
        this.ccs.evict(key);
    }

    @Override
    public void removeAll() throws CacheException {
        this.ccs.clear();
    }

    @Override
    public void evict(Object key) throws CacheException {
        this.ccs.remove(key);
    }

    @Override
    public void evictAll() throws CacheException {
        this.ccs.clear();
    }

    public void destroy() {
        this.ccs.destroy();
    }
}

