/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Comparator;
import org.hibernate.HibernateLogger;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.OptimisticCache;
import org.hibernate.cache.access.SoftLock;
import org.jboss.logging.Logger;

public class TransactionalCache
implements CacheConcurrencyStrategy {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)TransactionalCache.class.getName());
    private Cache cache;

    @Override
    public String getRegionName() {
        return this.cache.getRegionName();
    }

    @Override
    public Object get(Object key, long txTimestamp) throws CacheException {
        LOG.debugf("Cache lookup: %s", key);
        Object result = this.cache.read(key);
        if (result == null) {
            LOG.debugf("Cache miss: %s", key);
        } else {
            LOG.debugf("Cache hit: %s", key);
        }
        return result;
    }

    @Override
    public boolean put(Object key, Object value, long txTimestamp, Object version, Comparator versionComparator, boolean minimalPut) throws CacheException {
        if (minimalPut && this.cache.read(key) != null) {
            LOG.debugf("Item already cached: %s", key);
            return false;
        }
        LOG.debugf("Caching: %s", key);
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeLoad(key, value, version);
        } else {
            this.cache.put(key, value);
        }
        return true;
    }

    @Override
    public SoftLock lock(Object key, Object version) throws CacheException {
        return null;
    }

    @Override
    public void release(Object key, SoftLock clientLock) throws CacheException {
    }

    @Override
    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        LOG.debugf("Updating: %s", key);
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeUpdate(key, value, currentVersion, previousVersion);
        } else {
            this.cache.update(key, value);
        }
        return true;
    }

    @Override
    public boolean insert(Object key, Object value, Object currentVersion) throws CacheException {
        LOG.debugf("Inserting: %s", key);
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeInsert(key, value, currentVersion);
        } else {
            this.cache.update(key, value);
        }
        return true;
    }

    @Override
    public void evict(Object key) throws CacheException {
        this.cache.remove(key);
    }

    @Override
    public void remove(Object key) throws CacheException {
        LOG.debugf("Removing: %s", key);
        this.cache.remove(key);
    }

    @Override
    public void clear() throws CacheException {
        LOG.debugf("Clearing", new Object[0]);
        this.cache.clear();
    }

    @Override
    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            LOG.unableToDestroyCache(e.getMessage());
        }
    }

    @Override
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    @Override
    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    @Override
    public boolean afterUpdate(Object key, Object value, Object version, SoftLock clientLock) throws CacheException {
        return false;
    }

    public String toString() {
        return this.cache + "(transactional)";
    }
}

