/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.Comparator;
import org.hibernate.HibernateLogger;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;
import org.jboss.logging.Logger;

public class ReadWriteCache
implements CacheConcurrencyStrategy {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)ReadWriteCache.class.getName());
    private Cache cache;
    private int nextLockId;

    @Override
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    @Override
    public String getRegionName() {
        return this.cache.getRegionName();
    }

    private int nextLockId() {
        if (this.nextLockId == Integer.MAX_VALUE) {
            this.nextLockId = Integer.MIN_VALUE;
        }
        return this.nextLockId++;
    }

    @Override
    public synchronized Object get(Object key, long txTimestamp) throws CacheException {
        boolean gettable;
        LOG.debugf("Cache lookup: %s", key);
        Lockable lockable = (Lockable)this.cache.get(key);
        boolean bl = gettable = lockable != null && lockable.isGettable(txTimestamp);
        if (gettable) {
            LOG.debugf("Cache hit: %s", key);
            return ((Item)lockable).getValue();
        }
        if (lockable == null) {
            LOG.debugf("Cache miss: %s", key);
        } else {
            LOG.debugf("Cached item was locked: %s", key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SoftLock lock(Object key, Object version) throws CacheException {
        LOG.debugf("Invalidating: %s", key);
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            long timeout = this.cache.nextTimestamp() + (long)this.cache.getTimeout();
            Lock lock = lockable == null ? new Lock(timeout, this.nextLockId(), version) : lockable.lock(timeout, this.nextLockId());
            this.cache.update(key, lock);
            Lock lock2 = lock;
            return lock2;
        }
        finally {
            this.cache.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean put(Object key, Object value, long txTimestamp, Object version, Comparator versionComparator, boolean minimalPut) throws CacheException {
        LOG.debugf("Caching: %s", key);
        try {
            boolean puttable;
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            boolean bl = puttable = lockable == null || lockable.isPuttable(txTimestamp, version, versionComparator);
            if (puttable) {
                this.cache.put(key, new Item(value, version, this.cache.nextTimestamp()));
                LOG.debugf("Cached: %s", key);
                boolean bl2 = true;
                return bl2;
            }
            if (lockable.isLock()) {
                LOG.debugf("Cached item was locked: %s", key);
            } else {
                LOG.debugf("Item already cached: %s", key);
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.cache.unlock(key);
        }
    }

    private void decrementLock(Object key, Lock lock) throws CacheException {
        lock.unlock(this.cache.nextTimestamp());
        this.cache.update(key, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void release(Object key, SoftLock clientLock) throws CacheException {
        LOG.debugf("Releasing: %s", key);
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            if (this.isUnlockable(clientLock, lockable)) {
                this.decrementLock(key, (Lock)lockable);
            } else {
                this.handleLockExpiry(key);
            }
        }
        finally {
            this.cache.unlock(key);
        }
    }

    void handleLockExpiry(Object key) throws CacheException {
        LOG.expired(key);
        long ts = this.cache.nextTimestamp() + (long)this.cache.getTimeout();
        Lock lock = new Lock(ts, this.nextLockId(), null);
        lock.unlock(ts);
        this.cache.update(key, lock);
    }

    @Override
    public void clear() throws CacheException {
        this.cache.clear();
    }

    @Override
    public void remove(Object key) throws CacheException {
        this.cache.remove(key);
    }

    @Override
    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            LOG.unableToDestroyCache(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean afterUpdate(Object key, Object value, Object version, SoftLock clientLock) throws CacheException {
        LOG.debugf("Updating: %s", key);
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            if (this.isUnlockable(clientLock, lockable)) {
                Lock lock = (Lock)lockable;
                if (lock.wasLockedConcurrently()) {
                    this.decrementLock(key, lock);
                    boolean bl = false;
                    return bl;
                }
                this.cache.update(key, new Item(value, version, this.cache.nextTimestamp()));
                LOG.debugf("Updated: %s", key);
                boolean bl = true;
                return bl;
            }
            this.handleLockExpiry(key);
            boolean bl = false;
            return bl;
        }
        finally {
            this.cache.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        LOG.debugf("Inserting: %s", key);
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            if (lockable == null) {
                this.cache.update(key, new Item(value, version, this.cache.nextTimestamp()));
                LOG.debugf("Inserted: %s", key);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.cache.unlock(key);
        }
    }

    @Override
    public void evict(Object key) throws CacheException {
    }

    @Override
    public boolean insert(Object key, Object value, Object currentVersion) {
        return false;
    }

    @Override
    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) {
        return false;
    }

    private boolean isUnlockable(SoftLock clientLock, Lockable myLock) throws CacheException {
        return myLock != null && myLock.isLock() && clientLock != null && ((Lock)clientLock).getId() == ((Lock)myLock).getId();
    }

    public String toString() {
        return this.cache + "(read-write)";
    }

    public static final class Lock
    implements Serializable,
    Lockable,
    SoftLock {
        private long unlockTimestamp = -1L;
        private int multiplicity = 1;
        private boolean concurrentLock = false;
        private long timeout;
        private final int id;
        private final Object version;

        public Lock(long timeout, int id, Object version) {
            this.timeout = timeout;
            this.id = id;
            this.version = version;
        }

        public long getUnlockTimestamp() {
            return this.unlockTimestamp;
        }

        @Override
        public Lock lock(long timeout, int id) {
            this.concurrentLock = true;
            ++this.multiplicity;
            this.timeout = timeout;
            return this;
        }

        public void unlock(long currentTimestamp) {
            if (--this.multiplicity == 0) {
                this.unlockTimestamp = currentTimestamp;
            }
        }

        @Override
        public boolean isPuttable(long txTimestamp, Object newVersion, Comparator comparator) {
            if (this.timeout < txTimestamp) {
                return true;
            }
            if (this.multiplicity > 0) {
                return false;
            }
            return this.version == null ? this.unlockTimestamp < txTimestamp : comparator.compare(this.version, newVersion) < 0;
        }

        public boolean wasLockedConcurrently() {
            return this.concurrentLock;
        }

        @Override
        public boolean isLock() {
            return true;
        }

        @Override
        public boolean isGettable(long txTimestamp) {
            return false;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "Lock{id=" + this.id + ",version=" + this.version + ",multiplicity=" + this.multiplicity + ",unlockTimestamp=" + this.unlockTimestamp;
        }
    }

    public static final class Item
    implements Serializable,
    Lockable {
        private final long freshTimestamp;
        private final Object value;
        private final Object version;

        public Item(Object value, Object version, long currentTimestamp) {
            this.value = value;
            this.version = version;
            this.freshTimestamp = currentTimestamp;
        }

        public long getFreshTimestamp() {
            return this.freshTimestamp;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public Lock lock(long timeout, int id) {
            return new Lock(timeout, id, this.version);
        }

        @Override
        public boolean isLock() {
            return false;
        }

        @Override
        public boolean isGettable(long txTimestamp) {
            return this.freshTimestamp < txTimestamp;
        }

        @Override
        public boolean isPuttable(long txTimestamp, Object newVersion, Comparator comparator) {
            return this.version != null && comparator.compare(this.version, newVersion) < 0;
        }

        public String toString() {
            return "Item{version=" + this.version + ",freshTimestamp=" + this.freshTimestamp;
        }
    }

    public static interface Lockable {
        public Lock lock(long var1, int var3);

        public boolean isLock();

        public boolean isGettable(long var1);

        public boolean isPuttable(long var1, Object var3, Comparator var4);
    }
}

