/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.HibernateLogger;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.jndi.JndiHelper;
import org.jboss.logging.Logger;

public abstract class AbstractJndiBoundCacheProvider
implements CacheProvider {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)AbstractJndiBoundCacheProvider.class.getName());
    private Object cache;

    protected void prepare(Properties properties) {
    }

    protected void release() {
    }

    @Override
    public final void start(Properties properties) throws CacheException {
        String jndiNamespace = properties.getProperty("hibernate.cache.jndi");
        if (StringHelper.isEmpty(jndiNamespace)) {
            throw new CacheException("No JNDI namespace specified for cache");
        }
        this.cache = this.locateCache(jndiNamespace, JndiHelper.extractJndiProperties(properties));
        this.prepare(properties);
    }

    @Override
    public final void stop() {
        this.release();
        this.cache = null;
    }

    private Object locateCache(String jndiNamespace, Properties jndiProperties) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext(jndiProperties);
            Object object = ctx.lookup(jndiNamespace);
            return object;
        }
        catch (NamingException ne) {
            String msg = "Unable to retreive Cache from JNDI [" + jndiNamespace + "]";
            LOG.unableToRetrieveCache(jndiNamespace, ne.getMessage());
            throw new CacheException(msg);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {
                    LOG.unableToReleaseContext(ne.getMessage());
                }
            }
        }
    }

    public Object getCache() {
        return this.cache;
    }
}

