/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.action.AfterTransactionCompletionProcess;
import org.hibernate.action.BeforeTransactionCompletionProcess;
import org.hibernate.action.DelayedPostInsertIdentifier;
import org.hibernate.action.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;

public abstract class CollectionAction
implements Executable,
Serializable,
Comparable {
    private transient CollectionPersister persister;
    private transient SessionImplementor session;
    private final PersistentCollection collection;
    private final Serializable key;
    private final String collectionRole;
    private AfterTransactionCompletionProcess afterTransactionProcess;

    public CollectionAction(CollectionPersister persister, PersistentCollection collection, Serializable key, SessionImplementor session) throws CacheException {
        this.persister = persister;
        this.session = session;
        this.key = key;
        this.collectionRole = persister.getRole();
        this.collection = collection;
    }

    protected PersistentCollection getCollection() {
        return this.collection;
    }

    public void afterDeserialize(SessionImplementor session) {
        if (this.session != null || this.persister != null) {
            throw new IllegalStateException("already attached to a session.");
        }
        if (session != null) {
            this.session = session;
            this.persister = session.getFactory().getCollectionPersister(this.collectionRole);
        }
    }

    @Override
    public final void beforeExecutions() throws CacheException {
        if (this.persister.hasCache()) {
            CacheKey ck = new CacheKey(this.key, this.persister.getKeyType(), this.persister.getRole(), this.session.getEntityMode(), this.session.getFactory());
            SoftLock lock = this.persister.getCacheAccessStrategy().lockItem(ck, null);
            this.afterTransactionProcess = new CacheCleanupProcess(this.key, this.persister, lock);
        }
    }

    @Override
    public BeforeTransactionCompletionProcess getBeforeTransactionCompletionProcess() {
        return null;
    }

    @Override
    public AfterTransactionCompletionProcess getAfterTransactionCompletionProcess() {
        return this.afterTransactionProcess;
    }

    @Override
    public Serializable[] getPropertySpaces() {
        return this.persister.getCollectionSpaces();
    }

    protected final CollectionPersister getPersister() {
        return this.persister;
    }

    protected final Serializable getKey() {
        Serializable finalKey = this.key;
        if (!(this.key instanceof DelayedPostInsertIdentifier) || (finalKey = this.session.getPersistenceContext().getEntry(this.collection.getOwner()).getId()) == this.key) {
            // empty if block
        }
        return finalKey;
    }

    protected final SessionImplementor getSession() {
        return this.session;
    }

    protected final void evict() throws CacheException {
        if (this.persister.hasCache()) {
            CacheKey ck = new CacheKey(this.key, this.persister.getKeyType(), this.persister.getRole(), this.session.getEntityMode(), this.session.getFactory());
            this.persister.getCacheAccessStrategy().remove(ck);
        }
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + MessageHelper.infoString(this.collectionRole, this.key);
    }

    public int compareTo(Object other) {
        CollectionAction action = (CollectionAction)other;
        int roleComparison = this.collectionRole.compareTo(action.collectionRole);
        if (roleComparison != 0) {
            return roleComparison;
        }
        return this.persister.getKeyType().compare(this.key, action.key, this.session.getEntityMode());
    }

    private static class CacheCleanupProcess
    implements AfterTransactionCompletionProcess {
        private final Serializable key;
        private final CollectionPersister persister;
        private final SoftLock lock;

        private CacheCleanupProcess(Serializable key, CollectionPersister persister, SoftLock lock) {
            this.key = key;
            this.persister = persister;
            this.lock = lock;
        }

        @Override
        public void doAfterTransactionCompletion(boolean success, SessionImplementor session) {
            CacheKey ck = new CacheKey(this.key, this.persister.getKeyType(), this.persister.getRole(), session.getEntityMode(), session.getFactory());
            this.persister.getCacheAccessStrategy().unlockItem(ck, this.lock);
        }
    }
}

