/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations.reflection;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EntityResult;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.FetchType;
import javax.persistence.FieldResult;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.MapKeyJoinColumns;
import javax.persistence.MapKeyTemporal;
import javax.persistence.MappedSuperclass;
import javax.persistence.MapsId;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.QueryHint;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.annotationfactory.AnnotationFactory;
import org.hibernate.annotations.common.reflection.AnnotationReader;
import org.hibernate.annotations.common.reflection.Filter;
import org.hibernate.annotations.common.reflection.ReflectionUtil;
import org.hibernate.cfg.annotations.reflection.XMLContext;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAOverridenAnnotationReader
implements AnnotationReader {
    private Logger log = LoggerFactory.getLogger(JPAOverridenAnnotationReader.class);
    private static final Map<Class, String> annotationToXml;
    private static final String SCHEMA_VALIDATION = "Activate schema validation for more information";
    private static final Filter FILTER;
    private XMLContext xmlContext;
    private String className;
    private String propertyName;
    private PropertyType propertyType;
    private transient Annotation[] annotations;
    private transient Map<Class, Annotation> annotationsMap;
    private static final String WORD_SEPARATOR = "-";
    private transient List<Element> elementsForProperty;
    private AccessibleObject mirroredAttribute;
    private final AnnotatedElement element;

    public JPAOverridenAnnotationReader(AnnotatedElement el, XMLContext xmlContext) {
        this.element = el;
        this.xmlContext = xmlContext;
        if (el instanceof Class) {
            Class clazz = (Class)el;
            this.className = clazz.getName();
        } else if (el instanceof Field) {
            Field field = (Field)el;
            this.className = field.getDeclaringClass().getName();
            this.propertyName = field.getName();
            this.propertyType = PropertyType.FIELD;
            String expectedGetter = "get" + Character.toUpperCase(this.propertyName.charAt(0)) + this.propertyName.substring(1);
            try {
                this.mirroredAttribute = field.getDeclaringClass().getDeclaredMethod(expectedGetter, new Class[0]);
            }
            catch (NoSuchMethodException e) {}
        } else if (el instanceof Method) {
            Method method = (Method)el;
            this.className = method.getDeclaringClass().getName();
            this.propertyName = method.getName();
            if (ReflectionUtil.isProperty((Method)method, null, (Filter)FILTER)) {
                if (this.propertyName.startsWith("get")) {
                    this.propertyName = Introspector.decapitalize(this.propertyName.substring("get".length()));
                } else if (this.propertyName.startsWith("is")) {
                    this.propertyName = Introspector.decapitalize(this.propertyName.substring("is".length()));
                } else {
                    throw new RuntimeException("Method " + this.propertyName + " is not a property getter");
                }
                this.propertyType = PropertyType.PROPERTY;
                try {
                    this.mirroredAttribute = method.getDeclaringClass().getDeclaredField(this.propertyName);
                }
                catch (NoSuchFieldException e) {}
            } else {
                this.propertyType = PropertyType.METHOD;
            }
        } else {
            this.className = null;
            this.propertyName = null;
        }
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        this.initAnnotations();
        return (T)this.annotationsMap.get(annotationType);
    }

    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationType) {
        this.initAnnotations();
        return this.annotationsMap.get(annotationType) != null;
    }

    public Annotation[] getAnnotations() {
        this.initAnnotations();
        return this.annotations;
    }

    private void initAnnotations() {
        block12: {
            if (this.annotations != null) break block12;
            XMLContext.Default defaults = this.xmlContext.getDefault(this.className);
            if (this.className != null && this.propertyName == null) {
                Element tree = this.xmlContext.getXMLTree(this.className);
                Annotation[] annotations = this.getJavaAnnotations();
                ArrayList<Annotation> annotationList = new ArrayList<Annotation>(annotations.length + 5);
                this.annotationsMap = new HashMap<Class, Annotation>(annotations.length + 5);
                for (Annotation annotation : annotations) {
                    if (annotationToXml.containsKey(annotation.annotationType())) continue;
                    annotationList.add(annotation);
                }
                this.addIfNotNull(annotationList, (Annotation)this.getEntity(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getMappedSuperclass(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getEmbeddable(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getTable(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getSecondaryTables(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getPrimaryKeyJoinColumns(tree, defaults, true));
                this.addIfNotNull(annotationList, (Annotation)this.getIdClass(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getInheritance(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getDiscriminatorValue(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getDiscriminatorColumn(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getSequenceGenerator(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getTableGenerator(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getNamedQueries(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getNamedNativeQueries(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getSqlResultSetMappings(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getExcludeDefaultListeners(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getExcludeSuperclassListeners(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getAccessType(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getAttributeOverrides(tree, defaults, true));
                this.addIfNotNull(annotationList, (Annotation)this.getAssociationOverrides(tree, defaults, true));
                this.addIfNotNull(annotationList, (Annotation)this.getEntityListeners(tree, defaults));
                this.annotations = annotationList.toArray(new Annotation[annotationList.size()]);
                for (Annotation ann : this.annotations) {
                    this.annotationsMap.put(ann.annotationType(), ann);
                }
                this.checkForOrphanProperties(tree);
            } else if (this.className != null) {
                Element tree = this.xmlContext.getXMLTree(this.className);
                Annotation[] annotations = this.getJavaAnnotations();
                ArrayList<Annotation> annotationList = new ArrayList<Annotation>(annotations.length + 5);
                this.annotationsMap = new HashMap<Class, Annotation>(annotations.length + 5);
                for (Annotation annotation : annotations) {
                    if (annotationToXml.containsKey(annotation.annotationType())) continue;
                    annotationList.add(annotation);
                }
                this.preCalculateElementsForProperty(tree);
                Transient transientAnn = this.getTransient(defaults);
                if (transientAnn != null) {
                    annotationList.add((Annotation)transientAnn);
                } else {
                    if (defaults.canUseJavaAnnotations()) {
                        Access annotation = this.getJavaAnnotation(Access.class);
                        this.addIfNotNull(annotationList, (Annotation)annotation);
                    }
                    this.getId(annotationList, defaults);
                    this.getEmbeddedId(annotationList, defaults);
                    this.getEmbedded(annotationList, defaults);
                    this.getBasic(annotationList, defaults);
                    this.getVersion(annotationList, defaults);
                    this.getAssociation(ManyToOne.class, annotationList, defaults);
                    this.getAssociation(OneToOne.class, annotationList, defaults);
                    this.getAssociation(OneToMany.class, annotationList, defaults);
                    this.getAssociation(ManyToMany.class, annotationList, defaults);
                    this.getElementCollection(annotationList, defaults);
                    this.addIfNotNull(annotationList, this.getSequenceGenerator(this.elementsForProperty, defaults));
                    this.addIfNotNull(annotationList, this.getTableGenerator(this.elementsForProperty, defaults));
                }
                this.processEventAnnotations(annotationList, defaults);
                for (Annotation ann : this.annotations = annotationList.toArray(new Annotation[annotationList.size()])) {
                    this.annotationsMap.put(ann.annotationType(), ann);
                }
            } else {
                this.annotations = this.getJavaAnnotations();
                this.annotationsMap = new HashMap<Class, Annotation>(this.annotations.length + 5);
                for (Annotation ann : this.annotations) {
                    this.annotationsMap.put(ann.annotationType(), ann);
                }
            }
        }
    }

    private void checkForOrphanProperties(Element tree) {
        Element element;
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(this.className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            return;
        }
        Element element2 = element = tree != null ? tree.element("attributes") : null;
        if (element != null) {
            HashSet<String> properties = new HashSet<String>();
            for (Field field : clazz.getFields()) {
                properties.add(field.getName());
            }
            for (AccessibleObject accessibleObject : clazz.getMethods()) {
                String name = ((Method)accessibleObject).getName();
                if (name.startsWith("get")) {
                    properties.add(Introspector.decapitalize(name.substring("get".length())));
                    continue;
                }
                if (!name.startsWith("is")) continue;
                properties.add(Introspector.decapitalize(name.substring("is".length())));
            }
            for (Element subelement : element.elements()) {
                String propertyName = subelement.attributeValue("name");
                if (properties.contains(propertyName)) continue;
                this.log.warn("Property {} not found in class but described in <mapping-file/> (possible typo error)", (Object)StringHelper.qualify(this.className, propertyName));
            }
        }
    }

    private Annotation addIfNotNull(List<Annotation> annotationList, Annotation annotation) {
        if (annotation != null) {
            annotationList.add(annotation);
        }
        return annotation;
    }

    private Annotation getTableGenerator(List<Element> elementsForProperty, XMLContext.Default defaults) {
        for (Element element : elementsForProperty) {
            Element subelement = element != null ? element.element(annotationToXml.get(TableGenerator.class)) : null;
            if (subelement == null) continue;
            return JPAOverridenAnnotationReader.buildTableGeneratorAnnotation(subelement, defaults);
        }
        if (elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(TableGenerator.class);
        }
        return null;
    }

    private Annotation getSequenceGenerator(List<Element> elementsForProperty, XMLContext.Default defaults) {
        for (Element element : elementsForProperty) {
            Element subelement = element != null ? element.element(annotationToXml.get(SequenceGenerator.class)) : null;
            if (subelement == null) continue;
            return JPAOverridenAnnotationReader.buildSequenceGeneratorAnnotation(subelement);
        }
        if (elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(SequenceGenerator.class);
        }
        return null;
    }

    private void processEventAnnotations(List<Annotation> annotationList, XMLContext.Default defaults) {
        boolean eventElement = false;
        for (Element element : this.elementsForProperty) {
            AnnotationDescriptor ad;
            String elementName = element.getName();
            if ("pre-persist".equals(elementName)) {
                ad = new AnnotationDescriptor(PrePersist.class);
                annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
                eventElement = true;
                continue;
            }
            if ("pre-remove".equals(elementName)) {
                ad = new AnnotationDescriptor(PreRemove.class);
                annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
                eventElement = true;
                continue;
            }
            if ("pre-update".equals(elementName)) {
                ad = new AnnotationDescriptor(PreUpdate.class);
                annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
                eventElement = true;
                continue;
            }
            if ("post-persist".equals(elementName)) {
                ad = new AnnotationDescriptor(PostPersist.class);
                annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
                eventElement = true;
                continue;
            }
            if ("post-remove".equals(elementName)) {
                ad = new AnnotationDescriptor(PostRemove.class);
                annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
                eventElement = true;
                continue;
            }
            if ("post-update".equals(elementName)) {
                ad = new AnnotationDescriptor(PostUpdate.class);
                annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
                eventElement = true;
                continue;
            }
            if (!"post-load".equals(elementName)) continue;
            ad = new AnnotationDescriptor(PostLoad.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            eventElement = true;
        }
        if (!eventElement && defaults.canUseJavaAnnotations()) {
            PrePersist ann = this.getJavaAnnotation(PrePersist.class);
            this.addIfNotNull(annotationList, (Annotation)ann);
            ann = this.getJavaAnnotation(PreRemove.class);
            this.addIfNotNull(annotationList, (Annotation)ann);
            ann = this.getJavaAnnotation(PreUpdate.class);
            this.addIfNotNull(annotationList, (Annotation)ann);
            ann = this.getJavaAnnotation(PostPersist.class);
            this.addIfNotNull(annotationList, (Annotation)ann);
            ann = this.getJavaAnnotation(PostRemove.class);
            this.addIfNotNull(annotationList, (Annotation)ann);
            ann = this.getJavaAnnotation(PostUpdate.class);
            this.addIfNotNull(annotationList, (Annotation)ann);
            ann = this.getJavaAnnotation(PostLoad.class);
            this.addIfNotNull(annotationList, (Annotation)ann);
        }
    }

    private EntityListeners getEntityListeners(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element("entity-listeners") : null;
        if (element != null) {
            ArrayList<Class> entityListenerClasses = new ArrayList<Class>();
            for (Element subelement : element.elements("entity-listener")) {
                String className = subelement.attributeValue("class");
                try {
                    entityListenerClasses.add(ReflectHelper.classForName(XMLContext.buildSafeClassName(className, defaults), this.getClass()));
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find " + element.getPath() + ".class: " + className, e);
                }
            }
            AnnotationDescriptor ad = new AnnotationDescriptor(EntityListeners.class);
            ad.setValue("value", (Object)entityListenerClasses.toArray(new Class[entityListenerClasses.size()]));
            return (EntityListeners)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(EntityListeners.class);
        }
        return null;
    }

    private JoinTable overridesDefaultsInJoinTable(Annotation annotation, XMLContext.Default defaults) {
        boolean defaultToJoinTable = !this.isJavaAnnotationPresent(JoinColumn.class) && !this.isJavaAnnotationPresent(JoinColumns.class);
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        defaultToJoinTable = defaultToJoinTable && (annotationClass == ManyToMany.class && StringHelper.isEmpty(((ManyToMany)annotation).mappedBy()) || annotationClass == OneToMany.class && StringHelper.isEmpty(((OneToMany)annotation).mappedBy()) || annotationClass == CollectionOfElements.class || annotationClass == ElementCollection.class);
        Class<JoinTable> annotationType = JoinTable.class;
        if (defaultToJoinTable && (StringHelper.isNotEmpty(defaults.getCatalog()) || StringHelper.isNotEmpty(defaults.getSchema()))) {
            JoinTable table;
            AnnotationDescriptor ad = new AnnotationDescriptor(annotationType);
            if (defaults.canUseJavaAnnotations() && (table = this.getJavaAnnotation(annotationType)) != null) {
                ad.setValue("name", (Object)table.name());
                ad.setValue("schema", (Object)table.schema());
                ad.setValue("catalog", (Object)table.catalog());
                ad.setValue("uniqueConstraints", (Object)table.uniqueConstraints());
                ad.setValue("joinColumns", (Object)table.joinColumns());
                ad.setValue("inverseJoinColumns", (Object)table.inverseJoinColumns());
            }
            if (StringHelper.isEmpty((String)ad.valueOf("schema")) && StringHelper.isNotEmpty(defaults.getSchema())) {
                ad.setValue("schema", (Object)defaults.getSchema());
            }
            if (StringHelper.isEmpty((String)ad.valueOf("catalog")) && StringHelper.isNotEmpty(defaults.getCatalog())) {
                ad.setValue("catalog", (Object)defaults.getCatalog());
            }
            return (JoinTable)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(annotationType);
        }
        return null;
    }

    private void getJoinTable(List<Annotation> annotationList, Element tree, XMLContext.Default defaults) {
        this.addIfNotNull(annotationList, (Annotation)this.buildJoinTable(tree, defaults));
    }

    private JoinTable buildJoinTable(Element tree, XMLContext.Default defaults) {
        Element subelement = tree == null ? null : tree.element("join-table");
        Class<JoinTable> annotationType = JoinTable.class;
        if (subelement == null) {
            return null;
        }
        AnnotationDescriptor annotation = new AnnotationDescriptor(annotationType);
        JPAOverridenAnnotationReader.copyStringAttribute(annotation, subelement, "name", false);
        JPAOverridenAnnotationReader.copyStringAttribute(annotation, subelement, "catalog", false);
        if (StringHelper.isNotEmpty(defaults.getCatalog()) && StringHelper.isEmpty((String)annotation.valueOf("catalog"))) {
            annotation.setValue("catalog", (Object)defaults.getCatalog());
        }
        JPAOverridenAnnotationReader.copyStringAttribute(annotation, subelement, "schema", false);
        if (StringHelper.isNotEmpty(defaults.getSchema()) && StringHelper.isEmpty((String)annotation.valueOf("schema"))) {
            annotation.setValue("schema", (Object)defaults.getSchema());
        }
        JPAOverridenAnnotationReader.buildUniqueConstraints(annotation, subelement);
        annotation.setValue("joinColumns", (Object)this.getJoinColumns(subelement, false));
        annotation.setValue("inverseJoinColumns", (Object)this.getJoinColumns(subelement, true));
        return (JoinTable)AnnotationFactory.create((AnnotationDescriptor)annotation);
    }

    private void getAssociation(Class<? extends Annotation> annotationType, List<Annotation> annotationList, XMLContext.Default defaults) {
        String xmlName = annotationToXml.get(annotationType);
        for (Element element : this.elementsForProperty) {
            if (!xmlName.equals(element.getName())) continue;
            AnnotationDescriptor ad = new AnnotationDescriptor(annotationType);
            this.addTargetClass(element, ad, "target-entity", defaults);
            this.getFetchType(ad, element);
            this.getCascades(ad, element, defaults);
            this.getJoinTable(annotationList, element, defaults);
            this.buildJoinColumns(annotationList, element);
            PrimaryKeyJoinColumns annotation = this.getPrimaryKeyJoinColumns(element, defaults, false);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            JPAOverridenAnnotationReader.copyBooleanAttribute(ad, element, "optional");
            JPAOverridenAnnotationReader.copyBooleanAttribute(ad, element, "orphan-removal");
            JPAOverridenAnnotationReader.copyStringAttribute(ad, element, "mapped-by", false);
            this.getOrderBy(annotationList, element);
            this.getMapKey(annotationList, element);
            this.getMapKeyClass(annotationList, element, defaults);
            this.getMapKeyColumn(annotationList, element);
            this.getOrderColumn(annotationList, element);
            this.getMapKeyTemporal(annotationList, element);
            this.getMapKeyEnumerated(annotationList, element);
            annotation = this.getMapKeyAttributeOverrides(element, defaults);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            this.buildMapKeyJoinColumns(annotationList, element);
            this.getAssociationId(annotationList, element);
            this.getMapsId(annotationList, element);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            this.getAccessType(annotationList, element);
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations()) {
            Annotation annotation = this.getJavaAnnotation(annotationType);
            if (annotation != null) {
                annotationList.add(annotation);
                annotation = this.overridesDefaultsInJoinTable(annotation, defaults);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(JoinColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(JoinColumns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(PrimaryKeyJoinColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(PrimaryKeyJoinColumns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(MapKey.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(OrderBy.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(AttributeOverride.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(AttributeOverrides.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(AssociationOverride.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(AssociationOverrides.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(Lob.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(Enumerated.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(Temporal.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(Column.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(Columns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(MapKeyClass.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(MapKeyTemporal.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(MapKeyEnumerated.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(MapKeyColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(MapKeyJoinColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(MapKeyJoinColumns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(OrderColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(Cascade.class);
                this.addIfNotNull(annotationList, annotation);
            } else if (this.isJavaAnnotationPresent(ElementCollection.class)) {
                annotation = this.overridesDefaultsInJoinTable((Annotation)this.getJavaAnnotation(ElementCollection.class), defaults);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(MapKey.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(OrderBy.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(AttributeOverride.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(AttributeOverrides.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(AssociationOverride.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(AssociationOverrides.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(Lob.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(Enumerated.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(Temporal.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(Column.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(OrderColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(MapKeyClass.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(MapKeyTemporal.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(MapKeyEnumerated.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(MapKeyColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(MapKeyJoinColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(MapKeyJoinColumns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(CollectionTable.class);
                this.addIfNotNull(annotationList, annotation);
            } else if (this.isJavaAnnotationPresent(CollectionOfElements.class)) {
                annotation = this.overridesDefaultsInJoinTable(this.getJavaAnnotation(CollectionOfElements.class), defaults);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(JoinColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(JoinColumns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(PrimaryKeyJoinColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(PrimaryKeyJoinColumns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(MapKey.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(OrderBy.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(AttributeOverride.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(AttributeOverrides.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(AssociationOverride.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(AssociationOverrides.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(Lob.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(Enumerated.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(Temporal.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(Column.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getJavaAnnotation(Columns.class);
                this.addIfNotNull(annotationList, annotation);
            }
        }
    }

    private void buildMapKeyJoinColumns(List<Annotation> annotationList, Element element) {
        MapKeyJoinColumn[] joinColumns = this.getMapKeyJoinColumns(element);
        if (joinColumns.length > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKeyJoinColumns.class);
            ad.setValue("value", (Object)joinColumns);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private MapKeyJoinColumn[] getMapKeyJoinColumns(Element element) {
        List subelements = element != null ? element.elements("map-key-join-column") : null;
        ArrayList<MapKeyJoinColumn> joinColumns = new ArrayList<MapKeyJoinColumn>();
        if (subelements != null) {
            for (Element subelement : subelements) {
                AnnotationDescriptor column = new AnnotationDescriptor(MapKeyJoinColumn.class);
                JPAOverridenAnnotationReader.copyStringAttribute(column, subelement, "name", false);
                JPAOverridenAnnotationReader.copyStringAttribute(column, subelement, "referenced-column-name", false);
                JPAOverridenAnnotationReader.copyBooleanAttribute(column, subelement, "unique");
                JPAOverridenAnnotationReader.copyBooleanAttribute(column, subelement, "nullable");
                JPAOverridenAnnotationReader.copyBooleanAttribute(column, subelement, "insertable");
                JPAOverridenAnnotationReader.copyBooleanAttribute(column, subelement, "updatable");
                JPAOverridenAnnotationReader.copyStringAttribute(column, subelement, "column-definition", false);
                JPAOverridenAnnotationReader.copyStringAttribute(column, subelement, "table", false);
                joinColumns.add((MapKeyJoinColumn)AnnotationFactory.create((AnnotationDescriptor)column));
            }
        }
        return joinColumns.toArray(new MapKeyJoinColumn[joinColumns.size()]);
    }

    private AttributeOverrides getMapKeyAttributeOverrides(Element tree, XMLContext.Default defaults) {
        List<AttributeOverride> attributes = this.buildAttributeOverrides(tree, "map-key-attribute-override");
        return this.mergeAttributeOverrides(defaults, attributes, false);
    }

    private void getMapKeyEnumerated(List<Annotation> annotationList, Element element) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("map-key-enumerated") : null;
        if (subelement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKeyEnumerated.class);
            EnumType value = EnumType.valueOf((String)subelement.getTextTrim());
            ad.setValue("value", (Object)value);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getMapKeyTemporal(List<Annotation> annotationList, Element element) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("map-key-temporal") : null;
        if (subelement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKeyTemporal.class);
            TemporalType value = TemporalType.valueOf((String)subelement.getTextTrim());
            ad.setValue("value", (Object)value);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getOrderColumn(List<Annotation> annotationList, Element element) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("order-column") : null;
        if (subelement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(OrderColumn.class);
            JPAOverridenAnnotationReader.copyStringAttribute(ad, subelement, "name", false);
            JPAOverridenAnnotationReader.copyBooleanAttribute(ad, subelement, "nullable");
            JPAOverridenAnnotationReader.copyBooleanAttribute(ad, subelement, "insertable");
            JPAOverridenAnnotationReader.copyBooleanAttribute(ad, subelement, "updatable");
            JPAOverridenAnnotationReader.copyStringAttribute(ad, subelement, "column-definition", false);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getMapsId(List<Annotation> annotationList, Element element) {
        String attrVal = element.attributeValue("maps-id");
        if (attrVal != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapsId.class);
            ad.setValue("value", (Object)attrVal);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getAssociationId(List<Annotation> annotationList, Element element) {
        String attrVal = element.attributeValue("id");
        if ("true".equals(attrVal)) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Id.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void addTargetClass(Element element, AnnotationDescriptor ad, String nodeName, XMLContext.Default defaults) {
        String className = element.attributeValue(nodeName);
        if (className != null) {
            Class clazz;
            try {
                clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName(className, defaults), this.getClass());
            }
            catch (ClassNotFoundException e) {
                throw new AnnotationException("Unable to find " + element.getPath() + " " + nodeName + ": " + className, e);
            }
            ad.setValue(JPAOverridenAnnotationReader.getJavaAttributeNameFromXMLOne(nodeName), (Object)clazz);
        }
    }

    private void getElementCollection(List<Annotation> annotationList, XMLContext.Default defaults) {
        for (Element element : this.elementsForProperty) {
            if (!"element-collection".equals(element.getName())) continue;
            AnnotationDescriptor ad = new AnnotationDescriptor(ElementCollection.class);
            this.addTargetClass(element, ad, "target-class", defaults);
            this.getFetchType(ad, element);
            this.getOrderBy(annotationList, element);
            this.getOrderColumn(annotationList, element);
            this.getMapKey(annotationList, element);
            this.getMapKeyClass(annotationList, element, defaults);
            this.getMapKeyTemporal(annotationList, element);
            this.getMapKeyEnumerated(annotationList, element);
            this.getMapKeyColumn(annotationList, element);
            this.buildMapKeyJoinColumns(annotationList, element);
            Column annotation = this.getColumn(element.element("column"), false, element);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            this.getTemporal(annotationList, element);
            this.getEnumerated(annotationList, element);
            this.getLob(annotationList, element);
            ArrayList<AttributeOverride> attributes = new ArrayList<AttributeOverride>();
            attributes.addAll(this.buildAttributeOverrides(element, "map-key-attribute-override"));
            attributes.addAll(this.buildAttributeOverrides(element, "attribute-override"));
            annotation = this.mergeAttributeOverrides(defaults, attributes, false);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getAssociationOverrides(element, defaults, false);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            this.getCollectionTable(annotationList, element, defaults);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            this.getAccessType(annotationList, element);
        }
    }

    private void getOrderBy(List<Annotation> annotationList, Element element) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("order-by") : null;
        if (subelement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(OrderBy.class);
            JPAOverridenAnnotationReader.copyStringElement(subelement, ad, "value");
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getMapKey(List<Annotation> annotationList, Element element) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("map-key") : null;
        if (subelement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKey.class);
            JPAOverridenAnnotationReader.copyStringAttribute(ad, subelement, "name", false);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getMapKeyColumn(List<Annotation> annotationList, Element element) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("map-key-column") : null;
        if (subelement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKeyColumn.class);
            JPAOverridenAnnotationReader.copyStringAttribute(ad, subelement, "name", false);
            JPAOverridenAnnotationReader.copyBooleanAttribute(ad, subelement, "unique");
            JPAOverridenAnnotationReader.copyBooleanAttribute(ad, subelement, "nullable");
            JPAOverridenAnnotationReader.copyBooleanAttribute(ad, subelement, "insertable");
            JPAOverridenAnnotationReader.copyBooleanAttribute(ad, subelement, "updatable");
            JPAOverridenAnnotationReader.copyStringAttribute(ad, subelement, "column-definition", false);
            JPAOverridenAnnotationReader.copyStringAttribute(ad, subelement, "table", false);
            JPAOverridenAnnotationReader.copyIntegerAttribute(ad, subelement, "length");
            JPAOverridenAnnotationReader.copyIntegerAttribute(ad, subelement, "precision");
            JPAOverridenAnnotationReader.copyIntegerAttribute(ad, subelement, "scale");
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getMapKeyClass(List<Annotation> annotationList, Element element, XMLContext.Default defaults) {
        Element subelement;
        String nodeName = "map-key-class";
        Element element2 = subelement = element != null ? element.element(nodeName) : null;
        if (subelement != null) {
            String mapKeyClassName = subelement.attributeValue("class");
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKeyClass.class);
            if (StringHelper.isNotEmpty(mapKeyClassName)) {
                Class clazz;
                try {
                    clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName(mapKeyClassName, defaults), this.getClass());
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find " + element.getPath() + " " + nodeName + ": " + mapKeyClassName, e);
                }
                ad.setValue("value", (Object)clazz);
            }
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getCollectionTable(List<Annotation> annotationList, Element element, XMLContext.Default defaults) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("collection-table") : null;
        if (subelement != null) {
            JoinColumn[] joinColumns;
            AnnotationDescriptor annotation = new AnnotationDescriptor(CollectionTable.class);
            JPAOverridenAnnotationReader.copyStringAttribute(annotation, subelement, "name", false);
            JPAOverridenAnnotationReader.copyStringAttribute(annotation, subelement, "catalog", false);
            if (StringHelper.isNotEmpty(defaults.getCatalog()) && StringHelper.isEmpty((String)annotation.valueOf("catalog"))) {
                annotation.setValue("catalog", (Object)defaults.getCatalog());
            }
            JPAOverridenAnnotationReader.copyStringAttribute(annotation, subelement, "schema", false);
            if (StringHelper.isNotEmpty(defaults.getSchema()) && StringHelper.isEmpty((String)annotation.valueOf("schema"))) {
                annotation.setValue("schema", (Object)defaults.getSchema());
            }
            if ((joinColumns = this.getJoinColumns(subelement, false)).length > 0) {
                annotation.setValue("joinColumns", (Object)joinColumns);
            }
            JPAOverridenAnnotationReader.buildUniqueConstraints(annotation, subelement);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)annotation));
        }
    }

    private void buildJoinColumns(List<Annotation> annotationList, Element element) {
        JoinColumn[] joinColumns = this.getJoinColumns(element, false);
        if (joinColumns.length > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(JoinColumns.class);
            ad.setValue("value", (Object)joinColumns);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getCascades(AnnotationDescriptor ad, Element element, XMLContext.Default defaults) {
        List elements = element != null ? element.elements("cascade") : new ArrayList(0);
        ArrayList<CascadeType> cascades = new ArrayList<CascadeType>();
        for (Element subelement : elements) {
            if (subelement.element("cascade-all") != null) {
                cascades.add(CascadeType.ALL);
            }
            if (subelement.element("cascade-persist") != null) {
                cascades.add(CascadeType.PERSIST);
            }
            if (subelement.element("cascade-merge") != null) {
                cascades.add(CascadeType.MERGE);
            }
            if (subelement.element("cascade-remove") != null) {
                cascades.add(CascadeType.REMOVE);
            }
            if (subelement.element("cascade-refresh") != null) {
                cascades.add(CascadeType.REFRESH);
            }
            if (subelement.element("cascade-detach") == null) continue;
            cascades.add(CascadeType.DETACH);
        }
        if (Boolean.TRUE.equals(defaults.getCascadePersist()) && !cascades.contains(CascadeType.ALL) && !cascades.contains(CascadeType.PERSIST)) {
            cascades.add(CascadeType.PERSIST);
        }
        if (cascades.size() > 0) {
            ad.setValue("cascade", (Object)cascades.toArray(new CascadeType[cascades.size()]));
        }
    }

    private void getEmbedded(List<Annotation> annotationList, XMLContext.Default defaults) {
        Embedded annotation;
        for (Element element : this.elementsForProperty) {
            if (!"embedded".equals(element.getName())) continue;
            AnnotationDescriptor ad = new AnnotationDescriptor(Embedded.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            AttributeOverrides annotation2 = this.getAttributeOverrides(element, defaults, false);
            this.addIfNotNull(annotationList, (Annotation)annotation2);
            annotation2 = this.getAssociationOverrides(element, defaults, false);
            this.addIfNotNull(annotationList, (Annotation)annotation2);
            this.getAccessType(annotationList, element);
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations() && (annotation = this.getJavaAnnotation(Embedded.class)) != null) {
            annotationList.add((Annotation)annotation);
            annotation = this.getJavaAnnotation(AttributeOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(AttributeOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(AssociationOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(AssociationOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
        }
    }

    private Transient getTransient(XMLContext.Default defaults) {
        for (Element element : this.elementsForProperty) {
            if (!"transient".equals(element.getName())) continue;
            AnnotationDescriptor ad = new AnnotationDescriptor(Transient.class);
            return (Transient)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(Transient.class);
        }
        return null;
    }

    private void getVersion(List<Annotation> annotationList, XMLContext.Default defaults) {
        Object annotation;
        for (Element element : this.elementsForProperty) {
            if (!"version".equals(element.getName())) continue;
            Columns annotation2 = this.buildColumns(element);
            this.addIfNotNull(annotationList, annotation2);
            this.getTemporal(annotationList, element);
            AnnotationDescriptor basic = new AnnotationDescriptor(Version.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)basic));
            this.getAccessType(annotationList, element);
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations() && (annotation = this.getJavaAnnotation(Version.class)) != null) {
            annotationList.add((Annotation)annotation);
            annotation = this.getJavaAnnotation(Column.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(Columns.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(Temporal.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
        }
    }

    private void getBasic(List<Annotation> annotationList, XMLContext.Default defaults) {
        for (Element element : this.elementsForProperty) {
            if (!"basic".equals(element.getName())) continue;
            Columns annotation = this.buildColumns(element);
            this.addIfNotNull(annotationList, annotation);
            this.getAccessType(annotationList, element);
            this.getTemporal(annotationList, element);
            this.getLob(annotationList, element);
            this.getEnumerated(annotationList, element);
            AnnotationDescriptor basic = new AnnotationDescriptor(Basic.class);
            this.getFetchType(basic, element);
            JPAOverridenAnnotationReader.copyBooleanAttribute(basic, element, "optional");
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)basic));
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations()) {
            Object annotation = this.getJavaAnnotation(Basic.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(Lob.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(Enumerated.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(Temporal.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(Column.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(Columns.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(AttributeOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(AttributeOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(AssociationOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(AssociationOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
        }
    }

    private void getEnumerated(List<Annotation> annotationList, Element element) {
        Element subElement;
        Element element2 = subElement = element != null ? element.element("enumerated") : null;
        if (subElement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Enumerated.class);
            String enumerated = subElement.getTextTrim();
            if ("ORDINAL".equalsIgnoreCase(enumerated)) {
                ad.setValue("value", (Object)EnumType.ORDINAL);
            } else if ("STRING".equalsIgnoreCase(enumerated)) {
                ad.setValue("value", (Object)EnumType.STRING);
            } else if (StringHelper.isNotEmpty(enumerated)) {
                throw new AnnotationException("Unknown EnumType: " + enumerated + ". " + SCHEMA_VALIDATION);
            }
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getLob(List<Annotation> annotationList, Element element) {
        Element subElement;
        Element element2 = subElement = element != null ? element.element("lob") : null;
        if (subElement != null) {
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)new AnnotationDescriptor(Lob.class)));
        }
    }

    private void getFetchType(AnnotationDescriptor descriptor, Element element) {
        String fetchString;
        String string = fetchString = element != null ? element.attributeValue("fetch") : null;
        if (fetchString != null) {
            if ("eager".equalsIgnoreCase(fetchString)) {
                descriptor.setValue("fetch", (Object)FetchType.EAGER);
            } else if ("lazy".equalsIgnoreCase(fetchString)) {
                descriptor.setValue("fetch", (Object)FetchType.LAZY);
            }
        }
    }

    private void getEmbeddedId(List<Annotation> annotationList, XMLContext.Default defaults) {
        Object annotation;
        for (Element element : this.elementsForProperty) {
            if (!"embedded-id".equals(element.getName()) || !this.isProcessingId(defaults)) continue;
            AttributeOverrides annotation2 = this.getAttributeOverrides(element, defaults, false);
            this.addIfNotNull(annotationList, (Annotation)annotation2);
            annotation2 = this.getAssociationOverrides(element, defaults, false);
            this.addIfNotNull(annotationList, (Annotation)annotation2);
            AnnotationDescriptor ad = new AnnotationDescriptor(EmbeddedId.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            this.getAccessType(annotationList, element);
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations() && (annotation = this.getJavaAnnotation(EmbeddedId.class)) != null) {
            annotationList.add((Annotation)annotation);
            annotation = this.getJavaAnnotation(Column.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(Columns.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(GeneratedValue.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(Temporal.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(TableGenerator.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(SequenceGenerator.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(AttributeOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(AttributeOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(AssociationOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(AssociationOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
        }
    }

    private void preCalculateElementsForProperty(Element tree) {
        Element element;
        this.elementsForProperty = new ArrayList<Element>();
        Element element2 = element = tree != null ? tree.element("attributes") : null;
        if (element != null) {
            for (Element subelement : element.elements()) {
                if (!this.propertyName.equals(subelement.attributeValue("name"))) continue;
                this.elementsForProperty.add(subelement);
            }
        }
        if (tree != null) {
            for (Element subelement : tree.elements()) {
                if (!this.propertyName.equals(subelement.attributeValue("method-name"))) continue;
                this.elementsForProperty.add(subelement);
            }
        }
    }

    private void getId(List<Annotation> annotationList, XMLContext.Default defaults) {
        Object annotation;
        for (Element element : this.elementsForProperty) {
            boolean processId;
            if (!"id".equals(element.getName()) || !(processId = this.isProcessingId(defaults))) continue;
            Columns annotation2 = this.buildColumns(element);
            this.addIfNotNull(annotationList, annotation2);
            annotation2 = this.buildGeneratedValue(element);
            this.addIfNotNull(annotationList, annotation2);
            this.getTemporal(annotationList, element);
            annotation2 = this.getTableGenerator(element, defaults);
            this.addIfNotNull(annotationList, annotation2);
            annotation2 = this.getSequenceGenerator(element, defaults);
            this.addIfNotNull(annotationList, annotation2);
            AnnotationDescriptor id = new AnnotationDescriptor(Id.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)id));
            this.getAccessType(annotationList, element);
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations() && (annotation = this.getJavaAnnotation(Id.class)) != null) {
            annotationList.add((Annotation)annotation);
            annotation = this.getJavaAnnotation(Column.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(Columns.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(GeneratedValue.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(Temporal.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(TableGenerator.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(SequenceGenerator.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(AttributeOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(AttributeOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(AssociationOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getJavaAnnotation(AssociationOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
        }
    }

    private boolean isProcessingId(XMLContext.Default defaults) {
        boolean isExplicit = defaults.getAccess() != null;
        boolean correctAccess = PropertyType.PROPERTY.equals((Object)this.propertyType) && AccessType.PROPERTY.equals((Object)defaults.getAccess()) || PropertyType.FIELD.equals((Object)this.propertyType) && AccessType.FIELD.equals((Object)defaults.getAccess());
        boolean hasId = defaults.canUseJavaAnnotations() && (this.isJavaAnnotationPresent(Id.class) || this.isJavaAnnotationPresent(EmbeddedId.class));
        boolean mirrorAttributeIsId = defaults.canUseJavaAnnotations() && this.mirroredAttribute != null && (this.mirroredAttribute.isAnnotationPresent(Id.class) || this.mirroredAttribute.isAnnotationPresent(EmbeddedId.class));
        boolean propertyIsDefault = PropertyType.PROPERTY.equals((Object)this.propertyType) && !mirrorAttributeIsId;
        return correctAccess || !isExplicit && hasId || !isExplicit && propertyIsDefault;
    }

    private Columns buildColumns(Element element) {
        List subelements = element.elements("column");
        ArrayList<Column> columns = new ArrayList<Column>(subelements.size());
        for (Element subelement : subelements) {
            columns.add(this.getColumn(subelement, false, element));
        }
        if (columns.size() > 0) {
            AnnotationDescriptor columnsDescr = new AnnotationDescriptor(Columns.class);
            columnsDescr.setValue("columns", (Object)columns.toArray(new Column[columns.size()]));
            return (Columns)AnnotationFactory.create((AnnotationDescriptor)columnsDescr);
        }
        return null;
    }

    private GeneratedValue buildGeneratedValue(Element element) {
        Element subElement;
        Element element2 = subElement = element != null ? element.element("generated-value") : null;
        if (subElement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(GeneratedValue.class);
            String strategy = subElement.attributeValue("strategy");
            if ("TABLE".equalsIgnoreCase(strategy)) {
                ad.setValue("strategy", (Object)GenerationType.TABLE);
            } else if ("SEQUENCE".equalsIgnoreCase(strategy)) {
                ad.setValue("strategy", (Object)GenerationType.SEQUENCE);
            } else if ("IDENTITY".equalsIgnoreCase(strategy)) {
                ad.setValue("strategy", (Object)GenerationType.IDENTITY);
            } else if ("AUTO".equalsIgnoreCase(strategy)) {
                ad.setValue("strategy", (Object)GenerationType.AUTO);
            } else if (StringHelper.isNotEmpty(strategy)) {
                throw new AnnotationException("Unknown GenerationType: " + strategy + ". " + SCHEMA_VALIDATION);
            }
            JPAOverridenAnnotationReader.copyStringAttribute(ad, subElement, "generator", false);
            return (GeneratedValue)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private void getTemporal(List<Annotation> annotationList, Element element) {
        Element subElement;
        Element element2 = subElement = element != null ? element.element("temporal") : null;
        if (subElement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Temporal.class);
            String temporal = subElement.getTextTrim();
            if ("DATE".equalsIgnoreCase(temporal)) {
                ad.setValue("value", (Object)TemporalType.DATE);
            } else if ("TIME".equalsIgnoreCase(temporal)) {
                ad.setValue("value", (Object)TemporalType.TIME);
            } else if ("TIMESTAMP".equalsIgnoreCase(temporal)) {
                ad.setValue("value", (Object)TemporalType.TIMESTAMP);
            } else if (StringHelper.isNotEmpty(temporal)) {
                throw new AnnotationException("Unknown TemporalType: " + temporal + ". " + SCHEMA_VALIDATION);
            }
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getAccessType(List<Annotation> annotationList, Element element) {
        if (element == null) {
            return;
        }
        String access = element.attributeValue("access");
        if (access != null) {
            AccessType type;
            AnnotationDescriptor ad = new AnnotationDescriptor(Access.class);
            try {
                type = AccessType.valueOf((String)access);
            }
            catch (IllegalArgumentException e) {
                throw new AnnotationException(access + " is not a valid access type. Check you xml confguration.");
            }
            if (AccessType.PROPERTY.equals((Object)type) && this.element instanceof Method || AccessType.FIELD.equals((Object)type) && this.element instanceof Field) {
                return;
            }
            ad.setValue("value", (Object)type);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private AssociationOverrides getAssociationOverrides(Element tree, XMLContext.Default defaults, boolean mergeWithAnnotations) {
        List<AssociationOverride> attributes = this.buildAssociationOverrides(tree, defaults);
        if (mergeWithAnnotations && defaults.canUseJavaAnnotations()) {
            AssociationOverride annotation = this.getJavaAnnotation(AssociationOverride.class);
            this.addAssociationOverrideIfNeeded(annotation, attributes);
            AssociationOverrides annotations = this.getJavaAnnotation(AssociationOverrides.class);
            if (annotations != null) {
                for (AssociationOverride current : annotations.value()) {
                    this.addAssociationOverrideIfNeeded(current, attributes);
                }
            }
        }
        if (attributes.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(AssociationOverrides.class);
            ad.setValue("value", (Object)attributes.toArray(new AssociationOverride[attributes.size()]));
            return (AssociationOverrides)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private List<AssociationOverride> buildAssociationOverrides(Element element, XMLContext.Default defaults) {
        List subelements = element == null ? null : element.elements("association-override");
        ArrayList<AssociationOverride> overrides = new ArrayList<AssociationOverride>();
        if (subelements != null && subelements.size() > 0) {
            for (Element current : subelements) {
                AnnotationDescriptor override = new AnnotationDescriptor(AssociationOverride.class);
                JPAOverridenAnnotationReader.copyStringAttribute(override, current, "name", true);
                override.setValue("joinColumns", (Object)this.getJoinColumns(current, false));
                JoinTable joinTable = this.buildJoinTable(current, defaults);
                if (joinTable != null) {
                    override.setValue("joinTable", (Object)joinTable);
                }
                overrides.add((AssociationOverride)AnnotationFactory.create((AnnotationDescriptor)override));
            }
        }
        return overrides;
    }

    private JoinColumn[] getJoinColumns(Element element, boolean isInverse) {
        List subelements = element != null ? element.elements(isInverse ? "inverse-join-column" : "join-column") : null;
        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>();
        if (subelements != null) {
            for (Element subelement : subelements) {
                AnnotationDescriptor column = new AnnotationDescriptor(JoinColumn.class);
                JPAOverridenAnnotationReader.copyStringAttribute(column, subelement, "name", false);
                JPAOverridenAnnotationReader.copyStringAttribute(column, subelement, "referenced-column-name", false);
                JPAOverridenAnnotationReader.copyBooleanAttribute(column, subelement, "unique");
                JPAOverridenAnnotationReader.copyBooleanAttribute(column, subelement, "nullable");
                JPAOverridenAnnotationReader.copyBooleanAttribute(column, subelement, "insertable");
                JPAOverridenAnnotationReader.copyBooleanAttribute(column, subelement, "updatable");
                JPAOverridenAnnotationReader.copyStringAttribute(column, subelement, "column-definition", false);
                JPAOverridenAnnotationReader.copyStringAttribute(column, subelement, "table", false);
                joinColumns.add((JoinColumn)AnnotationFactory.create((AnnotationDescriptor)column));
            }
        }
        return joinColumns.toArray(new JoinColumn[joinColumns.size()]);
    }

    private void addAssociationOverrideIfNeeded(AssociationOverride annotation, List<AssociationOverride> overrides) {
        if (annotation != null) {
            String overrideName = annotation.name();
            boolean present = false;
            for (AssociationOverride current : overrides) {
                if (!current.name().equals(overrideName)) continue;
                present = true;
                break;
            }
            if (!present) {
                overrides.add(annotation);
            }
        }
    }

    private AttributeOverrides getAttributeOverrides(Element tree, XMLContext.Default defaults, boolean mergeWithAnnotations) {
        List<AttributeOverride> attributes = this.buildAttributeOverrides(tree, "attribute-override");
        return this.mergeAttributeOverrides(defaults, attributes, mergeWithAnnotations);
    }

    private AttributeOverrides mergeAttributeOverrides(XMLContext.Default defaults, List<AttributeOverride> attributes, boolean mergeWithAnnotations) {
        if (mergeWithAnnotations && defaults.canUseJavaAnnotations()) {
            AttributeOverride annotation = this.getJavaAnnotation(AttributeOverride.class);
            this.addAttributeOverrideIfNeeded(annotation, attributes);
            AttributeOverrides annotations = this.getJavaAnnotation(AttributeOverrides.class);
            if (annotations != null) {
                for (AttributeOverride current : annotations.value()) {
                    this.addAttributeOverrideIfNeeded(current, attributes);
                }
            }
        }
        if (attributes.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(AttributeOverrides.class);
            ad.setValue("value", (Object)attributes.toArray(new AttributeOverride[attributes.size()]));
            return (AttributeOverrides)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private List<AttributeOverride> buildAttributeOverrides(Element element, String nodeName) {
        List subelements = element == null ? null : element.elements(nodeName);
        return this.buildAttributeOverrides(subelements, nodeName);
    }

    private List<AttributeOverride> buildAttributeOverrides(List<Element> subelements, String nodeName) {
        ArrayList<AttributeOverride> overrides = new ArrayList<AttributeOverride>();
        if (subelements != null && subelements.size() > 0) {
            for (Element current : subelements) {
                if (!current.getName().equals(nodeName)) continue;
                AnnotationDescriptor override = new AnnotationDescriptor(AttributeOverride.class);
                JPAOverridenAnnotationReader.copyStringAttribute(override, current, "name", true);
                Element column = current.element("column");
                override.setValue("column", (Object)this.getColumn(column, true, current));
                overrides.add((AttributeOverride)AnnotationFactory.create((AnnotationDescriptor)override));
            }
        }
        return overrides;
    }

    private Column getColumn(Element element, boolean isMandatory, Element current) {
        if (element != null) {
            AnnotationDescriptor column = new AnnotationDescriptor(Column.class);
            JPAOverridenAnnotationReader.copyStringAttribute(column, element, "name", false);
            JPAOverridenAnnotationReader.copyBooleanAttribute(column, element, "unique");
            JPAOverridenAnnotationReader.copyBooleanAttribute(column, element, "nullable");
            JPAOverridenAnnotationReader.copyBooleanAttribute(column, element, "insertable");
            JPAOverridenAnnotationReader.copyBooleanAttribute(column, element, "updatable");
            JPAOverridenAnnotationReader.copyStringAttribute(column, element, "column-definition", false);
            JPAOverridenAnnotationReader.copyStringAttribute(column, element, "table", false);
            JPAOverridenAnnotationReader.copyIntegerAttribute(column, element, "length");
            JPAOverridenAnnotationReader.copyIntegerAttribute(column, element, "precision");
            JPAOverridenAnnotationReader.copyIntegerAttribute(column, element, "scale");
            return (Column)AnnotationFactory.create((AnnotationDescriptor)column);
        }
        if (isMandatory) {
            throw new AnnotationException(current.getPath() + ".column is mandatory. " + SCHEMA_VALIDATION);
        }
        return null;
    }

    private void addAttributeOverrideIfNeeded(AttributeOverride annotation, List<AttributeOverride> overrides) {
        if (annotation != null) {
            String overrideName = annotation.name();
            boolean present = false;
            for (AttributeOverride current : overrides) {
                if (!current.name().equals(overrideName)) continue;
                present = true;
                break;
            }
            if (!present) {
                overrides.add(annotation);
            }
        }
    }

    private Access getAccessType(Element tree, XMLContext.Default defaults) {
        String access;
        String string = access = tree == null ? null : tree.attributeValue("access");
        if (access != null) {
            AccessType type;
            AnnotationDescriptor ad = new AnnotationDescriptor(Access.class);
            try {
                type = AccessType.valueOf((String)access);
            }
            catch (IllegalArgumentException e) {
                throw new AnnotationException(access + " is not a valid access type. Check you xml confguration.");
            }
            ad.setValue("value", (Object)type);
            return (Access)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations() && this.isJavaAnnotationPresent(Access.class)) {
            return this.getJavaAnnotation(Access.class);
        }
        if (defaults.getAccess() != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Access.class);
            ad.setValue("value", (Object)defaults.getAccess());
            return (Access)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private ExcludeSuperclassListeners getExcludeSuperclassListeners(Element tree, XMLContext.Default defaults) {
        return (ExcludeSuperclassListeners)this.getMarkerAnnotation(ExcludeSuperclassListeners.class, tree, defaults);
    }

    private ExcludeDefaultListeners getExcludeDefaultListeners(Element tree, XMLContext.Default defaults) {
        return (ExcludeDefaultListeners)this.getMarkerAnnotation(ExcludeDefaultListeners.class, tree, defaults);
    }

    private Annotation getMarkerAnnotation(Class<? extends Annotation> clazz, Element element, XMLContext.Default defaults) {
        Element subelement;
        Element element2 = subelement = element == null ? null : element.element(annotationToXml.get(clazz));
        if (subelement != null) {
            return AnnotationFactory.create((AnnotationDescriptor)new AnnotationDescriptor(clazz));
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(clazz);
        }
        return null;
    }

    private SqlResultSetMappings getSqlResultSetMappings(Element tree, XMLContext.Default defaults) {
        List<SqlResultSetMapping> results = JPAOverridenAnnotationReader.buildSqlResultsetMappings(tree, defaults);
        if (defaults.canUseJavaAnnotations()) {
            SqlResultSetMapping annotation = this.getJavaAnnotation(SqlResultSetMapping.class);
            this.addSqlResultsetMappingIfNeeded(annotation, results);
            SqlResultSetMappings annotations = this.getJavaAnnotation(SqlResultSetMappings.class);
            if (annotations != null) {
                for (SqlResultSetMapping current : annotations.value()) {
                    this.addSqlResultsetMappingIfNeeded(current, results);
                }
            }
        }
        if (results.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(SqlResultSetMappings.class);
            ad.setValue("value", (Object)results.toArray(new SqlResultSetMapping[results.size()]));
            return (SqlResultSetMappings)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    public static List<SqlResultSetMapping> buildSqlResultsetMappings(Element element, XMLContext.Default defaults) {
        if (element == null) {
            return new ArrayList<SqlResultSetMapping>();
        }
        List resultsetElementList = element.elements("sql-result-set-mapping");
        ArrayList<SqlResultSetMapping> resultsets = new ArrayList<SqlResultSetMapping>();
        ListIterator it = resultsetElementList.listIterator();
        while (it.hasNext()) {
            Element subelement = (Element)it.next();
            AnnotationDescriptor ann = new AnnotationDescriptor(SqlResultSetMapping.class);
            JPAOverridenAnnotationReader.copyStringAttribute(ann, subelement, "name", true);
            List elements = subelement.elements("entity-result");
            ArrayList<EntityResult> entityResults = new ArrayList<EntityResult>(elements.size());
            for (Element entityResult : elements) {
                Class clazz;
                AnnotationDescriptor entityResultDescriptor = new AnnotationDescriptor(EntityResult.class);
                String clazzName = entityResult.attributeValue("entity-class");
                if (clazzName == null) {
                    throw new AnnotationException("<entity-result> without entity-class. Activate schema validation for more information");
                }
                try {
                    clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName(clazzName, defaults), JPAOverridenAnnotationReader.class);
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find entity-class: " + clazzName, e);
                }
                entityResultDescriptor.setValue("entityClass", (Object)clazz);
                JPAOverridenAnnotationReader.copyStringAttribute(entityResultDescriptor, entityResult, "discriminator-column", false);
                ArrayList<FieldResult> fieldResults = new ArrayList<FieldResult>();
                for (Element fieldResult : entityResult.elements("field-result")) {
                    AnnotationDescriptor fieldResultDescriptor = new AnnotationDescriptor(FieldResult.class);
                    JPAOverridenAnnotationReader.copyStringAttribute(fieldResultDescriptor, fieldResult, "name", true);
                    JPAOverridenAnnotationReader.copyStringAttribute(fieldResultDescriptor, fieldResult, "column", true);
                    fieldResults.add((FieldResult)AnnotationFactory.create((AnnotationDescriptor)fieldResultDescriptor));
                }
                entityResultDescriptor.setValue("fields", (Object)fieldResults.toArray(new FieldResult[fieldResults.size()]));
                entityResults.add((EntityResult)AnnotationFactory.create((AnnotationDescriptor)entityResultDescriptor));
            }
            ann.setValue("entities", (Object)entityResults.toArray(new EntityResult[entityResults.size()]));
            elements = subelement.elements("column-result");
            ArrayList<ColumnResult> columnResults = new ArrayList<ColumnResult>(elements.size());
            for (Element columnResult : elements) {
                AnnotationDescriptor columnResultDescriptor = new AnnotationDescriptor(ColumnResult.class);
                JPAOverridenAnnotationReader.copyStringAttribute(columnResultDescriptor, columnResult, "name", true);
                columnResults.add((ColumnResult)AnnotationFactory.create((AnnotationDescriptor)columnResultDescriptor));
            }
            ann.setValue("columns", (Object)columnResults.toArray(new ColumnResult[columnResults.size()]));
            String clazzName = subelement.attributeValue("result-class");
            if (StringHelper.isNotEmpty(clazzName)) {
                Class clazz;
                try {
                    clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName(clazzName, defaults), JPAOverridenAnnotationReader.class);
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find entity-class: " + clazzName, e);
                }
                ann.setValue("resultClass", (Object)clazz);
            }
            JPAOverridenAnnotationReader.copyStringAttribute(ann, subelement, "result-set-mapping", false);
            resultsets.add((SqlResultSetMapping)AnnotationFactory.create((AnnotationDescriptor)ann));
        }
        return resultsets;
    }

    private void addSqlResultsetMappingIfNeeded(SqlResultSetMapping annotation, List<SqlResultSetMapping> resultsets) {
        if (annotation != null) {
            String resultsetName = annotation.name();
            boolean present = false;
            for (SqlResultSetMapping current : resultsets) {
                if (!current.name().equals(resultsetName)) continue;
                present = true;
                break;
            }
            if (!present) {
                resultsets.add(annotation);
            }
        }
    }

    private NamedQueries getNamedQueries(Element tree, XMLContext.Default defaults) {
        List queries = JPAOverridenAnnotationReader.buildNamedQueries(tree, false, defaults);
        if (defaults.canUseJavaAnnotations()) {
            NamedQuery annotation = this.getJavaAnnotation(NamedQuery.class);
            this.addNamedQueryIfNeeded(annotation, queries);
            NamedQueries annotations = this.getJavaAnnotation(NamedQueries.class);
            if (annotations != null) {
                for (NamedQuery current : annotations.value()) {
                    this.addNamedQueryIfNeeded(current, queries);
                }
            }
        }
        if (queries.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(NamedQueries.class);
            ad.setValue("value", (Object)queries.toArray(new NamedQuery[queries.size()]));
            return (NamedQueries)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private void addNamedQueryIfNeeded(NamedQuery annotation, List<NamedQuery> queries) {
        if (annotation != null) {
            String queryName = annotation.name();
            boolean present = false;
            for (NamedQuery current : queries) {
                if (!current.name().equals(queryName)) continue;
                present = true;
                break;
            }
            if (!present) {
                queries.add(annotation);
            }
        }
    }

    private NamedNativeQueries getNamedNativeQueries(Element tree, XMLContext.Default defaults) {
        List queries = JPAOverridenAnnotationReader.buildNamedQueries(tree, true, defaults);
        if (defaults.canUseJavaAnnotations()) {
            NamedNativeQuery annotation = this.getJavaAnnotation(NamedNativeQuery.class);
            this.addNamedNativeQueryIfNeeded(annotation, queries);
            NamedNativeQueries annotations = this.getJavaAnnotation(NamedNativeQueries.class);
            if (annotations != null) {
                for (NamedNativeQuery current : annotations.value()) {
                    this.addNamedNativeQueryIfNeeded(current, queries);
                }
            }
        }
        if (queries.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(NamedNativeQueries.class);
            ad.setValue("value", (Object)queries.toArray(new NamedNativeQuery[queries.size()]));
            return (NamedNativeQueries)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private void addNamedNativeQueryIfNeeded(NamedNativeQuery annotation, List<NamedNativeQuery> queries) {
        if (annotation != null) {
            String queryName = annotation.name();
            boolean present = false;
            for (NamedNativeQuery current : queries) {
                if (!current.name().equals(queryName)) continue;
                present = true;
                break;
            }
            if (!present) {
                queries.add(annotation);
            }
        }
    }

    public static List buildNamedQueries(Element element, boolean isNative, XMLContext.Default defaults) {
        if (element == null) {
            return new ArrayList();
        }
        List namedQueryElementList = isNative ? element.elements("named-native-query") : element.elements("named-query");
        ArrayList<Annotation> namedQueries = new ArrayList<Annotation>();
        ListIterator it = namedQueryElementList.listIterator();
        while (it.hasNext()) {
            Element subelement = (Element)it.next();
            AnnotationDescriptor ann = new AnnotationDescriptor(isNative ? NamedNativeQuery.class : NamedQuery.class);
            JPAOverridenAnnotationReader.copyStringAttribute(ann, subelement, "name", false);
            Element queryElt = subelement.element("query");
            if (queryElt == null) {
                throw new AnnotationException("No <query> element found.Activate schema validation for more information");
            }
            JPAOverridenAnnotationReader.copyStringElement(queryElt, ann, "query");
            List elements = subelement.elements("hint");
            ArrayList<QueryHint> queryHints = new ArrayList<QueryHint>(elements.size());
            for (Element hint : elements) {
                AnnotationDescriptor hintDescriptor = new AnnotationDescriptor(QueryHint.class);
                String value = hint.attributeValue("name");
                if (value == null) {
                    throw new AnnotationException("<hint> without name. Activate schema validation for more information");
                }
                hintDescriptor.setValue("name", (Object)value);
                value = hint.attributeValue("value");
                if (value == null) {
                    throw new AnnotationException("<hint> without value. Activate schema validation for more information");
                }
                hintDescriptor.setValue("value", (Object)value);
                queryHints.add((QueryHint)AnnotationFactory.create((AnnotationDescriptor)hintDescriptor));
            }
            ann.setValue("hints", (Object)queryHints.toArray(new QueryHint[queryHints.size()]));
            String clazzName = subelement.attributeValue("result-class");
            if (StringHelper.isNotEmpty(clazzName)) {
                Class clazz;
                try {
                    clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName(clazzName, defaults), JPAOverridenAnnotationReader.class);
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find entity-class: " + clazzName, e);
                }
                ann.setValue("resultClass", (Object)clazz);
            }
            JPAOverridenAnnotationReader.copyStringAttribute(ann, subelement, "result-set-mapping", false);
            namedQueries.add(AnnotationFactory.create((AnnotationDescriptor)ann));
        }
        return namedQueries;
    }

    private TableGenerator getTableGenerator(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element(annotationToXml.get(TableGenerator.class)) : null;
        if (element != null) {
            return JPAOverridenAnnotationReader.buildTableGeneratorAnnotation(element, defaults);
        }
        if (defaults.canUseJavaAnnotations() && this.isJavaAnnotationPresent(TableGenerator.class)) {
            TableGenerator tableAnn = this.getJavaAnnotation(TableGenerator.class);
            if (StringHelper.isNotEmpty(defaults.getSchema()) || StringHelper.isNotEmpty(defaults.getCatalog())) {
                AnnotationDescriptor annotation = new AnnotationDescriptor(TableGenerator.class);
                annotation.setValue("name", (Object)tableAnn.name());
                annotation.setValue("table", (Object)tableAnn.table());
                annotation.setValue("catalog", (Object)tableAnn.table());
                if (StringHelper.isEmpty((String)annotation.valueOf("catalog")) && StringHelper.isNotEmpty(defaults.getCatalog())) {
                    annotation.setValue("catalog", (Object)defaults.getCatalog());
                }
                annotation.setValue("schema", (Object)tableAnn.table());
                if (StringHelper.isEmpty((String)annotation.valueOf("schema")) && StringHelper.isNotEmpty(defaults.getSchema())) {
                    annotation.setValue("catalog", (Object)defaults.getSchema());
                }
                annotation.setValue("pkColumnName", (Object)tableAnn.pkColumnName());
                annotation.setValue("valueColumnName", (Object)tableAnn.valueColumnName());
                annotation.setValue("pkColumnValue", (Object)tableAnn.pkColumnValue());
                annotation.setValue("initialValue", (Object)tableAnn.initialValue());
                annotation.setValue("allocationSize", (Object)tableAnn.allocationSize());
                annotation.setValue("uniqueConstraints", (Object)tableAnn.uniqueConstraints());
                return (TableGenerator)AnnotationFactory.create((AnnotationDescriptor)annotation);
            }
            return tableAnn;
        }
        return null;
    }

    public static TableGenerator buildTableGeneratorAnnotation(Element element, XMLContext.Default defaults) {
        AnnotationDescriptor ad = new AnnotationDescriptor(TableGenerator.class);
        JPAOverridenAnnotationReader.copyStringAttribute(ad, element, "name", false);
        JPAOverridenAnnotationReader.copyStringAttribute(ad, element, "table", false);
        JPAOverridenAnnotationReader.copyStringAttribute(ad, element, "catalog", false);
        JPAOverridenAnnotationReader.copyStringAttribute(ad, element, "schema", false);
        JPAOverridenAnnotationReader.copyStringAttribute(ad, element, "pk-column-name", false);
        JPAOverridenAnnotationReader.copyStringAttribute(ad, element, "value-column-name", false);
        JPAOverridenAnnotationReader.copyStringAttribute(ad, element, "pk-column-value", false);
        JPAOverridenAnnotationReader.copyIntegerAttribute(ad, element, "initial-value");
        JPAOverridenAnnotationReader.copyIntegerAttribute(ad, element, "allocation-size");
        JPAOverridenAnnotationReader.buildUniqueConstraints(ad, element);
        if (StringHelper.isEmpty((String)ad.valueOf("schema")) && StringHelper.isNotEmpty(defaults.getSchema())) {
            ad.setValue("schema", (Object)defaults.getSchema());
        }
        if (StringHelper.isEmpty((String)ad.valueOf("catalog")) && StringHelper.isNotEmpty(defaults.getCatalog())) {
            ad.setValue("catalog", (Object)defaults.getCatalog());
        }
        return (TableGenerator)AnnotationFactory.create((AnnotationDescriptor)ad);
    }

    private SequenceGenerator getSequenceGenerator(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element(annotationToXml.get(SequenceGenerator.class)) : null;
        if (element != null) {
            return JPAOverridenAnnotationReader.buildSequenceGeneratorAnnotation(element);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(SequenceGenerator.class);
        }
        return null;
    }

    public static SequenceGenerator buildSequenceGeneratorAnnotation(Element element) {
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(SequenceGenerator.class);
            JPAOverridenAnnotationReader.copyStringAttribute(ad, element, "name", false);
            JPAOverridenAnnotationReader.copyStringAttribute(ad, element, "sequence-name", false);
            JPAOverridenAnnotationReader.copyIntegerAttribute(ad, element, "initial-value");
            JPAOverridenAnnotationReader.copyIntegerAttribute(ad, element, "allocation-size");
            return (SequenceGenerator)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private DiscriminatorColumn getDiscriminatorColumn(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element("discriminator-column") : null;
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(DiscriminatorColumn.class);
            JPAOverridenAnnotationReader.copyStringAttribute(ad, element, "name", false);
            JPAOverridenAnnotationReader.copyStringAttribute(ad, element, "column-definition", false);
            String value = element.attributeValue("discriminator-type");
            DiscriminatorType type = DiscriminatorType.STRING;
            if (value != null) {
                if ("STRING".equals(value)) {
                    type = DiscriminatorType.STRING;
                } else if ("CHAR".equals(value)) {
                    type = DiscriminatorType.CHAR;
                } else if ("INTEGER".equals(value)) {
                    type = DiscriminatorType.INTEGER;
                } else {
                    throw new AnnotationException("Unknown DiscrimiatorType in XML: " + value + " (" + SCHEMA_VALIDATION + ")");
                }
            }
            ad.setValue("discriminatorType", (Object)type);
            JPAOverridenAnnotationReader.copyIntegerAttribute(ad, element, "length");
            return (DiscriminatorColumn)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(DiscriminatorColumn.class);
        }
        return null;
    }

    private DiscriminatorValue getDiscriminatorValue(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element("discriminator-value") : null;
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(DiscriminatorValue.class);
            JPAOverridenAnnotationReader.copyStringElement(element, ad, "value");
            return (DiscriminatorValue)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(DiscriminatorValue.class);
        }
        return null;
    }

    private Inheritance getInheritance(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element("inheritance") : null;
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Inheritance.class);
            Attribute attr = element.attribute("strategy");
            InheritanceType strategy = InheritanceType.SINGLE_TABLE;
            if (attr != null) {
                String value = attr.getValue();
                if ("SINGLE_TABLE".equals(value)) {
                    strategy = InheritanceType.SINGLE_TABLE;
                } else if ("JOINED".equals(value)) {
                    strategy = InheritanceType.JOINED;
                } else if ("TABLE_PER_CLASS".equals(value)) {
                    strategy = InheritanceType.TABLE_PER_CLASS;
                } else {
                    throw new AnnotationException("Unknown InheritanceType in XML: " + value + " (" + SCHEMA_VALIDATION + ")");
                }
            }
            ad.setValue("strategy", (Object)strategy);
            return (Inheritance)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(Inheritance.class);
        }
        return null;
    }

    private IdClass getIdClass(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree == null ? null : tree.element("id-class");
        if (element != null) {
            Attribute attr = element.attribute("class");
            if (attr != null) {
                Class clazz;
                AnnotationDescriptor ad = new AnnotationDescriptor(IdClass.class);
                try {
                    clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName(attr.getValue(), defaults), this.getClass());
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find id-class: " + attr.getValue(), e);
                }
                ad.setValue("value", (Object)clazz);
                return (IdClass)AnnotationFactory.create((AnnotationDescriptor)ad);
            }
            throw new AnnotationException("id-class without class. Activate schema validation for more information");
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(IdClass.class);
        }
        return null;
    }

    private PrimaryKeyJoinColumns getPrimaryKeyJoinColumns(Element element, XMLContext.Default defaults, boolean mergeWithAnnotations) {
        PrimaryKeyJoinColumn[] columns = this.buildPrimaryKeyJoinColumns(element);
        if (mergeWithAnnotations && columns.length == 0 && defaults.canUseJavaAnnotations()) {
            PrimaryKeyJoinColumn annotation = this.getJavaAnnotation(PrimaryKeyJoinColumn.class);
            if (annotation != null) {
                columns = new PrimaryKeyJoinColumn[]{annotation};
            } else {
                PrimaryKeyJoinColumns annotations = this.getJavaAnnotation(PrimaryKeyJoinColumns.class);
                PrimaryKeyJoinColumn[] primaryKeyJoinColumnArray = columns = annotations != null ? annotations.value() : columns;
            }
        }
        if (columns.length > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(PrimaryKeyJoinColumns.class);
            ad.setValue("value", (Object)columns);
            return (PrimaryKeyJoinColumns)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private Entity getEntity(Element tree, XMLContext.Default defaults) {
        if (tree == null) {
            return defaults.canUseJavaAnnotations() ? this.getJavaAnnotation(Entity.class) : null;
        }
        if ("entity".equals(tree.getName())) {
            Entity javaAnn;
            AnnotationDescriptor entity = new AnnotationDescriptor(Entity.class);
            JPAOverridenAnnotationReader.copyStringAttribute(entity, tree, "name", false);
            if (defaults.canUseJavaAnnotations() && StringHelper.isEmpty((String)entity.valueOf("name")) && (javaAnn = this.getJavaAnnotation(Entity.class)) != null) {
                entity.setValue("name", (Object)javaAnn.name());
            }
            return (Entity)AnnotationFactory.create((AnnotationDescriptor)entity);
        }
        return null;
    }

    private MappedSuperclass getMappedSuperclass(Element tree, XMLContext.Default defaults) {
        if (tree == null) {
            return defaults.canUseJavaAnnotations() ? this.getJavaAnnotation(MappedSuperclass.class) : null;
        }
        if ("mapped-superclass".equals(tree.getName())) {
            AnnotationDescriptor entity = new AnnotationDescriptor(MappedSuperclass.class);
            return (MappedSuperclass)AnnotationFactory.create((AnnotationDescriptor)entity);
        }
        return null;
    }

    private Embeddable getEmbeddable(Element tree, XMLContext.Default defaults) {
        if (tree == null) {
            return defaults.canUseJavaAnnotations() ? this.getJavaAnnotation(Embeddable.class) : null;
        }
        if ("embeddable".equals(tree.getName())) {
            AnnotationDescriptor entity = new AnnotationDescriptor(Embeddable.class);
            return (Embeddable)AnnotationFactory.create((AnnotationDescriptor)entity);
        }
        return null;
    }

    private Table getTable(Element tree, XMLContext.Default defaults) {
        Element subelement;
        Element element = subelement = tree == null ? null : tree.element("table");
        if (subelement == null) {
            if (StringHelper.isNotEmpty(defaults.getCatalog()) || StringHelper.isNotEmpty(defaults.getSchema())) {
                Table table;
                AnnotationDescriptor annotation = new AnnotationDescriptor(Table.class);
                if (defaults.canUseJavaAnnotations() && (table = this.getJavaAnnotation(Table.class)) != null) {
                    annotation.setValue("name", (Object)table.name());
                    annotation.setValue("schema", (Object)table.schema());
                    annotation.setValue("catalog", (Object)table.catalog());
                    annotation.setValue("uniqueConstraints", (Object)table.uniqueConstraints());
                }
                if (StringHelper.isEmpty((String)annotation.valueOf("schema")) && StringHelper.isNotEmpty(defaults.getSchema())) {
                    annotation.setValue("schema", (Object)defaults.getSchema());
                }
                if (StringHelper.isEmpty((String)annotation.valueOf("catalog")) && StringHelper.isNotEmpty(defaults.getCatalog())) {
                    annotation.setValue("catalog", (Object)defaults.getCatalog());
                }
                return (Table)AnnotationFactory.create((AnnotationDescriptor)annotation);
            }
            if (defaults.canUseJavaAnnotations()) {
                return this.getJavaAnnotation(Table.class);
            }
            return null;
        }
        AnnotationDescriptor annotation = new AnnotationDescriptor(Table.class);
        JPAOverridenAnnotationReader.copyStringAttribute(annotation, subelement, "name", false);
        JPAOverridenAnnotationReader.copyStringAttribute(annotation, subelement, "catalog", false);
        if (StringHelper.isNotEmpty(defaults.getCatalog()) && StringHelper.isEmpty((String)annotation.valueOf("catalog"))) {
            annotation.setValue("catalog", (Object)defaults.getCatalog());
        }
        JPAOverridenAnnotationReader.copyStringAttribute(annotation, subelement, "schema", false);
        if (StringHelper.isNotEmpty(defaults.getSchema()) && StringHelper.isEmpty((String)annotation.valueOf("schema"))) {
            annotation.setValue("schema", (Object)defaults.getSchema());
        }
        JPAOverridenAnnotationReader.buildUniqueConstraints(annotation, subelement);
        return (Table)AnnotationFactory.create((AnnotationDescriptor)annotation);
    }

    private SecondaryTables getSecondaryTables(Element tree, XMLContext.Default defaults) {
        List elements = tree == null ? new ArrayList() : tree.elements("secondary-table");
        ArrayList<SecondaryTable> secondaryTables = new ArrayList<SecondaryTable>(3);
        for (Element element : elements) {
            AnnotationDescriptor annotation = new AnnotationDescriptor(SecondaryTable.class);
            JPAOverridenAnnotationReader.copyStringAttribute(annotation, element, "name", false);
            JPAOverridenAnnotationReader.copyStringAttribute(annotation, element, "catalog", false);
            if (StringHelper.isNotEmpty(defaults.getCatalog()) && StringHelper.isEmpty((String)annotation.valueOf("catalog"))) {
                annotation.setValue("catalog", (Object)defaults.getCatalog());
            }
            JPAOverridenAnnotationReader.copyStringAttribute(annotation, element, "schema", false);
            if (StringHelper.isNotEmpty(defaults.getSchema()) && StringHelper.isEmpty((String)annotation.valueOf("schema"))) {
                annotation.setValue("schema", (Object)defaults.getSchema());
            }
            JPAOverridenAnnotationReader.buildUniqueConstraints(annotation, element);
            annotation.setValue("pkJoinColumns", (Object)this.buildPrimaryKeyJoinColumns(element));
            secondaryTables.add((SecondaryTable)AnnotationFactory.create((AnnotationDescriptor)annotation));
        }
        if (secondaryTables.size() == 0 && defaults.canUseJavaAnnotations()) {
            SecondaryTable secTableAnn = this.getJavaAnnotation(SecondaryTable.class);
            this.overridesDefaultInSecondaryTable(secTableAnn, defaults, secondaryTables);
            SecondaryTables secTablesAnn = this.getJavaAnnotation(SecondaryTables.class);
            if (secTablesAnn != null) {
                for (SecondaryTable table : secTablesAnn.value()) {
                    this.overridesDefaultInSecondaryTable(table, defaults, secondaryTables);
                }
            }
        }
        if (secondaryTables.size() > 0) {
            AnnotationDescriptor descriptor = new AnnotationDescriptor(SecondaryTables.class);
            descriptor.setValue("value", (Object)secondaryTables.toArray(new SecondaryTable[secondaryTables.size()]));
            return (SecondaryTables)AnnotationFactory.create((AnnotationDescriptor)descriptor);
        }
        return null;
    }

    private void overridesDefaultInSecondaryTable(SecondaryTable secTableAnn, XMLContext.Default defaults, List<SecondaryTable> secondaryTables) {
        if (secTableAnn != null) {
            if (StringHelper.isNotEmpty(defaults.getCatalog()) || StringHelper.isNotEmpty(defaults.getSchema())) {
                AnnotationDescriptor annotation = new AnnotationDescriptor(SecondaryTable.class);
                annotation.setValue("name", (Object)secTableAnn.name());
                annotation.setValue("schema", (Object)secTableAnn.schema());
                annotation.setValue("catalog", (Object)secTableAnn.catalog());
                annotation.setValue("uniqueConstraints", (Object)secTableAnn.uniqueConstraints());
                annotation.setValue("pkJoinColumns", (Object)secTableAnn.pkJoinColumns());
                if (StringHelper.isEmpty((String)annotation.valueOf("schema")) && StringHelper.isNotEmpty(defaults.getSchema())) {
                    annotation.setValue("schema", (Object)defaults.getSchema());
                }
                if (StringHelper.isEmpty((String)annotation.valueOf("catalog")) && StringHelper.isNotEmpty(defaults.getCatalog())) {
                    annotation.setValue("catalog", (Object)defaults.getCatalog());
                }
                secondaryTables.add((SecondaryTable)AnnotationFactory.create((AnnotationDescriptor)annotation));
            } else {
                secondaryTables.add(secTableAnn);
            }
        }
    }

    private static void buildUniqueConstraints(AnnotationDescriptor annotation, Element element) {
        List uniqueConstraintElementList = element.elements("unique-constraint");
        UniqueConstraint[] uniqueConstraints = new UniqueConstraint[uniqueConstraintElementList.size()];
        int ucIndex = 0;
        ListIterator ucIt = uniqueConstraintElementList.listIterator();
        while (ucIt.hasNext()) {
            Element subelement = (Element)ucIt.next();
            List columnNamesElements = subelement.elements("column-name");
            String[] columnNames = new String[columnNamesElements.size()];
            int columnNameIndex = 0;
            ListIterator it = columnNamesElements.listIterator();
            while (it.hasNext()) {
                Element columnNameElt = (Element)it.next();
                columnNames[columnNameIndex++] = columnNameElt.getTextTrim();
            }
            AnnotationDescriptor ucAnn = new AnnotationDescriptor(UniqueConstraint.class);
            JPAOverridenAnnotationReader.copyStringAttribute(ucAnn, subelement, "name", false);
            ucAnn.setValue("columnNames", (Object)columnNames);
            uniqueConstraints[ucIndex++] = (UniqueConstraint)AnnotationFactory.create((AnnotationDescriptor)ucAnn);
        }
        annotation.setValue("uniqueConstraints", (Object)uniqueConstraints);
    }

    private PrimaryKeyJoinColumn[] buildPrimaryKeyJoinColumns(Element element) {
        if (element == null) {
            return new PrimaryKeyJoinColumn[0];
        }
        List pkJoinColumnElementList = element.elements("primary-key-join-column");
        PrimaryKeyJoinColumn[] pkJoinColumns = new PrimaryKeyJoinColumn[pkJoinColumnElementList.size()];
        int index = 0;
        ListIterator pkIt = pkJoinColumnElementList.listIterator();
        while (pkIt.hasNext()) {
            Element subelement = (Element)pkIt.next();
            AnnotationDescriptor pkAnn = new AnnotationDescriptor(PrimaryKeyJoinColumn.class);
            JPAOverridenAnnotationReader.copyStringAttribute(pkAnn, subelement, "name", false);
            JPAOverridenAnnotationReader.copyStringAttribute(pkAnn, subelement, "referenced-column-name", false);
            JPAOverridenAnnotationReader.copyStringAttribute(pkAnn, subelement, "column-definition", false);
            pkJoinColumns[index++] = (PrimaryKeyJoinColumn)AnnotationFactory.create((AnnotationDescriptor)pkAnn);
        }
        return pkJoinColumns;
    }

    private static void copyStringAttribute(AnnotationDescriptor annotation, Element element, String attributeName, boolean mandatory) {
        String attribute = element.attributeValue(attributeName);
        if (attribute != null) {
            String annotationAttributeName = JPAOverridenAnnotationReader.getJavaAttributeNameFromXMLOne(attributeName);
            annotation.setValue(annotationAttributeName, (Object)attribute);
        } else if (mandatory) {
            throw new AnnotationException(element.getName() + "." + attributeName + " is mandatory in XML overriding. " + SCHEMA_VALIDATION);
        }
    }

    private static void copyIntegerAttribute(AnnotationDescriptor annotation, Element element, String attributeName) {
        String attribute = element.attributeValue(attributeName);
        if (attribute != null) {
            String annotationAttributeName = JPAOverridenAnnotationReader.getJavaAttributeNameFromXMLOne(attributeName);
            annotation.setValue(annotationAttributeName, (Object)attribute);
            try {
                int length = Integer.parseInt(attribute);
                annotation.setValue(annotationAttributeName, (Object)length);
            }
            catch (NumberFormatException e) {
                throw new AnnotationException(element.getPath() + attributeName + " not parseable: " + attribute + " (" + SCHEMA_VALIDATION + ")");
            }
        }
    }

    private static String getJavaAttributeNameFromXMLOne(String attributeName) {
        StringBuilder annotationAttributeName = new StringBuilder(attributeName);
        int index = annotationAttributeName.indexOf(WORD_SEPARATOR);
        while (index != -1) {
            annotationAttributeName.deleteCharAt(index);
            annotationAttributeName.setCharAt(index, Character.toUpperCase(annotationAttributeName.charAt(index)));
            index = annotationAttributeName.indexOf(WORD_SEPARATOR);
        }
        return annotationAttributeName.toString();
    }

    private static void copyStringElement(Element element, AnnotationDescriptor ad, String annotationAttribute) {
        String discr = element.getTextTrim();
        ad.setValue(annotationAttribute, (Object)discr);
    }

    private static void copyBooleanAttribute(AnnotationDescriptor descriptor, Element element, String attribute) {
        String attributeValue = element.attributeValue(attribute);
        if (StringHelper.isNotEmpty(attributeValue)) {
            String javaAttribute = JPAOverridenAnnotationReader.getJavaAttributeNameFromXMLOne(attribute);
            descriptor.setValue(javaAttribute, (Object)Boolean.parseBoolean(attributeValue));
        }
    }

    private <T extends Annotation> T getJavaAnnotation(Class<T> annotationType) {
        return this.element.getAnnotation(annotationType);
    }

    private <T extends Annotation> boolean isJavaAnnotationPresent(Class<T> annotationType) {
        return this.element.isAnnotationPresent(annotationType);
    }

    private Annotation[] getJavaAnnotations() {
        return this.element.getAnnotations();
    }

    static {
        FILTER = new Filter(){

            public boolean returnStatic() {
                return false;
            }

            public boolean returnTransient() {
                return false;
            }
        };
        annotationToXml = new HashMap<Class, String>();
        annotationToXml.put(Entity.class, "entity");
        annotationToXml.put(MappedSuperclass.class, "mapped-superclass");
        annotationToXml.put(Embeddable.class, "embeddable");
        annotationToXml.put(Table.class, "table");
        annotationToXml.put(SecondaryTable.class, "secondary-table");
        annotationToXml.put(SecondaryTables.class, "secondary-table");
        annotationToXml.put(PrimaryKeyJoinColumn.class, "primary-key-join-column");
        annotationToXml.put(PrimaryKeyJoinColumns.class, "primary-key-join-column");
        annotationToXml.put(IdClass.class, "id-class");
        annotationToXml.put(Inheritance.class, "inheritance");
        annotationToXml.put(DiscriminatorValue.class, "discriminator-value");
        annotationToXml.put(DiscriminatorColumn.class, "discriminator-column");
        annotationToXml.put(SequenceGenerator.class, "sequence-generator");
        annotationToXml.put(TableGenerator.class, "table-generator");
        annotationToXml.put(NamedQuery.class, "named-query");
        annotationToXml.put(NamedQueries.class, "named-query");
        annotationToXml.put(NamedNativeQuery.class, "named-native-query");
        annotationToXml.put(NamedNativeQueries.class, "named-native-query");
        annotationToXml.put(SqlResultSetMapping.class, "sql-result-set-mapping");
        annotationToXml.put(SqlResultSetMappings.class, "sql-result-set-mapping");
        annotationToXml.put(ExcludeDefaultListeners.class, "exclude-default-listeners");
        annotationToXml.put(ExcludeSuperclassListeners.class, "exclude-superclass-listeners");
        annotationToXml.put(AccessType.class, "access");
        annotationToXml.put(AttributeOverride.class, "attribute-override");
        annotationToXml.put(AttributeOverrides.class, "attribute-override");
        annotationToXml.put(AttributeOverride.class, "association-override");
        annotationToXml.put(AttributeOverrides.class, "association-override");
        annotationToXml.put(AttributeOverride.class, "map-key-attribute-override");
        annotationToXml.put(AttributeOverrides.class, "map-key-attribute-override");
        annotationToXml.put(Id.class, "id");
        annotationToXml.put(EmbeddedId.class, "embedded-id");
        annotationToXml.put(GeneratedValue.class, "generated-value");
        annotationToXml.put(Column.class, "column");
        annotationToXml.put(Columns.class, "column");
        annotationToXml.put(Temporal.class, "temporal");
        annotationToXml.put(Lob.class, "lob");
        annotationToXml.put(Enumerated.class, "enumerated");
        annotationToXml.put(Version.class, "version");
        annotationToXml.put(Transient.class, "transient");
        annotationToXml.put(Basic.class, "basic");
        annotationToXml.put(Embedded.class, "embedded");
        annotationToXml.put(ManyToOne.class, "many-to-one");
        annotationToXml.put(OneToOne.class, "one-to-one");
        annotationToXml.put(OneToMany.class, "one-to-many");
        annotationToXml.put(ManyToMany.class, "many-to-many");
        annotationToXml.put(JoinTable.class, "join-table");
        annotationToXml.put(JoinColumn.class, "join-column");
        annotationToXml.put(JoinColumns.class, "join-column");
        annotationToXml.put(MapKey.class, "map-key");
        annotationToXml.put(OrderBy.class, "order-by");
        annotationToXml.put(EntityListeners.class, "entity-listeners");
        annotationToXml.put(PrePersist.class, "pre-persist");
        annotationToXml.put(PreRemove.class, "pre-remove");
        annotationToXml.put(PreUpdate.class, "pre-update");
        annotationToXml.put(PostPersist.class, "post-persist");
        annotationToXml.put(PostRemove.class, "post-remove");
        annotationToXml.put(PostUpdate.class, "post-update");
        annotationToXml.put(PostLoad.class, "post-load");
        annotationToXml.put(CollectionTable.class, "collection-table");
        annotationToXml.put(MapKeyClass.class, "map-key-class");
        annotationToXml.put(MapKeyTemporal.class, "map-key-temporal");
        annotationToXml.put(MapKeyEnumerated.class, "map-key-enumerated");
        annotationToXml.put(MapKeyColumn.class, "map-key-column");
        annotationToXml.put(MapKeyJoinColumn.class, "map-key-join-column");
        annotationToXml.put(MapKeyJoinColumns.class, "map-key-join-column");
        annotationToXml.put(OrderColumn.class, "order-column");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PropertyType {
        PROPERTY,
        FIELD,
        METHOD;

    }
}

