/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.fluentlenium.custom;

import org.fest.assertions.GenericAssert;
import org.fluentlenium.core.domain.FluentWebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentWebElementAssert
extends GenericAssert<FluentWebElementAssert, FluentWebElement> {
    public FluentWebElementAssert(FluentWebElement actual) {
        super(FluentWebElementAssert.class, (Object)actual);
    }

    private void failIsEnabled() {
        super.fail("Object not enabled");
    }

    private void failIsNotEnabled() {
        super.fail("Object is enabled");
    }

    public FluentWebElementAssert isEnabled() {
        if (!((FluentWebElement)this.actual).isEnabled()) {
            this.failIsEnabled();
        }
        return this;
    }

    public FluentWebElementAssert isNotEnabled() {
        if (((FluentWebElement)this.actual).isEnabled()) {
            this.failIsNotEnabled();
        }
        return this;
    }

    public FluentWebElementAssert isDisplayed() {
        if (!((FluentWebElement)this.actual).isDisplayed()) {
            this.failIsNotDisplayed();
        }
        return this;
    }

    public FluentWebElementAssert isNotDisplayed() {
        if (((FluentWebElement)this.actual).isDisplayed()) {
            this.failIsDisplayed();
        }
        return this;
    }

    private void failIsDisplayed() {
        super.fail("Object not displayed");
    }

    private void failIsNotDisplayed() {
        super.fail("Object is displayed");
    }

    public FluentWebElementAssert isSelected() {
        if (!((FluentWebElement)this.actual).isSelected()) {
            this.failIsSelected();
        }
        return this;
    }

    public FluentWebElementAssert isNotSelected() {
        if (((FluentWebElement)this.actual).isSelected()) {
            this.failIsNotSelected();
        }
        return this;
    }

    public FluentWebElementAssert hasText(String textToFind) {
        if (!((FluentWebElement)this.actual).getText().contains(textToFind)) {
            super.fail("The element does not contain the text: " + textToFind + " . Actual text found : " + ((FluentWebElement)this.actual).getText());
        }
        return this;
    }

    public FluentWebElementAssert hasNotText(String textToFind) {
        if (((FluentWebElement)this.actual).getText().contains(textToFind)) {
            super.fail("The element contain the text: " + textToFind);
        }
        return this;
    }

    private void failIsSelected() {
        super.fail("Object not selected");
    }

    private void failIsNotSelected() {
        super.fail("Object is selected");
    }
}

