/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.security.user.User;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.XContentParser;

public final class AuthenticateResponse {
    static final ParseField USERNAME = new ParseField("username", new String[0]);
    static final ParseField ROLES = new ParseField("roles", new String[0]);
    static final ParseField METADATA = new ParseField("metadata", new String[0]);
    static final ParseField FULL_NAME = new ParseField("full_name", new String[0]);
    static final ParseField EMAIL = new ParseField("email", new String[0]);
    static final ParseField ENABLED = new ParseField("enabled", new String[0]);
    static final ParseField AUTHENTICATION_REALM = new ParseField("authentication_realm", new String[0]);
    static final ParseField LOOKUP_REALM = new ParseField("lookup_realm", new String[0]);
    static final ParseField REALM_NAME = new ParseField("name", new String[0]);
    static final ParseField REALM_TYPE = new ParseField("type", new String[0]);
    private static final ConstructingObjectParser<AuthenticateResponse, Void> PARSER = new ConstructingObjectParser("client_security_authenticate_response", true, a -> new AuthenticateResponse(new User((String)a[0], (List)a[1], (Map)a[2], (String)a[3], (String)a[4]), (Boolean)a[5], (RealmInfo)a[6], (RealmInfo)a[7]));
    private final User user;
    private final boolean enabled;
    private final RealmInfo authenticationRealm;
    private final RealmInfo lookupRealm;

    public AuthenticateResponse(User user, boolean enabled, RealmInfo authenticationRealm, RealmInfo lookupRealm) {
        this.user = user;
        this.enabled = enabled;
        this.authenticationRealm = authenticationRealm;
        this.lookupRealm = lookupRealm;
    }

    public User getUser() {
        return this.user;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public RealmInfo getAuthenticationRealm() {
        return this.authenticationRealm;
    }

    public RealmInfo getLookupRealm() {
        return this.lookupRealm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticateResponse that = (AuthenticateResponse)o;
        return this.enabled == that.enabled && Objects.equals(this.user, that.user) && Objects.equals(this.authenticationRealm, that.authenticationRealm) && Objects.equals(this.lookupRealm, that.lookupRealm);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.enabled, this.authenticationRealm, this.lookupRealm);
    }

    public static AuthenticateResponse fromXContent(XContentParser parser) throws IOException {
        return (AuthenticateResponse)PARSER.parse(parser, null);
    }

    static {
        ConstructingObjectParser realmInfoParser = new ConstructingObjectParser("realm_info", true, a -> new RealmInfo((String)a[0], (String)a[1]));
        realmInfoParser.declareString(ConstructingObjectParser.constructorArg(), REALM_NAME);
        realmInfoParser.declareString(ConstructingObjectParser.constructorArg(), REALM_TYPE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), USERNAME);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), ROLES);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, c) -> parser.map(), METADATA);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), FULL_NAME);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), EMAIL);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (ContextParser)realmInfoParser, AUTHENTICATION_REALM);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (ContextParser)realmInfoParser, LOOKUP_REALM);
    }

    public static class RealmInfo {
        private String name;
        private String type;

        RealmInfo(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RealmInfo realmInfo = (RealmInfo)o;
            return Objects.equals(this.name, realmInfo.name) && Objects.equals(this.type, realmInfo.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }
    }
}

