/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterGetSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.cluster.RemoteInfoRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;

final class ClusterRequestConverters {
    private ClusterRequestConverters() {
    }

    static Request clusterPutSettings(ClusterUpdateSettingsRequest clusterUpdateSettingsRequest) throws IOException {
        Request request = new Request("PUT", "/_cluster/settings");
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withTimeout(clusterUpdateSettingsRequest.timeout());
        parameters.withMasterTimeout(clusterUpdateSettingsRequest.masterNodeTimeout());
        request.addParameters(parameters.asMap());
        request.setEntity(RequestConverters.createEntity((ToXContent)clusterUpdateSettingsRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request clusterGetSettings(ClusterGetSettingsRequest clusterGetSettingsRequest) throws IOException {
        Request request = new Request("GET", "/_cluster/settings");
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withLocal(clusterGetSettingsRequest.local());
        parameters.withIncludeDefaults(clusterGetSettingsRequest.includeDefaults());
        parameters.withMasterTimeout(clusterGetSettingsRequest.masterNodeTimeout());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request clusterHealth(ClusterHealthRequest healthRequest) {
        String[] indices = healthRequest.indices() == null ? Strings.EMPTY_ARRAY : healthRequest.indices();
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_cluster/health").addCommaSeparatedPathParts(indices).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params().withWaitForStatus(healthRequest.waitForStatus()).withWaitForNoRelocatingShards(healthRequest.waitForNoRelocatingShards()).withWaitForNoInitializingShards(healthRequest.waitForNoInitializingShards()).withWaitForActiveShards(healthRequest.waitForActiveShards(), ActiveShardCount.NONE).withWaitForNodes(healthRequest.waitForNodes()).withWaitForEvents(healthRequest.waitForEvents()).withTimeout(healthRequest.timeout()).withMasterTimeout(healthRequest.masterNodeTimeout()).withLocal(healthRequest.local()).withLevel(healthRequest.level());
        request.addParameters(params.asMap());
        return request;
    }

    static Request remoteInfo(RemoteInfoRequest remoteInfoRequest) {
        return new Request("GET", "/_remote/info");
    }
}

