/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.jetty.maven.plugin.ConsoleScanner;
import org.eclipse.jetty.maven.plugin.JettyServer;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.maven.plugin.MavenServerConnector;
import org.eclipse.jetty.maven.plugin.PluginLog;
import org.eclipse.jetty.maven.plugin.SystemProperties;
import org.eclipse.jetty.maven.plugin.SystemProperty;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;

public abstract class AbstractJettyMojo
extends AbstractMojo {
    public String PORT_SYSPROPERTY = "jetty.port";
    protected boolean useProvidedScope;
    protected String[] excludedGoals;
    protected ContextHandler[] contextHandlers;
    protected LoginService[] loginServices;
    protected RequestLog requestLog;
    protected JettyWebAppContext webApp;
    protected int scanIntervalSeconds;
    protected String reload;
    protected File systemPropertiesFile;
    protected SystemProperties systemProperties;
    protected String jettyXml;
    protected int stopPort;
    protected String stopKey;
    protected boolean dumpOnStart;
    protected boolean daemon;
    protected boolean skip;
    protected String contextXml;
    protected MavenProject project;
    protected Set projectArtifacts;
    protected MojoExecution execution;
    protected List pluginArtifacts;
    protected MavenServerConnector httpConnector;
    protected JettyServer server = new JettyServer();
    protected Scanner scanner;
    protected ArrayList<File> scanList;
    protected ArrayList<Scanner.BulkListener> scannerListeners;
    protected Thread consoleScanner;

    public abstract void restartWebApp(boolean var1) throws Exception;

    public abstract void checkPomConfiguration() throws MojoExecutionException;

    public abstract void configureScanner() throws MojoExecutionException;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Configuring Jetty for project: " + this.project.getName()));
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Jetty start: jetty.skip==true");
            return;
        }
        if (this.isExcluded(this.execution.getMojoDescriptor().getGoal())) {
            this.getLog().info((CharSequence)("The goal \"" + this.execution.getMojoDescriptor().getFullGoalName() + "\" has been made unavailable for this web application by an <excludedGoal> configuration."));
            return;
        }
        this.configurePluginClasspath();
        PluginLog.setLog(this.getLog());
        this.checkPomConfiguration();
        this.startJetty();
    }

    public void configurePluginClasspath() throws MojoExecutionException {
        if (this.useProvidedScope) {
            try {
                ArrayList<URL> provided = new ArrayList<URL>();
                Object[] urls = null;
                for (Artifact artifact : this.projectArtifacts) {
                    if (!"provided".equals(artifact.getScope()) || this.isPluginArtifact(artifact)) continue;
                    provided.add(artifact.getFile().toURI().toURL());
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("Adding provided artifact: " + artifact));
                }
                if (!provided.isEmpty()) {
                    urls = new URL[provided.size()];
                    provided.toArray(urls);
                    URLClassLoader loader = new URLClassLoader((URL[])urls, ((Object)((Object)this)).getClass().getClassLoader());
                    Thread.currentThread().setContextClassLoader(loader);
                    this.getLog().info((CharSequence)("Plugin classpath augmented with <scope>provided</scope> dependencies: " + Arrays.toString(urls)));
                }
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Invalid url", (Exception)e);
            }
        }
    }

    public boolean isPluginArtifact(Artifact artifact) {
        if (this.pluginArtifacts == null || this.pluginArtifacts.isEmpty()) {
            return false;
        }
        boolean isPluginArtifact = false;
        Iterator iter = this.pluginArtifacts.iterator();
        while (iter.hasNext() && !isPluginArtifact) {
            Artifact pluginArtifact = (Artifact)iter.next();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Checking " + pluginArtifact));
            }
            if (!pluginArtifact.getGroupId().equals(artifact.getGroupId()) || !pluginArtifact.getArtifactId().equals(artifact.getArtifactId())) continue;
            isPluginArtifact = true;
        }
        return isPluginArtifact;
    }

    public void finishConfigurationBeforeStart() throws Exception {
        HandlerCollection contexts = (HandlerCollection)this.server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (contexts == null) {
            contexts = (HandlerCollection)this.server.getChildHandlerByClass(HandlerCollection.class);
        }
        for (int i = 0; this.contextHandlers != null && i < this.contextHandlers.length; ++i) {
            contexts.addHandler((Handler)this.contextHandlers[i]);
        }
    }

    public void applyJettyXml() throws Exception {
        if (this.getJettyXmlFiles() == null) {
            return;
        }
        this.server.applyXmlConfigurations(this.getJettyXmlFiles());
    }

    public void startJetty() throws MojoExecutionException {
        try {
            Connector[] connectors;
            this.getLog().debug((CharSequence)"Starting Jetty Server ...");
            if (this.stopPort > 0 && this.stopKey != null) {
                ShutdownMonitor monitor = ShutdownMonitor.getInstance();
                monitor.setPort(this.stopPort);
                monitor.setKey(this.stopKey);
                monitor.setExitVm(!this.daemon);
            }
            this.printSystemProperties();
            this.applyJettyXml();
            if (this.httpConnector != null) {
                if (this.httpConnector.getPort() <= 0) {
                    String tmp = System.getProperty(this.PORT_SYSPROPERTY, MavenServerConnector.DEFAULT_PORT_STR);
                    this.httpConnector.setPort(Integer.parseInt(tmp.trim()));
                }
                if (this.httpConnector.getServer() == null) {
                    this.httpConnector.setServer(this.server);
                }
                this.server.addConnector(this.httpConnector);
            }
            if ((connectors = this.server.getConnectors()) == null || connectors.length == 0) {
                if (this.httpConnector == null) {
                    this.httpConnector = new MavenServerConnector();
                    String tmp = System.getProperty(this.PORT_SYSPROPERTY, MavenServerConnector.DEFAULT_PORT_STR);
                    this.httpConnector.setPort(Integer.parseInt(tmp.trim()));
                }
                if (this.httpConnector.getServer() == null) {
                    this.httpConnector.setServer(this.server);
                }
                this.server.setConnectors(new Connector[]{this.httpConnector});
            }
            if (this.requestLog != null) {
                this.server.setRequestLog(this.requestLog);
            }
            this.server.configureHandlers();
            this.configureWebApplication();
            this.server.addWebApplication(this.webApp);
            for (int i = 0; this.loginServices != null && i < this.loginServices.length; ++i) {
                this.getLog().debug((CharSequence)(this.loginServices[i].getClass().getName() + ": " + this.loginServices[i].toString()));
                this.server.addBean(this.loginServices[i]);
            }
            this.finishConfigurationBeforeStart();
            this.server.start();
            this.getLog().info((CharSequence)"Started Jetty Server");
            if (this.dumpOnStart) {
                this.getLog().info((CharSequence)this.server.dump());
            }
            this.configureScanner();
            this.startScanner();
            this.startConsoleScanner();
            if (!this.daemon) {
                this.server.join();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure", e);
        }
        finally {
            if (!this.daemon) {
                this.getLog().info((CharSequence)"Jetty server exiting.");
            }
        }
    }

    public void configureWebApplication() throws Exception {
        String cp;
        if (this.webApp == null) {
            this.webApp = new JettyWebAppContext();
        }
        if (this.contextXml != null) {
            File file = FileUtils.getFile((String)this.contextXml);
            XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.toURL((File)file));
            this.getLog().info((CharSequence)("Applying context xml file " + this.contextXml));
            xmlConfiguration.configure((Object)this.webApp);
        }
        if ((cp = this.webApp.getContextPath()) == null || "".equals(cp)) {
            cp = "/" + this.project.getArtifactId();
            this.webApp.setContextPath(cp);
        }
        if (this.webApp.getTempDirectory() == null) {
            File target = new File(this.project.getBuild().getDirectory());
            File tmp = new File(target, "tmp");
            if (!tmp.exists()) {
                tmp.mkdirs();
            }
            this.webApp.setTempDirectory(tmp);
        }
        this.getLog().info((CharSequence)("Context path = " + this.webApp.getContextPath()));
        this.getLog().info((CharSequence)("Tmp directory = " + (this.webApp.getTempDirectory() == null ? " determined at runtime" : this.webApp.getTempDirectory())));
        this.getLog().info((CharSequence)("Web defaults = " + (this.webApp.getDefaultsDescriptor() == null ? " jetty default" : this.webApp.getDefaultsDescriptor())));
        this.getLog().info((CharSequence)("Web overrides = " + (this.webApp.getOverrideDescriptor() == null ? " none" : this.webApp.getOverrideDescriptor())));
    }

    private void startScanner() throws Exception {
        Iterator<Scanner.BulkListener> itor;
        if (this.scanIntervalSeconds <= 0) {
            return;
        }
        if ("manual".equalsIgnoreCase(this.reload)) {
            this.getLog().warn((CharSequence)("scanIntervalSeconds is set to " + this.scanIntervalSeconds + " but will be IGNORED due to manual reloading"));
            return;
        }
        this.scanner = new Scanner();
        this.scanner.setReportExistingFilesOnStartup(false);
        this.scanner.setScanInterval(this.scanIntervalSeconds);
        this.scanner.setScanDirs(this.scanList);
        this.scanner.setRecursive(true);
        Iterator<Scanner.BulkListener> iterator = itor = this.scannerListeners == null ? null : this.scannerListeners.iterator();
        while (itor != null && itor.hasNext()) {
            this.scanner.addListener((Scanner.Listener)itor.next());
        }
        this.getLog().info((CharSequence)("Starting scanner at interval of " + this.scanIntervalSeconds + " seconds."));
        this.scanner.start();
    }

    protected void startConsoleScanner() throws Exception {
        if ("manual".equalsIgnoreCase(this.reload)) {
            this.getLog().info((CharSequence)"Console reloading is ENABLED. Hit ENTER on the console to restart the context.");
            this.consoleScanner = new ConsoleScanner(this);
            this.consoleScanner.start();
        }
    }

    protected void printSystemProperties() {
        if (this.getLog().isDebugEnabled() && this.systemProperties != null) {
            for (SystemProperty prop : this.systemProperties.getSystemProperties()) {
                this.getLog().debug((CharSequence)("Property " + prop.getName() + "=" + prop.getValue() + " was " + (prop.isSet() ? "set" : "skipped")));
            }
        }
    }

    public File findJettyWebXmlFile(File webInfDir) {
        if (webInfDir == null) {
            return null;
        }
        if (!webInfDir.exists()) {
            return null;
        }
        File f = new File(webInfDir, "jetty-web.xml");
        if (f.exists()) {
            return f;
        }
        f = new File(webInfDir, "web-jetty.xml");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public void setSystemPropertiesFile(File file) throws Exception {
        this.systemPropertiesFile = file;
        Properties properties = new Properties();
        try (FileInputStream propFile = new FileInputStream(this.systemPropertiesFile);){
            properties.load(propFile);
        }
        if (this.systemProperties == null) {
            this.systemProperties = new SystemProperties();
        }
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (this.systemProperties.containsSystemProperty(key)) continue;
            SystemProperty prop = new SystemProperty();
            prop.setKey(key);
            prop.setValue(properties.getProperty(key));
            this.systemProperties.setSystemProperty(prop);
        }
    }

    public void setSystemProperties(SystemProperties systemProperties) {
        if (this.systemProperties == null) {
            this.systemProperties = systemProperties;
        } else {
            for (SystemProperty prop : systemProperties.getSystemProperties()) {
                this.systemProperties.setSystemProperty(prop);
            }
        }
    }

    public List<File> getJettyXmlFiles() {
        if (this.jettyXml == null) {
            return null;
        }
        ArrayList<File> jettyXmlFiles = new ArrayList<File>();
        if (this.jettyXml.indexOf(44) == -1) {
            jettyXmlFiles.add(new File(this.jettyXml));
        } else {
            String[] files;
            for (String file : files = this.jettyXml.split(",")) {
                jettyXmlFiles.add(new File(file));
            }
        }
        return jettyXmlFiles;
    }

    public boolean isExcluded(String goal) {
        if (this.excludedGoals == null || goal == null) {
            return false;
        }
        if ("".equals(goal = goal.trim())) {
            return false;
        }
        boolean excluded = false;
        for (int i = 0; i < this.excludedGoals.length && !excluded; ++i) {
            if (!this.excludedGoals[i].equalsIgnoreCase(goal)) continue;
            excluded = true;
        }
        return excluded;
    }
}

