/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadPendingException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.Callback;

public abstract class FillInterest {
    private final AtomicReference<Callback> _interested = new AtomicReference<Object>(null);

    protected FillInterest() {
    }

    public <C> void register(Callback callback) throws ReadPendingException {
        if (callback == null) {
            throw new IllegalArgumentException();
        }
        if (!this._interested.compareAndSet(null, callback)) {
            throw new ReadPendingException();
        }
        try {
            if (this.needsFill()) {
                this.fillable();
            }
        }
        catch (IOException e) {
            this.onFail(e);
        }
    }

    public void fillable() {
        Callback callback = this._interested.get();
        if (callback != null && this._interested.compareAndSet(callback, null)) {
            callback.succeeded();
        }
    }

    public boolean isInterested() {
        return this._interested.get() != null;
    }

    public void onFail(Throwable cause) {
        Callback callback = this._interested.get();
        if (callback != null && this._interested.compareAndSet(callback, null)) {
            callback.failed(cause);
        }
    }

    public void onClose() {
        Callback callback = this._interested.get();
        if (callback != null && this._interested.compareAndSet(callback, null)) {
            callback.failed((Throwable)new ClosedChannelException());
        }
    }

    public String toString() {
        return String.format("FillInterest@%x{%b,%s}", this.hashCode(), this._interested.get(), this._interested.get());
    }

    protected abstract boolean needsFill() throws IOException;
}

