/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.FillInterest;
import org.eclipse.jetty.io.IdleTimeout;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class AbstractEndPoint
extends IdleTimeout
implements EndPoint {
    private static final Logger LOG = Log.getLogger(AbstractEndPoint.class);
    private final long _created = System.currentTimeMillis();
    private final InetSocketAddress _local;
    private final InetSocketAddress _remote;
    private volatile Connection _connection;
    private final FillInterest _fillInterest = new FillInterest(){

        @Override
        protected boolean needsFill() throws IOException {
            return AbstractEndPoint.this.needsFill();
        }
    };
    private final WriteFlusher _writeFlusher = new WriteFlusher(this){

        @Override
        protected void onIncompleteFlushed() {
            AbstractEndPoint.this.onIncompleteFlush();
        }
    };

    protected AbstractEndPoint(Scheduler scheduler, InetSocketAddress local, InetSocketAddress remote) {
        super(scheduler);
        this._local = local;
        this._remote = remote;
    }

    @Override
    public long getCreatedTimeStamp() {
        return this._created;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this._local;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this._remote;
    }

    @Override
    public Connection getConnection() {
        return this._connection;
    }

    @Override
    public void setConnection(Connection connection) {
        this._connection = connection;
    }

    @Override
    public void onOpen() {
        LOG.debug("onOpen {}", new Object[]{this});
    }

    @Override
    public void onClose() {
        LOG.debug("onClose {}", new Object[]{this});
        this._writeFlusher.onClose();
        this._fillInterest.onClose();
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public <C> void fillInterested(C context, Callback<C> callback) throws IllegalStateException {
        this.notIdle();
        this._fillInterest.register(context, callback);
    }

    @Override
    public <C> void write(C context, Callback<C> callback, ByteBuffer ... buffers) throws IllegalStateException {
        this._writeFlusher.write(context, callback, buffers);
    }

    protected abstract void onIncompleteFlush();

    protected abstract boolean needsFill() throws IOException;

    protected FillInterest getFillInterest() {
        return this._fillInterest;
    }

    protected WriteFlusher getWriteFlusher() {
        return this._writeFlusher;
    }

    @Override
    protected void onIdleExpired(TimeoutException timeout) {
        if (this.isOutputShutdown() || this._fillInterest.isInterested() || this._writeFlusher.isInProgress()) {
            boolean output_shutdown = this.isOutputShutdown();
            this._fillInterest.onFail(timeout);
            this._writeFlusher.onFail(timeout);
            if (output_shutdown) {
                this.close();
            }
        }
    }

    public String toString() {
        return String.format("%s@%x{%s<r-l>%s,o=%b,is=%b,os=%b,fi=%s,wf=%s,it=%d}{%s}", this.getClass().getSimpleName(), this.hashCode(), this.getRemoteAddress(), this.getLocalAddress(), this.isOpen(), this.isInputShutdown(), this.isOutputShutdown(), this._fillInterest, this._writeFlusher, this.getIdleTimeout(), this.getConnection());
    }
}

