/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.bio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.eclipse.jetty.io.bio.StreamEndPoint;
import org.eclipse.jetty.util.log.Log;

public class SocketEndPoint
extends StreamEndPoint {
    Socket _socket;
    InetSocketAddress _local;
    InetSocketAddress _remote;

    public SocketEndPoint(Socket socket) throws IOException {
        super(socket.getInputStream(), socket.getOutputStream());
        this._socket = socket;
    }

    public boolean isOpen() {
        return super.isOpen() && this._socket != null && !this._socket.isClosed() && !this._socket.isInputShutdown() && !this._socket.isOutputShutdown();
    }

    public void close() throws IOException {
        if (!this._socket.isClosed() && !this._socket.isOutputShutdown()) {
            try {
                this._socket.shutdownOutput();
            }
            catch (IOException e) {
                Log.ignore((Throwable)e);
            }
            catch (UnsupportedOperationException e) {
                Log.ignore((Throwable)e);
            }
        }
        this._socket.close();
        this._in = null;
        this._out = null;
    }

    public String getLocalAddr() {
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getHostAddress();
    }

    public String getLocalHost() {
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getCanonicalHostName();
    }

    public int getLocalPort() {
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null) {
            return -1;
        }
        return this._local.getPort();
    }

    public String getRemoteAddr() {
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        if (this._remote == null) {
            return null;
        }
        InetAddress addr = this._remote.getAddress();
        return addr == null ? null : addr.getHostAddress();
    }

    public String getRemoteHost() {
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        if (this._remote == null) {
            return null;
        }
        return this._remote.getAddress().getCanonicalHostName();
    }

    public int getRemotePort() {
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        if (this._remote == null) {
            return -1;
        }
        return this._remote.getPort();
    }

    public Object getTransport() {
        return this._socket;
    }
}

