/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.transport.http.AxisServlet;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.exception.ViewerException;
import org.eclipse.birt.report.presentation.aggregation.IFragment;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.session.IViewingSession;
import org.eclipse.birt.report.session.ViewingSessionUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public abstract class BirtSoapMessageDispatcherServlet
extends AxisServlet {
    private static final long serialVersionUID = 1L;
    protected static boolean openSource = true;
    protected IFragment viewer = null;
    protected IFragment run = null;

    protected abstract void __init(ServletConfig var1);

    protected abstract boolean __authenticate(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract IContext __getContext(HttpServletRequest var1, HttpServletResponse var2) throws BirtException;

    protected abstract void __doGet(IContext var1) throws ServletException, IOException, BirtException;

    protected abstract void __doPost(IContext var1) throws ServletException, IOException, BirtException;

    protected abstract void __handleNonSoapException(HttpServletRequest var1, HttpServletResponse var2, Exception var3) throws ServletException, IOException;

    public static boolean isOpenSource() {
        return openSource;
    }

    public void init(ServletConfig config) throws ServletException {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        super.init(config);
        ParameterAccessor.initParameters(config);
        BirtResources.setLocale(ParameterAccessor.getWebAppLocale());
        this.__init(config);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        req.setAttribute("ServletPath", (Object)((HttpServletRequest)req).getServletPath());
        super.service(req, res);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.__authenticate(request, response)) {
            return;
        }
        try {
            IViewingSession session = ViewingSessionUtil.createSession(request);
            session.lock();
            try {
                IContext context = this.__getContext(request, response);
                if (context.getBean().getException() != null) {
                    this.__handleNonSoapException(request, response, context.getBean().getException());
                } else {
                    this.__doGet(context);
                }
            }
            finally {
                session.unlock();
            }
        }
        catch (BirtException e) {
            this.__handleNonSoapException(request, response, (Exception)((Object)e));
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block21: {
            IViewingSession session;
            if (!this.__authenticate(request, response)) {
                return;
            }
            StringBuffer builder = new StringBuffer();
            for (String paramName : request.getParameterMap().keySet()) {
                if (paramName == null || !paramName.startsWith("__")) continue;
                String paramValue = ParameterAccessor.urlEncode(ParameterAccessor.getParameter(request, paramName), "UTF-8");
                builder.append("&" + paramName + "=" + paramValue);
            }
            String soapURL = request.getRequestURL().toString();
            if (ParameterAccessor.getBaseURL() != null) {
                soapURL = String.valueOf(ParameterAccessor.getBaseURL()) + request.getContextPath() + request.getServletPath();
            }
            builder.deleteCharAt(0);
            soapURL = String.valueOf(soapURL) + "?" + builder.toString();
            request.setAttribute("SoapURL", (Object)soapURL);
            String requestType = request.getHeader("request-type");
            boolean isSoapRequest = "soap".equalsIgnoreCase(requestType);
            IContext context = null;
            try {
                session = ViewingSessionUtil.getSession(request);
                if (session == null && !isSoapRequest) {
                    if (ViewingSessionUtil.getSessionId(request) == null) {
                        session = ViewingSessionUtil.createSession(request);
                    } else {
                        throw new ViewerException(BirtResources.getMessage("birt.viewer.error.noviewingsession"));
                    }
                }
                context = this.__getContext(request, response);
            }
            catch (BirtException e) {
                this.__handleNonSoapException(request, response, (Exception)((Object)e));
                return;
            }
            try {
                try {
                    if (session != null) {
                        session.lock();
                    }
                    this.__doPost(context);
                    if (isSoapRequest) {
                        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                        super.doPost(request, response);
                        break block21;
                    }
                    try {
                        if (context.getBean().getException() != null) {
                            this.__handleNonSoapException(request, response, context.getBean().getException());
                        } else {
                            this.__doGet(context);
                        }
                    }
                    catch (BirtException e) {
                        this.__handleNonSoapException(request, response, (Exception)((Object)e));
                    }
                }
                catch (BirtException e) {
                    e.printStackTrace();
                    if (session != null && !session.isExpired()) {
                        session.unlock();
                    }
                }
            }
            finally {
                if (session != null && !session.isExpired()) {
                    session.unlock();
                }
            }
        }
    }
}

