/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.simpleapi.IDataBinding;
import org.eclipse.birt.report.model.simpleapi.Structure;

public class DataBindingImpl
extends Structure
implements IDataBinding {
    private ComputedColumn column;

    public DataBindingImpl() {
        super(null);
        this.column = this.createComputedColumn();
    }

    public DataBindingImpl(ComputedColumnHandle columnHandle) {
        super(columnHandle);
        if (columnHandle == null) {
            this.column = this.createComputedColumn();
        } else {
            this.structureHandle = columnHandle;
            this.column = (ComputedColumn)columnHandle.getStructure();
        }
    }

    public DataBindingImpl(ComputedColumn column) {
        super(null);
        this.column = column == null ? this.createComputedColumn() : column;
    }

    private ComputedColumn createComputedColumn() {
        ComputedColumn c = new ComputedColumn();
        return c;
    }

    @Override
    public String getAggregateOn() {
        return this.column.getAggregateOn();
    }

    @Override
    public String getDataType() {
        return this.column.getDataType();
    }

    @Override
    public String getExpression() {
        return this.column.getExpression();
    }

    @Override
    public String getName() {
        return this.column.getName();
    }

    @Override
    public void setAggregateOn(String on) throws SemanticException {
        if (this.structureHandle != null) {
            ActivityStack cmdStack = this.structureHandle.getModule().getActivityStack();
            cmdStack.startNonUndoableTrans(null);
            ((ComputedColumnHandle)this.structureHandle).setAggregateOn(on);
            cmdStack.commit();
            return;
        }
        this.column.setAggregateOn(on);
    }

    @Override
    public void setDataType(String dataType) throws SemanticException {
        if (this.structureHandle != null) {
            this.setProperty("dataType", dataType);
            return;
        }
        this.column.setDataType(dataType);
    }

    @Override
    public void setExpression(String expression) throws SemanticException {
        if (this.structureHandle != null) {
            this.setProperty("expression", expression);
            return;
        }
        this.column.setExpression(expression);
    }

    @Override
    public void setName(String name) throws SemanticException {
        if (this.structureHandle != null) {
            this.setProperty("name", name);
            return;
        }
        this.column.setName(name);
    }

    @Override
    public IStructure getStructure() {
        return this.column;
    }

    @Override
    public String getExpressionType() {
        Expression expression = this.column.getExpressionProperty("expression");
        if (expression == null) {
            return null;
        }
        return expression.getType();
    }

    @Override
    public void setExpressionType(String type) throws SemanticException {
        if (this.structureHandle != null) {
            ExpressionHandle handle = this.structureHandle.getExpressionProperty("expression");
            if (handle != null) {
                handle.setType(type);
            } else {
                Expression newExpression = new Expression(null, type);
                this.structureHandle.setExpressionProperty("expression", newExpression);
            }
            return;
        }
        Expression expression = this.column.getExpressionProperty("expression");
        Expression newValue = null;
        if (expression != null) {
            newValue = new Expression(expression.getExpression(), type);
        } else if (type != null) {
            newValue = new Expression(null, type);
        }
        this.column.setExpressionProperty("expression", newValue);
    }
}

