/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.core.PropertyStructure;
import org.eclipse.birt.report.model.util.ModelUtil;

public abstract class StyleRule
extends PropertyStructure {
    public static final String OPERATOR_MEMBER = "operator";
    public static final String VALUE1_MEMBER = "value1";
    public static final String VALUE2_MEMBER = "value2";
    public static final String TEST_EXPR_MEMBER = "testExpr";
    public static final String IS_DESIGN_TIME_MEMBER = "isDesignTime";
    protected String operator = null;
    protected List value1 = null;
    protected Expression value2 = null;
    protected Expression testExpression = null;
    protected Boolean isDesignTime = null;

    public StyleRule() {
    }

    public StyleRule(String op, String v1, String v2, String testExpr) {
        this.operator = op;
        this.value1 = new ArrayList();
        this.value1.add(new Expression(v1, null));
        this.value2 = new Expression(v2, null);
        this.testExpression = new Expression(testExpr, null);
    }

    @Override
    protected Object getIntrinsicProperty(String propName) {
        if (OPERATOR_MEMBER.equals(propName)) {
            return this.operator;
        }
        if (VALUE1_MEMBER.equals(propName)) {
            return this.value1;
        }
        if (VALUE2_MEMBER.equals(propName)) {
            return this.value2;
        }
        if (TEST_EXPR_MEMBER.equals(propName)) {
            return this.testExpression;
        }
        if (IS_DESIGN_TIME_MEMBER.equals(propName)) {
            return this.isDesignTime;
        }
        return super.getIntrinsicProperty(propName);
    }

    @Override
    protected void setIntrinsicProperty(String propName, Object value) {
        if (OPERATOR_MEMBER.equals(propName)) {
            this.operator = (String)value;
        } else if (VALUE1_MEMBER.equals(propName)) {
            if (value == null) {
                this.value1 = null;
                return;
            }
            if (value instanceof List) {
                this.value1 = (List)value;
            } else {
                this.value1 = new ArrayList();
                this.value1.add(value);
            }
        } else if (VALUE2_MEMBER.equals(propName)) {
            this.value2 = (Expression)value;
        } else if (TEST_EXPR_MEMBER.equals(propName)) {
            this.testExpression = (Expression)value;
        } else if (IS_DESIGN_TIME_MEMBER.equals(propName)) {
            this.isDesignTime = (Boolean)value;
        } else {
            super.setIntrinsicProperty(propName, value);
        }
    }

    public String getOperator() {
        return (String)this.getProperty(null, OPERATOR_MEMBER);
    }

    public void setOperator(String operator) {
        this.setProperty(OPERATOR_MEMBER, (Object)operator);
    }

    public String getValue1() {
        List valueList = this.getValue1List();
        if (valueList == null || valueList.isEmpty()) {
            return null;
        }
        return (String)valueList.get(0);
    }

    public List getValue1List() {
        List valueList = (List)this.getProperty(null, VALUE1_MEMBER);
        if (valueList == null || valueList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(ModelUtil.getExpressionCompatibleList(valueList));
    }

    public List getValue1ExpressionList() {
        List valueList = (List)this.getProperty(null, VALUE1_MEMBER);
        if (valueList == null || valueList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(valueList);
    }

    public void setValue1(String value) {
        if (value == null) {
            this.setProperty(VALUE1_MEMBER, null);
            return;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.add(value);
        this.setProperty(VALUE1_MEMBER, valueList);
    }

    public void setValue1(List value1List) {
        this.setProperty(VALUE1_MEMBER, (Object)value1List);
    }

    public String getValue2() {
        return this.getStringProperty(null, VALUE2_MEMBER);
    }

    public void setValue2(String value) {
        this.setProperty(VALUE2_MEMBER, (Object)value);
    }

    public void setTestExpression(String expression) {
        this.setProperty(TEST_EXPR_MEMBER, (Object)expression);
    }

    public String getTestExpression() {
        return this.testExpression == null ? null : this.testExpression.getStringExpression();
    }

    @Override
    public boolean isDesignTime() {
        Boolean isDesignTime = (Boolean)this.getProperty(null, IS_DESIGN_TIME_MEMBER);
        if (isDesignTime == null) {
            return true;
        }
        return isDesignTime;
    }

    public void setDesignTime(boolean isDesignTime) {
        this.setProperty(IS_DESIGN_TIME_MEMBER, (Object)isDesignTime);
    }
}

