/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.odaconsumer.DataTypeUtil;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class UserDefinedParamMetaData
implements IParameterMetaData {
    private Object[] paraDefnList;
    private static Logger logger = Logger.getLogger(UserDefinedParamMetaData.class.getName());

    public UserDefinedParamMetaData(List parameterDefnList) {
        logger.entering(UserDefinedParamMetaData.class.getName(), "UserDefinedParamMetaData", parameterDefnList);
        this.paraDefnList = parameterDefnList == null || parameterDefnList.size() == 0 ? new Object[0] : parameterDefnList.toArray();
        logger.exiting(UserDefinedParamMetaData.class.getName(), "UserDefinedParamMetaData");
    }

    public int getParameterCount() throws OdaException {
        return this.paraDefnList.length;
    }

    public int getParameterMode(int param) throws OdaException {
        IParameterDefinition defn = (IParameterDefinition)this.paraDefnList[param - 1];
        if (defn.isInputMode() && defn.isOutputMode()) {
            return 2;
        }
        if (defn.isInputMode()) {
            return 1;
        }
        if (defn.isOutputMode()) {
            return 3;
        }
        return 0;
    }

    public String getParameterName(int param) throws OdaException {
        return ((IParameterDefinition)this.paraDefnList[param - 1]).getName();
    }

    public int getParameterType(int param) throws OdaException {
        IParameterDefinition defn = (IParameterDefinition)this.paraDefnList[param - 1];
        Class dataTypeClass = DataType.getClass(defn.getType());
        return DataTypeUtil.toOdaType(dataTypeClass);
    }

    public String getParameterTypeName(int param) throws OdaException {
        return "Unknown";
    }

    public int getPrecision(int param) throws OdaException {
        return 0;
    }

    public int getScale(int param) throws OdaException {
        return 0;
    }

    public int isNullable(int param) throws OdaException {
        return 0;
    }
}

