/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import org.w3c.dom.css.CSSValue;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;

public class AreaBorders {
    public boolean isMergedCells;
    public int bottom;
    public int left;
    public int right;
    public int top;
    public CSSValue[] cssStyle = new CSSValue[4];
    public CSSValue[] cssWidth = new CSSValue[4];
    public CSSValue[] cssColour = new CSSValue[4];

    private AreaBorders(boolean isMergedCells, int bottom, int left, int right, int top, CSSValue[] cssStyle, CSSValue[] cssWidth, CSSValue[] cssColour) {
        this.isMergedCells = isMergedCells;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
        this.top = top;
        this.cssStyle = cssStyle;
        this.cssWidth = cssWidth;
        this.cssColour = cssColour;
    }

    public static AreaBorders create(int bottom, int left, int right, int top, BirtStyle borderStyle) {
        return AreaBorders.create(false, bottom, left, right, top, borderStyle);
    }

    public static AreaBorders createForMergedCells(int bottom, int left, int right, int top, BirtStyle borderStyle) {
        return AreaBorders.create(true, bottom, left, right, top, borderStyle);
    }

    public static AreaBorders create(boolean isMergedCells, int bottom, int left, int right, int top, BirtStyle borderStyle) {
        CSSValue borderStyleBottom = borderStyle.getProperty(22);
        CSSValue borderWidthBottom = borderStyle.getProperty(11);
        CSSValue borderColourBottom = borderStyle.getProperty(15);
        CSSValue borderStyleLeft = borderStyle.getProperty(52);
        CSSValue borderWidthLeft = borderStyle.getProperty(42);
        CSSValue borderColourLeft = borderStyle.getProperty(46);
        CSSValue borderStyleRight = borderStyle.getProperty(21);
        CSSValue borderWidthRight = borderStyle.getProperty(10);
        CSSValue borderColourRight = borderStyle.getProperty(14);
        CSSValue borderStyleTop = borderStyle.getProperty(49);
        CSSValue borderWidthTop = borderStyle.getProperty(41);
        CSSValue borderColourTop = borderStyle.getProperty(13);
        if (borderStyleBottom == null || "none".equals(borderStyleBottom.getCssText()) || borderWidthBottom == null || "0".equals(borderWidthBottom.getCssText()) || borderColourBottom == null || "transparent".equals(borderColourBottom.getCssText())) {
            borderStyleBottom = null;
            borderWidthBottom = null;
            borderColourBottom = null;
        }
        if (borderStyleLeft == null || "none".equals(borderStyleLeft.getCssText()) || borderWidthLeft == null || "0".equals(borderWidthLeft.getCssText()) || borderColourLeft == null || "transparent".equals(borderColourLeft.getCssText())) {
            borderStyleLeft = null;
            borderWidthLeft = null;
            borderColourLeft = null;
        }
        if (borderStyleRight == null || "none".equals(borderStyleRight.getCssText()) || borderWidthRight == null || "0".equals(borderWidthRight.getCssText()) || borderColourRight == null || "transparent".equals(borderColourRight.getCssText())) {
            borderStyleRight = null;
            borderWidthRight = null;
            borderColourRight = null;
        }
        if (borderStyleTop == null || "none".equals(borderStyleTop.getCssText()) || borderWidthTop == null || "0".equals(borderWidthTop.getCssText()) || borderColourTop == null || "transparent".equals(borderColourTop.getCssText())) {
            borderStyleTop = null;
            borderWidthTop = null;
            borderColourTop = null;
        }
        if (bottom >= 0 && (borderStyleBottom != null || borderWidthBottom != null || borderColourBottom != null) || left >= 0 && (borderStyleLeft != null || borderWidthLeft != null || borderColourLeft != null) || right >= 0 && (borderStyleRight != null || borderWidthRight != null || borderColourRight != null) || top >= 0 && (borderStyleTop != null || borderWidthTop != null || borderColourTop != null)) {
            CSSValue[] cssStyle = new CSSValue[]{borderStyleBottom, borderStyleLeft, borderStyleRight, borderStyleTop};
            CSSValue[] cssWidth = new CSSValue[]{borderWidthBottom, borderWidthLeft, borderWidthRight, borderWidthTop};
            CSSValue[] cssColour = new CSSValue[]{borderColourBottom, borderColourLeft, borderColourRight, borderColourTop};
            return new AreaBorders(isMergedCells, bottom, left, right, top, cssStyle, cssWidth, cssColour);
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[").append(this.top).append(",").append(this.left).append("]");
        result.append("-");
        result.append("[").append(this.bottom).append(",").append(this.right).append("]");
        result.append("=");
        int i = 0;
        while (i < 4) {
            result.append("[");
            result.append(this.cssStyle[i]);
            result.append(";");
            result.append(this.cssWidth[i]);
            result.append(";");
            result.append(this.cssColour[i]);
            result.append("]");
            ++i;
        }
        return result.toString();
    }
}

