/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.core.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.eclipse.birt.data.engine.core.DataException;

public class FileSecurity {
    public static boolean createNewFile(final File file) throws IOException {
        if (file == null) {
            return false;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws IOException {
                    return file.createNewFile();
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception typedException = e.getException();
            if (typedException instanceof IOException) {
                throw (IOException)typedException;
            }
            return false;
        }
    }

    public static RandomAccessFile createRandomAccessFile(final String path, final String type) throws FileNotFoundException, DataException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<RandomAccessFile>(){

                @Override
                public RandomAccessFile run() throws FileNotFoundException {
                    return new RandomAccessFile(path, type);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception typedException = e.getException();
            if (typedException instanceof FileNotFoundException) {
                throw (FileNotFoundException)typedException;
            }
            throw new DataException(e.getLocalizedMessage());
        }
    }

    public static RandomAccessFile createRandomAccessFile(final File file, final String type) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<RandomAccessFile>(){

                @Override
                public RandomAccessFile run() throws FileNotFoundException {
                    return new RandomAccessFile(file, type);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception typedException = e.getException();
            if (typedException instanceof FileNotFoundException) {
                throw (FileNotFoundException)typedException;
            }
            return null;
        }
    }

    public static FileReader createFileReader(final File file) throws FileNotFoundException, DataException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileReader>(){

                @Override
                public FileReader run() throws FileNotFoundException {
                    return new FileReader(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception typedException = e.getException();
            if (typedException instanceof FileNotFoundException) {
                throw (FileNotFoundException)typedException;
            }
            throw new DataException(e.getLocalizedMessage());
        }
    }

    public static FileOutputStream createFileOutputStream(File file) throws FileNotFoundException, DataException {
        return FileSecurity.createFileOutputStream(file, false);
    }

    public static FileOutputStream createFileOutputStream(final File file, final boolean append) throws FileNotFoundException, DataException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(file, append);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception typedException = e.getException();
            if (typedException instanceof FileNotFoundException) {
                throw (FileNotFoundException)typedException;
            }
            throw new DataException(e.getMessage());
        }
    }

    public static FileInputStream createFileInputStream(final File file) throws FileNotFoundException, DataException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception typedException = e.getException();
            if (typedException instanceof FileNotFoundException) {
                throw (FileNotFoundException)typedException;
            }
            throw new DataException(e.getMessage());
        }
    }

    public static boolean fileExist(final File file) {
        if (file == null) {
            return false;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
    }

    public static boolean fileIsFile(final File file) {
        if (file == null) {
            return false;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isFile();
            }
        });
    }

    public static File[] fileListFiles(final File file) {
        if (file == null) {
            return new File[0];
        }
        return AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return file.listFiles();
            }
        });
    }

    public static boolean fileIsDirectory(final File file) {
        if (file == null) {
            return false;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isDirectory();
            }
        });
    }

    public static String fileGetAbsolutePath(final File file) {
        if (file == null) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return file.getAbsolutePath();
            }
        });
    }

    public static String fileGetCanonicalPath(final File file) throws IOException, DataException {
        if (file == null) {
            return null;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    return file.getCanonicalPath();
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception typedException = e.getException();
            if (typedException instanceof IOException) {
                throw (IOException)typedException;
            }
            throw new DataException(e.getMessage());
        }
    }

    public static boolean fileDelete(final File file) {
        if (file == null) {
            return true;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.delete();
            }
        });
    }

    public static void fileDeleteOnExit(final File file) {
        if (file == null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                file.deleteOnExit();
                return null;
            }
        });
    }

    public static boolean fileMakeDirs(final File file) {
        if (file == null) {
            return false;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.mkdirs();
            }
        });
    }

    public static File fileGetCanonicalFile(final File file) throws IOException, DataException {
        if (file == null) {
            return null;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws IOException {
                    return file.getCanonicalFile();
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception typedException = e.getException();
            if (typedException instanceof IOException) {
                throw (IOException)typedException;
            }
            throw new DataException(e.getMessage());
        }
    }
}

