/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyListRecord
extends SimpleRecord {
    private final DesignElement element;
    private final ElementPropertyDefn propDefn;
    private final StructureContext context;
    private final List<Object> list;
    private final Object value;
    protected final boolean isAdd;
    private final int posn;

    public PropertyListRecord(DesignElement element, StructureContext context, int posn) {
        this.element = element;
        this.isAdd = false;
        this.context = context;
        this.propDefn = context.getElementProp();
        assert (element == context.getElement());
        Object valueContainer = context.getValueContainer();
        this.list = valueContainer instanceof Structure ? (List)((Structure)valueContainer).getLocalProperty(null, context.getPropDefn()) : (List)((DesignElement)valueContainer).getLocalProperty(null, (ElementPropertyDefn)context.getPropDefn());
        this.posn = posn;
        this.value = this.list.get(posn);
        this.label = CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{context.getElementProp().getDisplayName()});
    }

    public PropertyListRecord(DesignElement element, StructureContext context, Object toAdd, int posn) {
        this.element = element;
        this.isAdd = true;
        this.context = context;
        this.value = toAdd;
        this.propDefn = context.getElementProp();
        assert (element == context.getElement());
        Object valueContainer = context.getValueContainer();
        this.list = valueContainer instanceof Structure ? (List)((Structure)valueContainer).getLocalProperty(null, context.getPropDefn()) : (List)((DesignElement)valueContainer).getLocalProperty(null, (ElementPropertyDefn)context.getPropDefn());
        this.posn = posn;
        this.label = CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{context.getElementProp().getDisplayName()});
    }

    public PropertyListRecord(DesignElement element, ElementPropertyDefn propDefn, List theList, Object toAdd, int posn) {
        this.element = element;
        this.isAdd = true;
        this.value = toAdd;
        this.list = theList;
        this.context = null;
        this.propDefn = propDefn;
        this.posn = posn;
        this.label = CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{propDefn.getDisplayName()});
    }

    public PropertyListRecord(DesignElement element, ElementPropertyDefn propDefn, List theList, int posn) {
        this.element = element;
        this.isAdd = false;
        this.list = theList;
        this.posn = posn;
        this.value = this.list.get(posn);
        this.context = new StructureContext(element, propDefn, null);
        this.propDefn = propDefn;
        this.label = CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{propDefn.getDisplayName()});
    }

    @Override
    protected void perform(boolean undo) {
        boolean doAdd;
        boolean bl = doAdd = undo && !this.isAdd || !undo && this.isAdd;
        if (doAdd) {
            if (!(this.value instanceof Structure)) {
                this.list.add(this.posn, this.value);
                return;
            }
            this.context.add(this.posn, (Structure)this.value);
        } else {
            List listValue;
            if (!(this.value instanceof Structure)) {
                this.list.remove(this.posn);
                return;
            }
            this.context.remove(this.posn);
            Object localValue = this.context.getLocalValue(this.element.getRoot());
            if (localValue instanceof List && (listValue = (List)localValue).isEmpty()) {
                this.context.clearValue();
            }
        }
    }

    @Override
    public DesignElement getTarget() {
        if (this.eventTarget != null) {
            return this.eventTarget.getElement();
        }
        return this.element;
    }

    @Override
    public NotificationEvent getEvent() {
        if (this.eventTarget != null) {
            return new PropertyEvent(this.eventTarget.getElement(), this.eventTarget.getPropName());
        }
        return new PropertyEvent(this.element, this.propDefn.getName());
    }

    @Override
    protected List<RecordTask> getPostTasks() {
        ArrayList<RecordTask> retList = new ArrayList<RecordTask>();
        retList.addAll(super.getPostTasks());
        retList.add(new NotificationRecordTask(this.element, this.getEvent()));
        if (this.value != null && this.value instanceof IStructure && ((IStructure)this.value).isReferencable()) {
            ReferencableStructure refValue = (ReferencableStructure)this.value;
            retList.add(new NotificationRecordTask(refValue, this.getEvent()));
        }
        return retList;
    }
}

