/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.AbstractThemeHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.ThemeStyleNameValidator;
import org.eclipse.birt.report.model.command.ContentElementInfo;
import org.eclipse.birt.report.model.command.ContentRecord;
import org.eclipse.birt.report.model.command.NameRecord;
import org.eclipse.birt.report.model.command.NameSpaceRecord;
import org.eclipse.birt.report.model.command.PropertyRecord;
import org.eclipse.birt.report.model.command.RenameInNameSpaceRecord;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.namespace.INameHelper;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.AbstractTheme;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.TabularDimension;
import org.eclipse.birt.report.model.elements.strategy.TabularDimensionPropSearchStrategy;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public class NameCommand
extends AbstractElementCommand {
    private static final String STYLE_NAME_PATTERN = "([a-z]|[^\u0000-\u007f]|((\\[0-9a-f]{1,6}[ \n\r\t\f]?)|\\[ -~\u0080-!77777]))([a-z0-9-_]|[^\u0000-\u007f]|((\\[0-9a-f]{1,6}[ \n\r\t\f]?)|\\[ -~\u0080-!77777]))*";
    public static final Pattern styleNamePattern = Pattern.compile("([a-z]|[^\u0000-\u007f]|((\\[0-9a-f]{1,6}[ \n\r\t\f]?)|\\[ -~\u0080-!77777]))([a-z0-9-_]|[^\u0000-\u007f]|((\\[0-9a-f]{1,6}[ \n\r\t\f]?)|\\[ -~\u0080-!77777]))*", 2);
    private ContentElementInfo eventTarget;

    public NameCommand(Module module, DesignElement obj) {
        super(module, obj);
    }

    public void setName(String name) throws NameException {
        name = StringUtil.trimString(name);
        String oldName = this.element.getName();
        if (name == null && oldName == null || name != null && oldName != null && name.equals(oldName)) {
            return;
        }
        Dimension sharedDimension = TabularDimensionPropSearchStrategy.getSharedDimension(this.module, this.element);
        if (sharedDimension != null && !sharedDimension.getName().equals(name)) {
            return;
        }
        this.checkName(name);
        DesignElement tmpElement = this.element;
        if (tmpElement instanceof ContentElement && !((ContentElement)tmpElement).isLocal()) {
            this.eventTarget = ((ContentElement)tmpElement).getValueContainer();
            tmpElement = this.copyTopCompositeValue();
        }
        ActivityStack stack = this.getActivityStack();
        NameRecord rename = new NameRecord(tmpElement, name);
        stack.startTrans(rename.getLabel());
        stack.execute(rename);
        this.renameSymbolFrom(oldName);
        if (this.element instanceof Dimension) {
            this.updateDimensions(stack);
        }
        stack.commit();
    }

    private void updateDimensions(ActivityStack stack) {
        Dimension dimension = (Dimension)this.element;
        List<BackRef> clients = dimension.getClientList();
        for (BackRef client : clients) {
            DesignElement content = client.getElement();
            String propName = client.getPropertyName();
            if (!(content instanceof Dimension) || !"internalDimensionRef".equals(propName)) continue;
            NameRecord rename = new NameRecord(content, this.element.getName());
            stack.execute(rename);
        }
    }

    public void checkName(String name) throws NameException {
        ElementDefn metaData = (ElementDefn)this.element.getDefn();
        if (name == null) {
            if (this.element.hasDerived() || this.element.hasReferences()) {
                throw new NameException(this.element, null, "Error.NameException.HAS_REFERENCES");
            }
            if (metaData.getNameOption() == 2) {
                throw new NameException(this.element, null, "Error.NameException.NAME_REQUIRED");
            }
            if (this.module instanceof Library && this.element.getContainer() instanceof Library) {
                throw new NameException(this.element, null, "Error.NameException.NAME_REQUIRED");
            }
        } else {
            PropertyDefn propDefn = (PropertyDefn)((Object)metaData.getProperty("name"));
            if (propDefn == null) {
                throw new NameException(this.element, name, "Error.NameException.NAME_FORBIDDEN");
            }
            try {
                name = (String)propDefn.validateValue(this.module, this.element, name);
            }
            catch (PropertyValueException propertyValueException) {
                throw new NameException(this.element, name, "Error.NameException.INVALID_NAME");
            }
            if (this.element instanceof StyleElement && !styleNamePattern.matcher(name).matches()) {
                throw new NameException(this.element, name, "Error.NameException.INVALID_STYLE_NAME");
            }
            if (!this.isNameValidInContext(name)) {
                throw new NameException(this.element, name, "Error.NameException.DUPLICATE");
            }
            if (metaData.getNameOption() == 0) {
                throw new NameException(this.element, name, "Error.NameException.NAME_FORBIDDEN");
            }
            if (!this.element.isManagedByNameSpace()) {
                return;
            }
            DesignElement existedElement = new NameExecutor(this.element).getNameSpace(this.module).getElement(name);
            if (existedElement != null) {
                throw new NameException(this.element, name, "Error.NameException.DUPLICATE");
            }
        }
    }

    protected void addElement() throws NameException {
        this.checkName(this.element.getName());
        this.addSymbol();
    }

    protected void dropElement() {
        this.dropSymbol();
    }

    private void addSymbol() {
        String name = this.element.getName();
        if (name == null) {
            return;
        }
        DesignElement container = this.element.getContainer();
        if (container instanceof Theme) {
            ((Theme)container).dropCachedName(name);
            return;
        }
        if (!this.element.isManagedByNameSpace()) {
            return;
        }
        assert (this.element.getRoot() != null);
        NameExecutor nameExecutor = new NameExecutor(this.element);
        INameHelper nameHelper = nameExecutor.getNameHelper(this.module);
        assert (nameHelper != null);
        int ns = ((ElementDefn)this.element.getDefn()).getNameSpaceID();
        DesignElement existedElement = nameHelper.getNameSpace(ns).getElement(name);
        assert (existedElement == null);
        this.getActivityStack().execute(new NameSpaceRecord(nameHelper, ns, this.element, true));
    }

    private void dropSymbol() {
        if (this.element.getName() == null || !this.element.isManagedByNameSpace()) {
            return;
        }
        int ns = ((ElementDefn)this.element.getDefn()).getNameSpaceID();
        NameExecutor executor = new NameExecutor(this.element);
        if (executor.getNameSpace(this.module).getElement(this.element.getName()) != this.element) {
            return;
        }
        this.getActivityStack().execute(new NameSpaceRecord(executor.getNameHelper(this.module), ns, this.element, false));
    }

    private void renameSymbolFrom(String oldName) {
        if (this.element.isManagedByNameSpace()) {
            RenameInNameSpaceRecord record = new RenameInNameSpaceRecord(this.module, this.element, oldName, this.element.getName());
            this.getActivityStack().execute(record);
        }
    }

    private boolean isNameValidInContext(String name) {
        List<SemanticException> errors;
        DesignElement tmpContainer;
        return !(this.element instanceof Style) || !((tmpContainer = this.element.getContainer()) instanceof AbstractTheme) || (errors = ThemeStyleNameValidator.getInstance().validateForRenamingStyle((AbstractThemeHandle)tmpContainer.getHandle(this.module), (StyleHandle)this.element.getHandle(this.module), name)).isEmpty();
    }

    public void checkDimension() throws SemanticException {
        Dimension sharedDimension;
        if (this.element instanceof TabularDimension && (sharedDimension = TabularDimensionPropSearchStrategy.getSharedDimension(this.module, this.element)) != null) {
            String name = (String)this.element.getLocalProperty(this.module, "name");
            String sharedName = sharedDimension.getName();
            if (!sharedName.equals(name)) {
                NameExecutor nameExecutor = new NameExecutor(this.element);
                INameHelper nameHelper = nameExecutor.getNameHelper(this.module);
                assert (nameHelper != null);
                int ns = ((ElementDefn)this.element.getDefn()).getNameSpaceID();
                DesignElement existedElement = nameHelper.getNameSpace(ns).getElement(name);
                if (existedElement == null) {
                    this.setName(sharedName);
                } else if (existedElement == this.element) {
                    this.getActivityStack().execute(new NameSpaceRecord(nameHelper, ns, this.element, false));
                    this.setName(sharedName);
                } else {
                    this.setName(sharedName);
                }
            }
        }
    }

    private DesignElement makeLocalCompositeValue(DesignElement topElement, ElementPropertyDefn prop, DesignElement content) {
        Object localValue = topElement.getLocalProperty(this.module, prop);
        if (localValue != null) {
            return content;
        }
        Object inherited = topElement.getProperty(this.module, prop);
        if (inherited == null) {
            return null;
        }
        int index = -1;
        if (content != null && inherited instanceof List) {
            index = ((List)inherited).indexOf(content);
        }
        Object newValue = ModelUtil.copyValue(prop, inherited);
        ActivityStack activityStack = this.module.getActivityStack();
        ContainerContext context = new ContainerContext(topElement, prop.getName());
        if (newValue instanceof List) {
            List list = new ArrayList();
            PropertyRecord propRecord = new PropertyRecord(topElement, prop, list);
            activityStack.execute(propRecord);
            list = (List)newValue;
            int i = 0;
            while (i < list.size()) {
                DesignElement tmpContent = (DesignElement)list.get(i);
                ContentRecord addRecord = new ContentRecord(this.module, context, tmpContent, i);
                activityStack.execute(addRecord);
                ++i;
            }
        } else {
            PropertyRecord propRecord = new PropertyRecord(topElement, prop, newValue);
            activityStack.execute(propRecord);
        }
        if (index != -1) {
            return (DesignElement)((List)newValue).get(index);
        }
        return content;
    }

    private DesignElement copyTopCompositeValue() {
        if (!(this.element instanceof ContentElement)) {
            return null;
        }
        DesignElement topElement = this.eventTarget.getElement();
        String propName = this.eventTarget.getPropName();
        ElementPropertyDefn prop = topElement.getPropertyDefn(propName);
        this.makeLocalCompositeValue(topElement, prop, null);
        return this.matchElement(topElement);
    }

    private DesignElement matchElement(DesignElement topElement) {
        List<ContentElementInfo.Step> steps = this.eventTarget.stepIterator();
        DesignElement tmpElement = topElement;
        int i = steps.size() - 1;
        while (i >= 0) {
            ContentElementInfo.Step step = steps.get(i);
            PropertyDefn stepPropDefn = step.stepPropDefn;
            int index = step.index;
            Object stepValue = tmpElement.getLocalProperty(this.module, (ElementPropertyDefn)stepPropDefn);
            tmpElement = stepPropDefn.isListType() ? (DesignElement)((List)stepValue).get(index) : (DesignElement)stepValue;
            --i;
        }
        return tmpElement;
    }
}

