/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.AbstractThemeHandle;
import org.eclipse.birt.report.model.api.AccessControlHandle;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataGroupHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DerivedDataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DynamicFilterParameterHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LineHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.RectangleHandle;
import org.eclipse.birt.report.model.api.ReportItemThemeHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SortElementHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.ValueAccessControlHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.InvalidParentException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.OdaCubeHandle;
import org.eclipse.birt.report.model.api.olap.OdaDimensionHandle;
import org.eclipse.birt.report.model.api.olap.OdaHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.OdaLevelHandle;
import org.eclipse.birt.report.model.api.olap.OdaMeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.OdaMeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureHandle;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.AbstractTheme;
import org.eclipse.birt.report.model.elements.AccessControl;
import org.eclipse.birt.report.model.elements.AutoText;
import org.eclipse.birt.report.model.elements.CascadingParameterGroup;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.DataGroup;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.elements.DerivedDataSet;
import org.eclipse.birt.report.model.elements.DynamicFilterParameter;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.FilterConditionElement;
import org.eclipse.birt.report.model.elements.FreeForm;
import org.eclipse.birt.report.model.elements.GraphicMasterPage;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.ImageItem;
import org.eclipse.birt.report.model.elements.JointDataSet;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.LineItem;
import org.eclipse.birt.report.model.elements.ListGroup;
import org.eclipse.birt.report.model.elements.ListItem;
import org.eclipse.birt.report.model.elements.MemberValue;
import org.eclipse.birt.report.model.elements.MultiViews;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.elements.ParameterGroup;
import org.eclipse.birt.report.model.elements.RectangleItem;
import org.eclipse.birt.report.model.elements.ReportItemTheme;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.ScriptDataSet;
import org.eclipse.birt.report.model.elements.ScriptDataSource;
import org.eclipse.birt.report.model.elements.SimpleMasterPage;
import org.eclipse.birt.report.model.elements.SortElement;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.TextDataItem;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.ValueAccessControl;
import org.eclipse.birt.report.model.elements.VariableElement;
import org.eclipse.birt.report.model.elements.interfaces.IDerivedExtendableElementModel;
import org.eclipse.birt.report.model.elements.interfaces.IOdaExtendableElementModel;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.OdaCube;
import org.eclipse.birt.report.model.elements.olap.OdaDimension;
import org.eclipse.birt.report.model.elements.olap.OdaHierarchy;
import org.eclipse.birt.report.model.elements.olap.OdaLevel;
import org.eclipse.birt.report.model.elements.olap.OdaMeasure;
import org.eclipse.birt.report.model.elements.olap.OdaMeasureGroup;
import org.eclipse.birt.report.model.elements.olap.TabularCube;
import org.eclipse.birt.report.model.elements.olap.TabularDimension;
import org.eclipse.birt.report.model.elements.olap.TabularHierarchy;
import org.eclipse.birt.report.model.elements.olap.TabularLevel;
import org.eclipse.birt.report.model.elements.olap.TabularMeasure;
import org.eclipse.birt.report.model.elements.olap.TabularMeasureGroup;
import org.eclipse.birt.report.model.extension.oda.ODAProviderFactory;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;
import org.eclipse.birt.report.model.util.ElementFactoryUtil;
import org.eclipse.birt.report.model.util.ElementStructureUtil;

class ElementFactoryImpl {
    protected final Module module;

    public ElementFactoryImpl(Module module) {
        this.module = module;
    }

    public DesignElementHandle newElement(String elementTypeName, String name) {
        return ElementFactoryUtil.newElement(this.module, elementTypeName, name, true);
    }

    public FreeFormHandle newFreeForm(String name) {
        FreeForm element = new FreeForm(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public DataItemHandle newDataItem(String name) {
        DataItem element = new DataItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public LabelHandle newLabel(String name) {
        Label element = new Label(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public AutoTextHandle newAutoText(String name) {
        AutoText element = new AutoText(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public ImageHandle newImage(String name) {
        ImageItem element = new ImageItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public ListGroupHandle newListGroup() {
        ListGroup element = new ListGroup();
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public ListHandle newList(String name) {
        ListItem element = new ListItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public GraphicMasterPageHandle newGraphicMasterPage(String name) {
        GraphicMasterPage element = new GraphicMasterPage(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public SimpleMasterPageHandle newSimpleMasterPage(String name) {
        SimpleMasterPage element = new SimpleMasterPage(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public ParameterGroupHandle newParameterGroup(String name) {
        ParameterGroup element = new ParameterGroup(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public CascadingParameterGroupHandle newCascadingParameterGroup(String name) {
        CascadingParameterGroup element = new CascadingParameterGroup(name);
        this.module.makeUniqueName(element);
        return (CascadingParameterGroupHandle)element.handle(this.module);
    }

    public ScalarParameterHandle newScalarParameter(String name) {
        ScalarParameter element = new ScalarParameter(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public DynamicFilterParameterHandle newDynamicFilterParameter(String name) {
        DynamicFilterParameter element = new DynamicFilterParameter(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public SharedStyleHandle newStyle(String name) {
        Style element = new Style(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public SharedStyleHandle newStyle(AbstractThemeHandle theme, String name) {
        Style element = new Style(name);
        ((AbstractTheme)theme.getElement()).makeUniqueName(element);
        return element.handle(this.module);
    }

    public TextItemHandle newTextItem(String name) {
        TextItem element = new TextItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public TableHandle newTableItem(String name) {
        TableItem element = new TableItem(name);
        this.module.makeUniqueName(element);
        element.refreshRenderModel(this.module);
        return element.handle(this.module);
    }

    public TableHandle newTableItem(String name, int columnNum) {
        return this.newTableItem(name, columnNum, 1, 1, 1);
    }

    public TableHandle newTableItem(String name, int columnNum, int headerRow, int detailRow, int footerRow) {
        TableRow row;
        TableHandle tableHandle = this.newTableItem(name);
        TableItem table = (TableItem)tableHandle.getElement();
        columnNum = columnNum >= 0 ? columnNum : 0;
        headerRow = headerRow >= 0 ? headerRow : 0;
        footerRow = footerRow >= 0 ? footerRow : 0;
        detailRow = detailRow >= 0 ? detailRow : 0;
        int i = 0;
        while (i < columnNum) {
            TableColumn column = new TableColumn();
            table.add(column, 4);
            ++i;
        }
        i = 0;
        while (i < headerRow) {
            row = (TableRow)this.newTableRow(columnNum).getElement();
            table.add(row, 0);
            ++i;
        }
        i = 0;
        while (i < footerRow) {
            row = (TableRow)this.newTableRow(columnNum).getElement();
            table.add(row, 3);
            ++i;
        }
        i = 0;
        while (i < detailRow) {
            row = (TableRow)this.newTableRow(columnNum).getElement();
            table.add(row, 2);
            ++i;
        }
        table.refreshRenderModel(this.module);
        return tableHandle;
    }

    public TableGroupHandle newTableGroup() {
        TableGroup element = new TableGroup();
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public ColumnHandle newTableColumn() {
        TableColumn element = new TableColumn();
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public RowHandle newTableRow() {
        TableRow element = new TableRow();
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public RowHandle newTableRow(int cellNum) {
        RowHandle rowHandle = this.newTableRow();
        TableRow row = (TableRow)rowHandle.getElement();
        int j = 0;
        while (j < cellNum) {
            Cell cell = new Cell();
            row.add(cell, 0);
            ++j;
        }
        return rowHandle;
    }

    public CellHandle newCell() {
        Cell element = new Cell();
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public GridHandle newGridItem(String name) {
        GridItem element = new GridItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public GridHandle newGridItem(String name, int columnNum, int rowNum) {
        GridHandle gridHandle = this.newGridItem(name);
        GridItem grid = (GridItem)gridHandle.getElement();
        columnNum = columnNum >= 0 ? columnNum : 0;
        rowNum = rowNum >= 0 ? rowNum : 0;
        int i = 0;
        while (i < columnNum) {
            TableColumn column = new TableColumn();
            grid.add(column, 0);
            ++i;
        }
        i = 0;
        while (i < rowNum) {
            TableRow row = (TableRow)this.newTableRow(columnNum).getElement();
            grid.add(row, 1);
            ++i;
        }
        return gridHandle;
    }

    public LineHandle newLineItem(String name) {
        LineItem element = new LineItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public RectangleHandle newRectangle(String name) {
        RectangleItem element = new RectangleItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public TextDataHandle newTextData(String name) {
        TextDataItem element = new TextDataItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public ExtendedItemHandle newExtendedItem(String name, String extensionName) {
        try {
            return this.newExtendedItem(name, extensionName, null);
        }
        catch (ExtendsException extendsException) {
            assert (false);
            return null;
        }
    }

    private ExtendedItemHandle newExtendedItem(String name, String extensionName, ExtendedItemHandle parent) throws ExtendsException {
        ExtendedItemHandle handle;
        block6: {
            MetaDataDictionary dd = MetaDataDictionary.getInstance();
            ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(extensionName);
            if (extDefn == null) {
                return null;
            }
            if (parent != null) assert (((ExtendedItem)parent.getElement()).getExtDefn() == extDefn);
            if (!(extDefn instanceof PeerExtensionElementDefn)) {
                throw new IllegalOperationException("Only report item extension can be created through this method.");
            }
            ExtendedItem element = new ExtendedItem(name);
            element.setProperty("extensionName", (Object)extensionName);
            if (parent != null) {
                element.getHandle(this.module).setExtends(parent);
            }
            this.module.makeUniqueName(element);
            handle = element.handle(this.module);
            try {
                handle.loadExtendedElement();
            }
            catch (ExtendedElementException extendedElementException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        return handle;
    }

    public ScriptDataSourceHandle newScriptDataSource(String name) {
        ScriptDataSource element = new ScriptDataSource(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public ScriptDataSetHandle newScriptDataSet(String name) {
        ScriptDataSet element = new ScriptDataSet(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public OdaDataSourceHandle newOdaDataSource(String name) {
        OdaDataSource element = new OdaDataSource(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public OdaDataSourceHandle newOdaDataSource(String name, String extensionID) {
        OdaDataSource element = new OdaDataSource(name);
        if (extensionID != null) {
            if (ODAProviderFactory.getInstance().createODAProvider(element, extensionID) == null) {
                return null;
            }
            if (!ODAProviderFactory.getInstance().createODAProvider(element, extensionID).isValidExtensionID()) {
                return null;
            }
        }
        this.module.makeUniqueName(element);
        element.setProperty("extensionID", (Object)extensionID);
        return element.handle(this.module);
    }

    public OdaDataSetHandle newOdaDataSet(String name) {
        OdaDataSet element = new OdaDataSet(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public JointDataSetHandle newJointDataSet(String name) {
        JointDataSet element = new JointDataSet(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public OdaDataSetHandle newOdaDataSet(String name, String extensionID) {
        OdaDataSet element = new OdaDataSet(name);
        if (extensionID != null) {
            if (ODAProviderFactory.getInstance().createODAProvider(element, extensionID) == null) {
                return null;
            }
            if (!ODAProviderFactory.getInstance().createODAProvider(element, extensionID).isValidExtensionID()) {
                return null;
            }
        }
        this.module.makeUniqueName(element);
        element.setProperty("extensionID", (Object)extensionID);
        return element.handle(this.module);
    }

    public DerivedDataSetHandle newDerivedDataSet(String name, String extensionID) {
        DerivedDataSet element = new DerivedDataSet(name);
        this.module.makeUniqueName(element);
        element.setProperty("extensionID", (Object)extensionID);
        return element.handle(this.module);
    }

    public DesignElementHandle newElementFrom(DesignElementHandle baseElement, String name) throws ExtendsException {
        if (baseElement == null) {
            return null;
        }
        if (baseElement.getRoot().getElement() == this.module) {
            return this.createElementFrom(name, baseElement);
        }
        Module root = (Module)baseElement.getRoot().getElement();
        if (root instanceof Library) {
            Library lib = this.module.getLibraryByLocation(root.getLocation());
            if (lib == null) {
                throw new InvalidParentException(null, baseElement.getElement(), "Error.InvalidParentException.PARENT_NOT_INCLUDE");
            }
            DesignElement base = lib.getElementByID(baseElement.getID());
            if (base == null || base.getDefn() != baseElement.getElement().getDefn()) {
                throw new InvalidParentException(null, baseElement.getName(), "Error.InvalidParentException.PARENT_NOT_FOUND");
            }
            DesignElementHandle newHandle = this.createElementFrom(name, base.getHandle(lib));
            return newHandle;
        }
        return null;
    }

    protected DesignElementHandle createElementFrom(String name, DesignElementHandle baseElement) throws ExtendsException {
        DesignElementHandle childElement = null;
        if (baseElement instanceof ExtendedItemHandle) {
            String extensionName = baseElement.getStringProperty("extensionName");
            childElement = this.newExtendedItem(name, extensionName, (ExtendedItemHandle)baseElement);
            ElementStructureUtil.refreshStructureFromParent(this.module, childElement.getElement());
        } else {
            childElement = this.newElement(baseElement.getElement().getElementName(), name);
            String extensionProperty = null;
            if (childElement.getElement() instanceof IOdaExtendableElementModel) {
                extensionProperty = "extensionID";
            } else if (childElement.getElement() instanceof IDerivedExtendableElementModel) {
                extensionProperty = "extensionID";
            }
            if (extensionProperty != null) {
                String extensionId = (String)baseElement.getProperty(extensionProperty);
                childElement.getElement().setProperty(extensionProperty, (Object)extensionId);
            }
            childElement.setExtends(baseElement);
            ElementStructureUtil.refreshStructureFromParent(this.module, childElement.getElement());
        }
        this.module.rename(childElement.getElement());
        childElement.getElement().checkExtends(baseElement.getElement());
        return childElement;
    }

    public ThemeHandle newTheme(String name) {
        Theme element = new Theme(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public ReportItemThemeHandle newReportItemTheme(String name) {
        ReportItemTheme element = new ReportItemTheme(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public TabularCubeHandle newTabularCube(String name) {
        TabularCube element = new TabularCube(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public TabularDimensionHandle newTabularDimension(String name) {
        TabularDimension element = new TabularDimension(name);
        this.module.makeUniqueName(element);
        TabularHierarchy hierarchy = new TabularHierarchy();
        element.add(this.module, hierarchy, "hierarchies");
        this.module.makeUniqueName(hierarchy);
        element.setDefaultHierarchy(hierarchy);
        return element.handle(this.module);
    }

    public TabularHierarchyHandle newTabularHierarchy(String name) {
        TabularHierarchy element = new TabularHierarchy(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public TabularLevelHandle newTabularLevel(String name) {
        TabularLevel element = new TabularLevel(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public TabularLevelHandle newTabularLevel(DimensionHandle dimensionHandle, String name) {
        TabularLevel element = new TabularLevel(name);
        if (dimensionHandle != null) {
            ((Dimension)dimensionHandle.getElement()).makeUniqueName(element);
        }
        return element.handle(this.module);
    }

    public TabularMeasureHandle newTabularMeasure(String name) {
        TabularMeasure element = new TabularMeasure(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public TabularMeasureGroupHandle newTabularMeasureGroup(String name) {
        TabularMeasureGroup element = new TabularMeasureGroup(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public AccessControlHandle newAccessControl() {
        AccessControl element = new AccessControl();
        return element.handle(this.module);
    }

    public ValueAccessControlHandle newValueAccessControl() {
        ValueAccessControl element = new ValueAccessControl();
        return (ValueAccessControlHandle)((AccessControl)element).handle(this.module);
    }

    public OdaCubeHandle newOdaCube(String name) {
        OdaCube element = new OdaCube(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public OdaDimensionHandle newOdaDimension(String name) {
        OdaDimension element = new OdaDimension(name);
        this.module.makeUniqueName(element);
        OdaHierarchy hierarchy = new OdaHierarchy();
        element.add(this.module, hierarchy, "hierarchies");
        this.module.makeUniqueName(hierarchy);
        return element.handle(this.module);
    }

    public OdaHierarchyHandle newOdaHierarchy(String name) {
        OdaHierarchy element = new OdaHierarchy(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public OdaLevelHandle newOdaLevel(String name) {
        OdaLevel element = new OdaLevel(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public OdaLevelHandle newOdaLevel(DimensionHandle dimensionHandle, String name) {
        OdaLevel element = new OdaLevel(name);
        if (dimensionHandle != null) {
            ((Dimension)dimensionHandle.getElement()).makeUniqueName(element);
        }
        return element.handle(this.module);
    }

    public OdaMeasureHandle newOdaMeasure(String name) {
        OdaMeasure element = new OdaMeasure(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public OdaMeasureGroupHandle newOdaMeasureGroup(String name) {
        OdaMeasureGroup element = new OdaMeasureGroup(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public MemberValueHandle newMemberValue() {
        MemberValue element = new MemberValue();
        return element.handle(this.module);
    }

    public SortElementHandle newSortElement() {
        SortElement element = new SortElement();
        return element.handle(this.module);
    }

    public FilterConditionElementHandle newFilterConditionElement() {
        FilterConditionElement element = new FilterConditionElement();
        return element.handle(this.module);
    }

    public MultiViewsHandle newMultiView() {
        MultiViews element = new MultiViews();
        return (MultiViewsHandle)element.getHandle(this.module);
    }

    public VariableElementHandle newVariableElement() {
        return this.newVariableElement(null);
    }

    public VariableElementHandle newVariableElement(String variableName) {
        VariableElement element = new VariableElement(variableName);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public DataGroupHandle newDataGroup() {
        DataGroup element = new DataGroup();
        return element.handle(this.module);
    }
}

