/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.ArrayList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.impl.DataIterator;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractionResults
implements IExtractionResults {
    protected IQueryResults queryResults;
    protected IResultMetaData metaData;
    protected IDataIterator iterator;
    protected IResultIterator resultIterator;
    protected int startRow;
    protected int maxRows;

    public ExtractionResults(IQueryResults queryResults, IResultMetaData metaData, String[] selectedColumns, int startRow, int maxRows, DesignElementHandle handle) {
        this.queryResults = queryResults;
        ReportItemHandle tableHandle = null;
        ArrayList columnList = null;
        ArrayList<String> notAllowed = new ArrayList<String>();
        if (handle != null && handle instanceof TableHandle) {
            tableHandle = (TableHandle)handle;
        }
        if (tableHandle != null) {
            columnList = (ArrayList)tableHandle.getProperty("boundDataColumns");
        }
        if (columnList != null) {
            int i = 0;
            while (i < columnList.size()) {
                if (!((ComputedColumn)columnList.get(i)).allowExport()) {
                    notAllowed.add(((ComputedColumn)columnList.get(i)).getName());
                }
                ++i;
            }
        }
        if (notAllowed.size() > 0) {
            if (selectedColumns == null || selectedColumns.length <= 0) {
                int count = metaData.getColumnCount();
                ArrayList<String> tmpColumnArray = new ArrayList<String>();
                int i = 0;
                while (i < count) {
                    try {
                        if (this.isColumnAllowedExport(metaData.getColumnName(i), notAllowed)) {
                            tmpColumnArray.add(metaData.getColumnName(i));
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
                selectedColumns = tmpColumnArray.toArray(new String[0]);
            } else {
                ArrayList<String> tmpColumnArray = new ArrayList<String>();
                int i = 0;
                while (i < selectedColumns.length) {
                    if (this.isColumnAllowedExport(selectedColumns[i], notAllowed)) {
                        tmpColumnArray.add(selectedColumns[i]);
                    }
                    ++i;
                }
                selectedColumns = tmpColumnArray.toArray(new String[0]);
            }
        }
        this.metaData = selectedColumns == null ? metaData : new ResultMetaData(metaData, selectedColumns);
        this.startRow = startRow;
        this.maxRows = maxRows;
    }

    private boolean isColumnAllowedExport(String columnName, ArrayList<String> notAllowed) {
        if (notAllowed == null || notAllowed.size() <= 0) {
            return true;
        }
        int i = 0;
        while (i < notAllowed.size()) {
            if (columnName.equals(notAllowed.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ExtractionResults(IResultIterator resultIterator, IResultMetaData metaData, String[] selectedColumns, int startRow, int maxRows) {
        this.resultIterator = resultIterator;
        this.metaData = selectedColumns == null ? metaData : new ResultMetaData(metaData, selectedColumns);
        this.startRow = startRow;
        this.maxRows = maxRows;
    }

    @Override
    public IResultMetaData getResultMetaData() throws BirtException {
        return this.metaData;
    }

    @Override
    public IDataIterator nextResultIterator() throws BirtException {
        if (this.iterator == null) {
            if (this.resultIterator == null && this.queryResults != null) {
                this.resultIterator = this.queryResults.getResultIterator();
            }
            this.iterator = new DataIterator(this, this.resultIterator, this.startRow, this.maxRows);
        }
        return this.iterator;
    }

    @Override
    public void close() {
        if (this.queryResults != null) {
            try {
                this.queryResults.close();
            }
            catch (BirtException birtException) {}
            this.queryResults = null;
        }
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
    }
}

