/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api.timeFunction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.data.adapter.api.ArgumentInfo;
import org.eclipse.birt.report.data.adapter.api.timeFunction.IArgumentInfo;
import org.eclipse.birt.report.data.adapter.api.timeFunction.ITimeFunction;
import org.eclipse.birt.report.data.adapter.i18n.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTimeFunction
implements ITimeFunction {
    private String name;
    private String displayName;
    private String description;
    private IArgumentInfo period1;
    private IArgumentInfo period2;
    private List<IArgumentInfo.Period_Type> period_type1;
    private List<IArgumentInfo.Period_Type> period_type2;

    public BaseTimeFunction(String functionName, String displayName, String description) {
        this.name = functionName;
        this.displayName = displayName;
        this.description = description;
    }

    public BaseTimeFunction(ITimeFunction function, List<IArgumentInfo.Period_Type> timeType) {
        this(function.getName(), function.getDisplayName(), function.getDescription());
        this.period_type1 = new ArrayList<IArgumentInfo.Period_Type>();
        this.period_type2 = new ArrayList<IArgumentInfo.Period_Type>();
        this.period_type1.addAll(timeType);
        this.period_type2.addAll(timeType);
    }

    public BaseTimeFunction(ITimeFunction function, List<IArgumentInfo.Period_Type> timeType1, List<IArgumentInfo.Period_Type> timeType2) {
        this(function.getName(), function.getDisplayName(), function.getDescription());
        this.period_type1 = new ArrayList<IArgumentInfo.Period_Type>();
        this.period_type2 = new ArrayList<IArgumentInfo.Period_Type>();
        this.period_type1.addAll(timeType1);
        this.period_type2.addAll(timeType2);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<IArgumentInfo> getArguments() {
        ArrayList<IArgumentInfo> arguments = new ArrayList<IArgumentInfo>();
        this.period1 = new ArgumentInfo("Period1", Message.getMessage("timeFunction.PERIOD1.displayName"), Message.getMessage("timeFunction.PERIOD1"), false);
        this.period2 = new ArgumentInfo("Period2", Message.getMessage("timeFunction.PERIOD2.displayName"), Message.getMessage("timeFunction.PERIOD2"), false);
        if (this.name.equals("PREVIOUS MONTH")) {
            arguments.add(new ArgumentInfo("N for Period1", Message.getMessage("timeFunction.N1.Month.displayName"), Message.getMessage("timeFunction.N1.Month"), true));
        } else if (this.name.equals("PREVIOUS QUARTER")) {
            arguments.add(new ArgumentInfo("N for Period1", Message.getMessage("timeFunction.N1.Quarter.displayName"), Message.getMessage("timeFunction.N1.Quarter"), true));
        } else if (this.name.equals("PREVIOUS YEAR")) {
            arguments.add(new ArgumentInfo("N for Period1", Message.getMessage("timeFunction.N1.Year.displayName"), Message.getMessage("timeFunction.N1.Year"), true));
        } else if (this.name.equals("WEEK TO DATE LAST YEAR")) {
            arguments.add(new ArgumentInfo("N for Period1", Message.getMessage("timeFunction.N1.Year.displayName"), Message.getMessage("timeFunction.N1.Year"), true));
        } else if (this.name.equals("MONTH TO DATE LAST YEAR")) {
            arguments.add(new ArgumentInfo("N for Period1", Message.getMessage("timeFunction.N1.Year.displayName"), Message.getMessage("timeFunction.N1.Year"), true));
        } else if (this.name.equals("QUARTER TO DATE LAST YEAR")) {
            arguments.add(new ArgumentInfo("N for Period1", Message.getMessage("timeFunction.N1.Year.displayName"), Message.getMessage("timeFunction.N1.Year"), true));
        } else if (this.name.equals("PREVIOUS WEEK TO DATE")) {
            arguments.add(new ArgumentInfo("N for Period1", Message.getMessage("timeFunction.N1.Week.displayName"), Message.getMessage("timeFunction.N1.Week"), true));
        } else if (this.name.equals("PREVIOUS MONTH TO DATE")) {
            arguments.add(new ArgumentInfo("N for Period1", Message.getMessage("timeFunction.N1.Month.displayName"), Message.getMessage("timeFunction.N1.Month"), true));
        } else if (this.name.equals("PREVIOUS QUARTER TO DATE")) {
            arguments.add(new ArgumentInfo("N for Period1", Message.getMessage("timeFunction.N1.Quarter.displayName"), Message.getMessage("timeFunction.N1.Quarter"), true));
        } else if (this.name.equals("PREVIOUS YEAR TO DATE")) {
            arguments.add(new ArgumentInfo("N for Period1", Message.getMessage("timeFunction.N1.Year.displayName"), Message.getMessage("timeFunction.N1.Year"), true));
        } else if (this.name.equals("CURRENT PERIOD FROM N PERIODS AGO")) {
            int i = 0;
            while (i < this.period_type1.size()) {
                if (this.period_type1.get(i).name().equals(IArgumentInfo.Period_Type.Period_Type_ENUM.DAY.name())) {
                    this.period_type1.remove(this.period_type1.get(i));
                    break;
                }
                ++i;
            }
            ((ArgumentInfo)this.period1).setPeriodChoices(this.period_type1);
            ((ArgumentInfo)this.period1).setDisplayname(Message.getMessage("timeFunction.N1.current.displayName"));
            arguments.add(this.period1);
            arguments.add(new ArgumentInfo("N for Period2", Message.getMessage("timeFunction.N2.displayName"), Message.getMessage("timeFunction.N2"), false));
            ((ArgumentInfo)this.period2).setPeriodChoices(this.period_type2);
            ((ArgumentInfo)this.period2).setDisplayname(Message.getMessage("timeFunction.N2.Ago.displayName"));
            arguments.add(this.period2);
        } else if (this.name.equals("PERIOD TO DATE FROM N PERIODS AGO")) {
            int i = 0;
            while (i < this.period_type1.size()) {
                if (this.period_type1.get(i).name().equals(IArgumentInfo.Period_Type.Period_Type_ENUM.DAY.name())) {
                    this.period_type1.remove(this.period_type1.get(i));
                    break;
                }
                ++i;
            }
            ((ArgumentInfo)this.period1).setPeriodChoices(this.period_type1);
            ((ArgumentInfo)this.period1).setDisplayname(Message.getMessage("timeFunction.N1.period.displayName"));
            arguments.add(this.period1);
            arguments.add(new ArgumentInfo("N for Period2", Message.getMessage("timeFunction.N2.displayName"), Message.getMessage("timeFunction.N2"), false));
            ((ArgumentInfo)this.period2).setPeriodChoices(this.period_type2);
            ((ArgumentInfo)this.period2).setDisplayname(Message.getMessage("timeFunction.N2.Ago.displayName"));
            arguments.add(this.period2);
        } else if (this.name.equals("TRAILING N MONTHS")) {
            arguments.add(new ArgumentInfo("N for Period1", Message.getMessage("timeFunction.trailing.N1.Month.displayName"), Message.getMessage("timeFunction.N1.Month"), true));
        } else if (this.name.equals("TRAILING N DAYS")) {
            arguments.add(new ArgumentInfo("N for Period1", Message.getMessage("timeFunction.N1.Day.displayName"), Message.getMessage("timeFunction.N1.Day"), true));
        } else if (this.name.equals("TRAILING N PERIODS FROM N PERIODS AGO")) {
            ((ArgumentInfo)this.period1).setPeriodChoices(this.period_type1);
            arguments.add(new ArgumentInfo("N for Period1", Message.getMessage("timeFunction.trailing.N1.period.displayName"), Message.getMessage("timeFunction.N1"), false));
            arguments.add(this.period1);
            arguments.add(new ArgumentInfo("N for Period2", Message.getMessage("timeFunction.N2.displayName"), Message.getMessage("timeFunction.N2"), false));
            ((ArgumentInfo)this.period2).setPeriodChoices(this.period_type2);
            ((ArgumentInfo)this.period2).setDisplayname(Message.getMessage("timeFunction.N2.Ago.displayName"));
            arguments.add(this.period2);
        } else if (this.name.equals("NEXT_N_PERIODS")) {
            arguments.add(new ArgumentInfo("N for Period1", Message.getMessage("timeFunction.N1.next.displayName"), Message.getMessage("timeFunction.N1"), false));
            ((ArgumentInfo)this.period1).setPeriodChoices(this.period_type1);
            arguments.add(this.period1);
        }
        return arguments;
    }
}

