/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import org.eclipse.birt.data.engine.olap.cursor.AbstractCursorSupport;
import org.eclipse.birt.data.engine.olap.cursor.AggregationAccessor;
import org.eclipse.birt.data.engine.olap.cursor.EdgeCursorImpl;
import org.eclipse.birt.data.engine.olap.driver.IResultSet;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;

public class CubeCursorImpl
extends AbstractCursorSupport
implements CubeCursor {
    private List ordinateEdge = new ArrayList();
    private List pageEdge = new ArrayList();

    public CubeCursorImpl(BirtCubeView cubeView, IResultSet result, Map relationMap) throws OLAPException {
        this(cubeView, result, relationMap, null);
    }

    public CubeCursorImpl(BirtCubeView cubeView, IResultSet result, Map relationMap, Map appContext) throws OLAPException {
        super(null, new AggregationAccessor(cubeView, result, relationMap));
        if (result == null) {
            return;
        }
        if (cubeView.getColumnEdgeView() != null) {
            EdgeCursorImpl columnEdgeCursor = new EdgeCursorImpl(cubeView.getColumnEdgeView(), false, result.getColumnEdgeResult(), this);
            result.getColumnEdgeResult().populateEdgeInfo(false);
            this.ordinateEdge.add(columnEdgeCursor);
        }
        if (cubeView.getRowEdgeView() != null) {
            EdgeCursorImpl rowEdgeCursor = new EdgeCursorImpl(cubeView.getRowEdgeView(), false, result.getRowEdgeResult(), this);
            result.getRowEdgeResult().populateEdgeInfo(false);
            this.ordinateEdge.add(rowEdgeCursor);
        }
        if (cubeView.getPageEdgeView() != null) {
            EdgeCursorImpl pageEdgeCursor = new EdgeCursorImpl(cubeView.getPageEdgeView(), true, result.getPageEdgeResult(), this);
            result.getPageEdgeResult().populateEdgeInfo(true);
            this.pageEdge.add(pageEdgeCursor);
        }
    }

    public List getOrdinateEdge() throws OLAPException {
        return this.ordinateEdge;
    }

    public Collection getPageEdge() throws OLAPException {
        return this.pageEdge;
    }

    public void synchronizePages() throws OLAPException {
        if (this.pageEdge != null && !this.pageEdge.isEmpty()) {
            EdgeCursorImpl pageCursor = (EdgeCursorImpl)this.pageEdge.get(0);
            long position = pageCursor.getPosition();
            for (EdgeCursorImpl cursor : this.ordinateEdge) {
                cursor.synchronizedPages((int)position);
            }
        }
    }
}

