/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.IRDAggrUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressiveViewingRDAggrUtil
implements IRDAggrUtil {
    private Map<String, IAggrStorageInfo> aggrInfo;

    public ProgressiveViewingRDAggrUtil(RAInputStream combinedAggrIndex, RAInputStream combinedAggr, List<RAInputStream> aggrIndexStreams, List<RAInputStream> aggrStreams) throws DataException {
        try {
            int j;
            assert (aggrIndexStreams.size() == aggrStreams.size());
            this.aggrInfo = new HashMap<String, IAggrStorageInfo>();
            int i = 0;
            while (i < aggrIndexStreams.size()) {
                AggrStorageInfo asi = new AggrStorageInfo(aggrIndexStreams.get(i), aggrStreams.get(i));
                j = 0;
                while (j < asi.aggrNames.length) {
                    this.aggrInfo.put(asi.aggrNames[j], asi);
                    ++j;
                }
                ++i;
            }
            if (combinedAggrIndex != null) {
                RunningAggrStorageInfo running = new RunningAggrStorageInfo(combinedAggrIndex, combinedAggr);
                int j2 = 0;
                while (j2 < running.getAggrNames().length) {
                    this.aggrInfo.put(running.getAggrNames()[j2], running);
                    ++j2;
                }
                OverallAggrStorageInfo overall = new OverallAggrStorageInfo(combinedAggrIndex, combinedAggr);
                j = 0;
                while (j < overall.getAggrNames().length) {
                    this.aggrInfo.put(overall.getAggrNames()[j], overall);
                    ++j;
                }
            }
        }
        catch (Exception e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public boolean contains(String aggrName) {
        return this.aggrInfo.containsKey(aggrName);
    }

    @Override
    public int getGroupLevel(String aggrName) {
        return this.aggrInfo.get(aggrName).getGroupLevel();
    }

    @Override
    public boolean isRunningAggr(String aggrName) {
        return this.aggrInfo.get(aggrName) instanceof RunningAggrStorageInfo;
    }

    @Override
    public Object getValue(String aggrName, int groupInstanceIndex) throws DataException {
        return this.aggrInfo.get(aggrName).getAggrValue(aggrName, groupInstanceIndex);
    }

    @Override
    public void close() throws DataException {
        for (IAggrStorageInfo info : this.aggrInfo.values()) {
            info.close();
        }
    }

    private class AggrStorageInfo
    implements IAggrStorageInfo {
        private HashMap<String, Object> aggrNameValueMap;
        private String[] aggrNames;
        private int currentGroupLevel;
        private RAInputStream aggrStream;
        private DataInputStream aggrDIStream;
        private RAInputStream aggrIndexStream;
        private DataInputStream aggrIndexDIStream;
        private int groupLevel;

        AggrStorageInfo(RAInputStream aggrIndexStream, RAInputStream aggrStream) throws DataException {
            try {
                this.currentGroupLevel = -1;
                this.aggrStream = aggrStream;
                this.aggrDIStream = new DataInputStream(aggrStream);
                this.aggrIndexStream = aggrIndexStream;
                this.aggrIndexDIStream = new DataInputStream(aggrIndexStream);
                this.groupLevel = IOUtil.readInt(this.aggrDIStream);
                this.aggrNames = new String[IOUtil.readInt(this.aggrDIStream)];
                this.aggrNameValueMap = new HashMap();
                int i = 0;
                while (i < this.aggrNames.length) {
                    this.aggrNames[i] = IOUtil.readString(this.aggrDIStream);
                    ++i;
                }
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }

        public Object getAggrValue(String aggrName, int groupInstanceIndex) throws DataException {
            try {
                if (groupInstanceIndex != this.currentGroupLevel) {
                    this.currentGroupLevel = groupInstanceIndex;
                    if (this.aggrIndexStream.length() < (long)(8 * this.currentGroupLevel)) {
                        throw new DataException("The aggregation results are not ready yet.");
                    }
                    this.aggrIndexStream.seek(8 * this.currentGroupLevel);
                    long offset = IOUtil.readLong(this.aggrIndexDIStream);
                    this.aggrStream.seek(offset);
                    int i = 0;
                    while (i < this.aggrNames.length) {
                        this.aggrNameValueMap.put(this.aggrNames[i], IOUtil.readObject(this.aggrDIStream));
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
            return this.aggrNameValueMap.get(aggrName);
        }

        public String[] getAggrNames() {
            return this.aggrNames;
        }

        public int getGroupLevel() {
            return this.groupLevel;
        }

        public void close() {
            try {
                this.aggrDIStream.close();
                this.aggrIndexDIStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static interface IAggrStorageInfo {
        public Object getAggrValue(String var1, int var2) throws DataException;

        public String[] getAggrNames();

        public int getGroupLevel();

        public void close();
    }

    private class OverallAggrStorageInfo
    implements IAggrStorageInfo {
        private String[] overallAggregations;
        private Map<String, Object> overallAggregationValues;
        private RAInputStream aggrStream;
        private DataInputStream aggrDIStream;
        private RAInputStream aggrIndexStream;
        private DataInputStream aggrIndexDIStream;

        public OverallAggrStorageInfo(RAInputStream aggrIndexStream, RAInputStream aggrStream) throws DataException {
            try {
                this.aggrStream = aggrStream;
                this.aggrDIStream = new DataInputStream(aggrStream);
                this.aggrIndexStream = aggrIndexStream;
                this.aggrIndexDIStream = new DataInputStream(aggrIndexStream);
                this.aggrStream.seek(0L);
                int overallAggrSize = IOUtil.readInt(this.aggrDIStream);
                this.overallAggregations = new String[overallAggrSize];
                int i = 0;
                while (i < this.overallAggregations.length) {
                    this.overallAggregations[i] = IOUtil.readString(this.aggrDIStream);
                    ++i;
                }
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }

        private long getOverallAggrOffset() throws DataException {
            try {
                this.aggrIndexStream.seek(0L);
                return IOUtil.readLong(this.aggrIndexDIStream);
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }

        public Object getAggrValue(String aggrName, int groupInstanceIndex) throws DataException {
            long overallOffset;
            block5: {
                if (this.overallAggregationValues != null) {
                    return this.overallAggregationValues.get(aggrName);
                }
                overallOffset = 0L;
                overallOffset = this.getOverallAggrOffset();
                if (overallOffset != -1L) break block5;
                return null;
            }
            try {
                this.overallAggregationValues = new HashMap<String, Object>();
                this.aggrStream.seek(overallOffset);
                int i = 0;
                while (i < this.overallAggregations.length) {
                    this.overallAggregationValues.put(this.overallAggregations[i], IOUtil.readObject(this.aggrDIStream));
                    ++i;
                }
                return this.overallAggregationValues.get(aggrName);
            }
            catch (Exception e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }

        public String[] getAggrNames() {
            return this.overallAggregations;
        }

        public int getGroupLevel() {
            return 0;
        }

        public void close() {
            try {
                this.aggrDIStream.close();
                this.aggrIndexDIStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class RunningAggrStorageInfo
    implements IAggrStorageInfo {
        private RAInputStream aggrStream;
        private DataInputStream aggrDIStream;
        private RAInputStream aggrIndexStream;
        private DataInputStream aggrIndexDIStream;
        private String[] runningAggregations;
        private Map<String, Object> runningAggregationValues;
        private int currentIndex;

        public RunningAggrStorageInfo(RAInputStream aggrIndexStream, RAInputStream aggrStream) throws DataException {
            try {
                this.aggrStream = aggrStream;
                this.aggrDIStream = new DataInputStream(aggrStream);
                this.aggrIndexStream = aggrIndexStream;
                this.aggrIndexDIStream = new DataInputStream(aggrIndexStream);
                this.aggrIndexStream.seek(0L);
                this.currentIndex = -1;
                int overallAggrSize = IOUtil.readInt(this.aggrDIStream);
                int i = 0;
                while (i < overallAggrSize) {
                    IOUtil.readString(this.aggrDIStream);
                    ++i;
                }
                int runningAggrSize = IOUtil.readInt(this.aggrDIStream);
                this.runningAggregations = new String[runningAggrSize];
                int i2 = 0;
                while (i2 < this.runningAggregations.length) {
                    this.runningAggregations[i2] = IOUtil.readString(this.aggrDIStream);
                    ++i2;
                }
                this.runningAggregationValues = new HashMap<String, Object>();
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }

        public Object getAggrValue(String aggrName, int groupInstanceIndex) throws DataException {
            try {
                if (this.currentIndex == groupInstanceIndex && this.runningAggregationValues.containsKey(aggrName)) {
                    return this.runningAggregationValues.get(aggrName);
                }
                this.currentIndex = groupInstanceIndex;
                this.aggrIndexStream.seek(8 * (this.currentIndex + 1));
                long offset = IOUtil.readLong(this.aggrIndexDIStream);
                this.aggrStream.seek(offset);
                int i = 0;
                while (i < this.runningAggregations.length) {
                    this.runningAggregationValues.put(this.runningAggregations[i], IOUtil.readObject(this.aggrDIStream));
                    ++i;
                }
                return this.runningAggregationValues.get(aggrName);
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }

        public String[] getAggrNames() {
            return this.runningAggregations;
        }

        public int getGroupLevel() {
            return -1;
        }

        public void close() {
            try {
                this.aggrDIStream.close();
                this.aggrIndexDIStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

