/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.util.LinkedHashMap;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalMode
extends AggrFunction {
    public String getName() {
        return "MODE";
    }

    public int getType() {
        return 0;
    }

    public int getDataType() {
        return 0;
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    public String getDescription() {
        return Messages.getString("TotalMode.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalMode.displayName");
    }

    private static class MyAccumulator
    extends SummaryAccumulator {
        private LinkedHashMap cacheMap;
        private Object mode;
        private int maxCount;
        private boolean multiMaxValue;

        private MyAccumulator() {
        }

        public void start() {
            super.start();
            this.maxCount = 0;
            this.mode = null;
            this.cacheMap = new LinkedHashMap();
            this.multiMaxValue = false;
        }

        public void onRow(Object[] args) throws DataException {
            assert (args.length > 0);
            if (args[0] != null) {
                Object value = this.getTypedData(args[0]);
                Object obj = this.cacheMap.get(value);
                int count = 1;
                if (obj != null) {
                    count = (Integer)obj;
                    ++count;
                }
                this.cacheMap.put(value, count);
                if (count > this.maxCount) {
                    this.mode = value;
                    this.maxCount = count;
                    this.multiMaxValue = false;
                } else if (count == this.maxCount) {
                    this.multiMaxValue = true;
                }
            }
        }

        public void finish() throws DataException {
            super.finish();
        }

        public Object getSummaryValue() {
            if (this.maxCount == 1) {
                return null;
            }
            if (this.multiMaxValue && this.cacheMap != null && !this.cacheMap.isEmpty()) {
                for (Object key : this.cacheMap.keySet()) {
                    int count = (Integer)this.cacheMap.get(key);
                    if (count != this.maxCount) continue;
                    this.mode = key;
                    break;
                }
            }
            this.cacheMap = null;
            return this.mode;
        }
    }
}

