/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.SearchKeyHandle;
import org.eclipse.emf.common.util.EList;

class CompatibleExpressionUpdater {
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.reportitem/trace");

    CompatibleExpressionUpdater() {
    }

    static final void update(Chart model, Map newExpressions) {
        if (newExpressions == null) {
            return;
        }
        if (model instanceof ChartWithAxes) {
            CompatibleExpressionUpdater.updateRowExpressions((ChartWithAxes)model, newExpressions);
        } else if (model instanceof ChartWithoutAxes) {
            CompatibleExpressionUpdater.updateRowExpressions((ChartWithoutAxes)model, newExpressions);
        }
    }

    private static void updateRowExpressions(ChartWithoutAxes cwoa, Map newExpressions) {
        String sExpression;
        String newExp;
        EList<SeriesDefinition> elSD = cwoa.getSeriesDefinitions();
        if (elSD.size() == 0) {
            return;
        }
        SeriesDefinition sd = (SeriesDefinition)elSD.get(0);
        Series seBase = sd.getDesignTimeSeries();
        EList<Query> elBaseSeries = seBase.getDataDefinition();
        for (Query qBaseSeries : elBaseSeries) {
            if (qBaseSeries == null || (newExp = (String)newExpressions.get(sExpression = qBaseSeries.getDefinition())) == null) continue;
            qBaseSeries.setDefinition(newExp);
        }
        elSD = sd.getSeriesDefinitions();
        int k = 0;
        while (k < elSD.size()) {
            sd = (SeriesDefinition)elSD.get(k);
            Query qOrthogonalSeriesDefinition = sd.getQuery();
            if (qOrthogonalSeriesDefinition != null) {
                sExpression = qOrthogonalSeriesDefinition.getDefinition();
                newExp = (String)newExpressions.get(sExpression);
                if (newExp != null) {
                    qOrthogonalSeriesDefinition.setDefinition(newExp);
                }
                Series seOrthogonal = sd.getDesignTimeSeries();
                EList<Query> elOrthogonalSeries = seOrthogonal.getDataDefinition();
                int i = 0;
                while (i < elOrthogonalSeries.size()) {
                    Query qOrthogonalSeries = (Query)elOrthogonalSeries.get(i);
                    if (qOrthogonalSeries != null && (newExp = (String)newExpressions.get(sExpression = qOrthogonalSeries.getDefinition())) != null) {
                        qOrthogonalSeries.setDefinition(newExp);
                    }
                    ++i;
                }
                CompatibleExpressionUpdater.updateSeriesTriggerExpressions(seOrthogonal, newExpressions);
            }
            ++k;
        }
    }

    private static void updateRowExpressions(ChartWithAxes cwa, Map newExpressions) {
        String sExpression;
        String newExp;
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        EList<SeriesDefinition> elSD = axPrimaryBase.getSeriesDefinitions();
        if (elSD.size() == 0) {
            return;
        }
        SeriesDefinition sd = (SeriesDefinition)elSD.get(0);
        Series seBase = sd.getDesignTimeSeries();
        EList<Query> elBaseSeries = seBase.getDataDefinition();
        for (Query qBaseSeries : elBaseSeries) {
            if (qBaseSeries == null || (newExp = (String)newExpressions.get(sExpression = qBaseSeries.getDefinition())) == null) continue;
            qBaseSeries.setDefinition(newExp);
        }
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
        int j = 0;
        while (j < axaOrthogonal.length) {
            elSD = axaOrthogonal[j].getSeriesDefinitions();
            int k = 0;
            while (k < elSD.size()) {
                sd = (SeriesDefinition)elSD.get(k);
                Query qOrthogonalSeriesDefinition = sd.getQuery();
                if (qOrthogonalSeriesDefinition != null) {
                    sExpression = qOrthogonalSeriesDefinition.getDefinition();
                    newExp = (String)newExpressions.get(sExpression);
                    if (newExp != null) {
                        qOrthogonalSeriesDefinition.setDefinition(newExp);
                    }
                    Series seOrthogonal = sd.getDesignTimeSeries();
                    EList<Query> elOrthogonalSeries = seOrthogonal.getDataDefinition();
                    int i = 0;
                    while (i < elOrthogonalSeries.size()) {
                        Query qOrthogonalSeries = (Query)elOrthogonalSeries.get(i);
                        if (qOrthogonalSeries != null && (newExp = (String)newExpressions.get(sExpression = qOrthogonalSeries.getDefinition())) != null) {
                            qOrthogonalSeries.setDefinition(newExp);
                        }
                        ++i;
                    }
                    CompatibleExpressionUpdater.updateSeriesTriggerExpressions(seOrthogonal, newExpressions);
                }
                ++k;
            }
            ++j;
        }
    }

    private static void updateSeriesTriggerExpressions(Series se, Map newExpressions) {
        if (se == null || newExpressions == null) {
            return;
        }
        for (Trigger tg : se.getTriggers()) {
            CompatibleExpressionUpdater.updateActionExpressions(tg.getAction(), newExpressions);
        }
    }

    private static void updateActionExpressions(Action action, Map newExpressions) {
        TooltipValue tv;
        String exp;
        String newExp;
        if (ActionType.URL_REDIRECT_LITERAL.equals((Object)action.getType())) {
            URLValue uv = (URLValue)action.getValue();
            String sa = uv.getBaseUrl();
            try {
                boolean updated = false;
                ActionHandle handle = ModuleUtil.deserializeAction(sa);
                if ("hyperlink".equals(handle.getLinkType())) {
                    String exp2 = handle.getURI();
                    String newExp2 = (String)newExpressions.get(exp2);
                    if (newExp2 != null) {
                        updated = true;
                        handle.setURI(newExp2);
                    }
                } else if ("bookmark-link".equals(handle.getLinkType())) {
                    String exp3 = handle.getTargetBookmark();
                    String newExp3 = (String)newExpressions.get(exp3);
                    if (newExp3 != null) {
                        updated = true;
                        handle.setTargetBookmark(newExp3);
                    }
                } else if ("drill-through".equals(handle.getLinkType())) {
                    String exp4 = handle.getTargetBookmark();
                    String newExp4 = (String)newExpressions.get(exp4);
                    if (newExp4 != null) {
                        updated = true;
                        handle.setTargetBookmark(newExp4);
                    }
                    Iterator itr = handle.getSearch().iterator();
                    while (itr.hasNext()) {
                        SearchKeyHandle skh = (SearchKeyHandle)itr.next();
                        exp4 = skh.getExpression();
                        newExp4 = (String)newExpressions.get(exp4);
                        if (newExp4 == null) continue;
                        updated = true;
                        skh.setExpression(newExp4);
                    }
                    itr = handle.getParamBindings().iterator();
                    while (itr.hasNext()) {
                        ParamBindingHandle pbh = (ParamBindingHandle)itr.next();
                        exp4 = pbh.getExpression();
                        newExp4 = (String)newExpressions.get(exp4);
                        if (newExp4 == null) continue;
                        updated = true;
                        pbh.setExpression(newExp4);
                    }
                }
                if (updated) {
                    uv.setBaseUrl(ModuleUtil.serializeAction(handle));
                }
            }
            catch (Exception e) {
                logger.log(e);
            }
        } else if (ActionType.SHOW_TOOLTIP_LITERAL.equals((Object)action.getType()) && (newExp = (String)newExpressions.get(exp = (tv = (TooltipValue)action.getValue()).getText())) != null) {
            tv.setText(newExp);
        }
    }
}

