/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.layout.LabelBlock;

public class TextRenderEvent
extends PrimitiveRenderEvent {
    private static final long serialVersionUID = 1683131722588162319L;
    public static final int UNDEFINED = 0;
    public static final int RENDER_SHADOW_AT_LOCATION = 1;
    public static final int RENDER_TEXT_AT_LOCATION = 2;
    public static final int RENDER_TEXT_IN_BLOCK = 3;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int ABOVE = 4;
    public static final int BELOW = 8;
    protected transient Bounds _boBlock;
    protected transient Label _la;
    protected transient TextAlignment _taBlock;
    protected int _iAction = 0;
    protected transient Location _lo;
    protected int _iTextPosition;

    public TextRenderEvent(Object oSource) {
        super(oSource);
    }

    public final void setBlockBounds(Bounds boBlock) {
        this._boBlock = boBlock;
    }

    public final void setRtlCaption() {
        Text txt;
        String val;
        Label lbl = this.getLabel();
        if (lbl != null && (val = (txt = lbl.getCaption()).getValue()).length() > 0 && '\u202b' != val.charAt(0)) {
            txt.setValue(String.valueOf('\u202b') + val + '\u202c');
        }
    }

    public final Bounds getBlockBounds() {
        return this._boBlock;
    }

    public final void setLabel(Label la) {
        this._la = la;
    }

    public final Label getLabel() {
        return this._la;
    }

    public final void setBlockAlignment(TextAlignment taBlock) {
        this._taBlock = taBlock;
    }

    public final TextAlignment getBlockAlignment() {
        return this._taBlock;
    }

    public final void setAction(int iAction) {
        this._iAction = iAction;
    }

    public final int getAction() {
        return this._iAction;
    }

    public final void setLocation(Location lo) {
        this._lo = lo;
    }

    public final Location getLocation() {
        return this._lo;
    }

    public final void setTextPosition(int iTextPosition) {
        this._iTextPosition = iTextPosition;
    }

    public final int getTextPosition() {
        return this._iTextPosition;
    }

    public final void updateFrom(LabelBlock lb, double dScale, RunTimeContext rtc) {
        this.setLabel(lb.getLabel());
        Bounds bo = goFactory.scaleBounds(lb.getBounds(), dScale);
        bo.adjust(goFactory.scaleInsets(lb.getInsets(), dScale));
        this.setBlockBounds(bo);
        this.setBlockAlignment(lb.getLabel().getCaption().getFont().getAlignment());
        this.setAction(3);
    }

    public PrimitiveRenderEvent copy() {
        TextRenderEvent tre = new TextRenderEvent(this.source);
        tre.setBlockBounds(goFactory.copyOf(this._boBlock));
        tre.setAction(this._iAction);
        tre.setTextPosition(this._iTextPosition);
        if (this._la != null) {
            tre.setLabel(goFactory.copyCompactLabel(this._la));
        }
        if (this._lo != null) {
            tre.setLocation(this._lo.copyInstance());
        }
        if (this._taBlock != null) {
            tre.setBlockAlignment(goFactory.copyOf(this._taBlock));
        }
        return tre;
    }

    public void fill(IDeviceRenderer idr) throws ChartException {
        this.draw(idr);
    }

    public final void draw(IDeviceRenderer idr) throws ChartException {
        idr.drawText(this);
    }

    public void reset() {
        this._boBlock = null;
        this._la = null;
        this._lo = null;
        this._taBlock = null;
    }
}

