/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.TemplateArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLeafItemLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFTemplateLM
extends PDFLeafItemLM {
    public PDFTemplateLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        assert (content instanceof IAutoTextContent);
        this.handleAutoText((IAutoTextContent)content);
    }

    public boolean layoutChildren() {
        IAutoTextContent autoText = (IAutoTextContent)this.content;
        ContainerArea templateContainer = (ContainerArea)AreaFactory.createInlineContainer(autoText, true, true);
        IStyle areaStyle = templateContainer.getStyle();
        int maxWidth = this.parent.getCurrentMaxContentWidth();
        this.validateBoxProperty(areaStyle, maxWidth, this.context.getMaxHeight());
        int width = this.getDimensionValue(autoText.getWidth(), maxWidth);
        templateContainer.setAllocatedWidth(maxWidth - this.parent.getCurrentIP());
        int minContentWidth = this.getDimensionValue(areaStyle.getFontSize()) * 4;
        int maxContentWidth = templateContainer.getWidth();
        int preWidth = 0;
        preWidth = width >= maxContentWidth ? Math.max(maxContentWidth, minContentWidth) : Math.max(minContentWidth, width);
        templateContainer.setWidth(preWidth);
        int height = this.getDimensionValue(autoText.getHeight(), maxWidth);
        templateContainer.setContentHeight(Math.max((int)((double)this.getDimensionValue(areaStyle.getFontSize()) * 1.35), height));
        Dimension templateDimension = new Dimension();
        templateDimension.setDimension(templateContainer.getContentWidth(), templateContainer.getContentHeight());
        TemplateArea templateArea = this.createTemplateArea(autoText, templateDimension);
        templateContainer.addChild(templateArea);
        templateArea.setPosition(templateContainer.getContentX(), templateContainer.getContentY());
        this.parent.addArea(templateContainer, false, false);
        return false;
    }

    protected void handleAutoText(IAutoTextContent autoText) {
        if (autoText.getType() == 0) {
            this.context.addUnresolvedContent(autoText);
        }
        if (1 == autoText.getType()) {
            String originalPageNumber = autoText.getText();
            DataFormatValue format = autoText.getComputedStyle().getDataFormat();
            NumberFormatter nf = null;
            if (format == null) {
                nf = new NumberFormatter();
            } else {
                String pattern = format.getNumberPattern();
                String locale = format.getNumberLocale();
                nf = locale == null ? new NumberFormatter(pattern) : new NumberFormatter(pattern, new ULocale(locale));
            }
            autoText.setText(nf.format(Integer.parseInt(originalPageNumber)));
        }
    }

    private TemplateArea createTemplateArea(IAutoTextContent autoText, Dimension contentDimension) {
        TemplateArea templateArea = (TemplateArea)AreaFactory.createTemplateArea(autoText);
        templateArea.setWidth(contentDimension.getWidth());
        templateArea.setHeight(contentDimension.getHeight());
        return templateArea;
    }
}

