/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IResultMetaData;

public class ResultMetaData
implements IResultMetaData {
    protected IResultMetaData parentMetaData;
    protected String[] selectedColumns;
    private ArrayList metaEntries = new ArrayList();

    public ResultMetaData(IBaseQueryDefinition query, String[] selectedColumns) {
        this.initializeMetaData(query);
        this.selectedColumns = selectedColumns;
    }

    public ResultMetaData(IBaseQueryDefinition query) {
        this.initializeMetaData(query);
        this.selectedColumns = null;
    }

    public ResultMetaData(IResultMetaData parentMetaData, String[] selectedColumns) {
        this.parentMetaData = parentMetaData;
        this.selectedColumns = selectedColumns;
    }

    public ResultMetaData(org.eclipse.birt.data.engine.api.IResultMetaData dteMeta) {
        this.adaptDTE(dteMeta);
    }

    private void adaptDTE(org.eclipse.birt.data.engine.api.IResultMetaData dteMeta) {
        int count = dteMeta.getColumnCount();
        int index = 0;
        while (index < count) {
            try {
                this.metaEntries.add(new MetaDataEntry(dteMeta.getColumnName(index + 1), dteMeta.getColumnLabel(index + 1), dteMeta.getColumnType(index + 1)));
            }
            catch (BirtException birtException) {}
            ++index;
        }
    }

    protected void initializeMetaData(IBaseQueryDefinition query) {
        this.appendMetaData(query);
    }

    protected void appendMetaData(IBaseQueryDefinition query) {
        Map bindings = query.getBindings();
        for (Map.Entry entry : bindings.entrySet()) {
            String name = (String)entry.getKey();
            IBinding binding = (IBinding)entry.getValue();
            try {
                if (!binding.exportable()) continue;
                this.metaEntries.add(new MetaDataEntry(name, binding.getDisplayName(), binding.getDataType()));
            }
            catch (DataException dataException) {}
        }
    }

    public int getColumnCount() {
        if (this.selectedColumns != null) {
            return this.selectedColumns.length;
        }
        if (this.parentMetaData != null) {
            return this.parentMetaData.getColumnCount();
        }
        return this.metaEntries.size();
    }

    public String getColumnName(int index) throws BirtException {
        index = this.getColumnIndex(index);
        if (this.parentMetaData != null) {
            return this.parentMetaData.getColumnName(index);
        }
        MetaDataEntry entry = (MetaDataEntry)this.metaEntries.get(index);
        return entry.name;
    }

    public String getColumnAlias(int index) throws BirtException {
        return this.getColumnName(index);
    }

    public int getColumnType(int index) throws BirtException {
        index = this.getColumnIndex(index);
        if (this.parentMetaData != null) {
            return this.parentMetaData.getColumnType(index);
        }
        MetaDataEntry entry = (MetaDataEntry)this.metaEntries.get(index);
        return entry.type;
    }

    public String getColumnTypeName(int index) throws BirtException {
        int type = this.getColumnType(index);
        return DataType.getName(type);
    }

    public String getColumnLabel(int index) throws BirtException {
        String columnLabel;
        index = this.getColumnIndex(index);
        if (this.parentMetaData != null) {
            columnLabel = this.parentMetaData.getColumnLabel(index);
        } else {
            MetaDataEntry entry = (MetaDataEntry)this.metaEntries.get(index);
            columnLabel = entry.displayName;
        }
        if (columnLabel == null) {
            columnLabel = this.getColumnName(index);
        }
        return columnLabel;
    }

    private int getColumnIndex(int index) throws BirtException {
        if (this.selectedColumns == null) {
            return index;
        }
        String name = this.selectedColumns[index];
        if (this.parentMetaData != null) {
            int i = 0;
            while (i < this.parentMetaData.getColumnCount()) {
                String columnName = this.parentMetaData.getColumnName(i);
                if (columnName.equals(name)) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.metaEntries.size()) {
                MetaDataEntry entry = (MetaDataEntry)this.metaEntries.get(i);
                if (entry.name.equals(name)) {
                    return i;
                }
                ++i;
            }
        }
        throw new EngineException("Error.InvalidColumnIndexError");
    }

    private static class MetaDataEntry {
        String name;
        String displayName;
        int type;

        MetaDataEntry(String name, String displayName, int type) {
            this.name = name;
            this.displayName = displayName;
            this.type = type;
        }
    }
}

