/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.jointdataset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.impl.jointdataset.BinaryTreeROSeekerHelper;
import org.eclipse.birt.data.engine.impl.jointdataset.IJoinConditionMatcher;
import org.eclipse.birt.data.engine.impl.jointdataset.IMatchResultObjectSeeker;
import org.eclipse.birt.data.engine.impl.jointdataset.JointDataSetUtil;
import org.eclipse.birt.data.engine.impl.jointdataset.SegmentInfo;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class BinaryTreeResultObjectSeeker
implements IMatchResultObjectSeeker {
    private int joinType;
    private IJoinConditionMatcher matcher;
    private BinaryTreeROSeekerHelper helper;
    private int currentPrimaryIndex;
    private IResultIterator secondaryIterator;

    public BinaryTreeResultObjectSeeker(IJoinConditionMatcher matcher, int joinType) throws DataException {
        this.matcher = matcher;
        this.joinType = joinType;
        this.currentPrimaryIndex = -1;
    }

    private List getNodeArray() throws DataException {
        ArrayList<SegmentInfo> array = new ArrayList<SegmentInfo>();
        ResultSetCache cache = this.secondaryIterator.getResultSetCache();
        int count = cache.getCount();
        int blockSize = count / 1024;
        int size = 1024;
        if (blockSize == 0) {
            size = count;
            blockSize = 1;
        }
        int startingIndex = 0;
        int i = 0;
        while (i < size) {
            if (startingIndex >= count) break;
            Object[] min = this.matcher.getCompareValue(this.joinType == 2);
            Object[] max = null;
            int start = startingIndex;
            if ((startingIndex += blockSize) < count) {
                cache.moveTo(startingIndex);
                max = this.matcher.getCompareValue(this.joinType == 2);
                while (JointDataSetUtil.compare(this.matcher.getCompareValue(this.joinType == 2), max) == 0) {
                    ++startingIndex;
                    if (cache.fetch() == null) break;
                }
                if (startingIndex < count) {
                    cache.moveTo(startingIndex);
                } else {
                    cache.moveTo(count - 1);
                }
            } else {
                cache.moveTo(count - 1);
                max = this.matcher.getCompareValue(this.joinType == 2);
            }
            array.add(new SegmentInfo(min, max, start, startingIndex - 1));
            ++i;
        }
        this.secondaryIterator.first(0);
        return array;
    }

    public IResultObject getNextMatchedResultObject(int primaryIndex) throws DataException {
        Object[] o = this.matcher.getCompareValue(this.joinType != 2);
        SegmentInfo n = this.helper.search(o);
        if (n == null) {
            return null;
        }
        if (this.currentPrimaryIndex != primaryIndex) {
            this.secondaryIterator.getResultSetCache().moveTo(n.getStartingIndex());
            this.currentPrimaryIndex = primaryIndex;
        } else {
            this.secondaryIterator.next();
        }
        do {
            if (this.secondaryIterator.getCurrentResult() == null || !this.matcher.match()) continue;
            return this.secondaryIterator.getCurrentResult();
        } while (this.secondaryIterator.getCurrentResultIndex() <= n.getEndingIndex() && this.secondaryIterator.next());
        return null;
    }

    public void setResultIterator(IResultIterator ri) throws DataException {
        this.secondaryIterator = ri;
        this.helper = new BinaryTreeROSeekerHelper(this.getNodeArray());
    }
}

