/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.index;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import org.eclipse.birt.core.btree.BTreeSerializer;
import org.eclipse.birt.core.i18n.CoreMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaSerializer
implements BTreeSerializer<Object> {
    ClassLoader classLoader = null;

    JavaSerializer() {
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public byte[] getBytes(Object object) throws IOException {
        if (!(object instanceof Serializable)) {
            throw new NotSerializableException(CoreMessages.getString("error.NotSerializable"));
        }
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(buff);
        oo.writeObject(object);
        oo.close();
        return buff.toByteArray();
    }

    @Override
    public Object getObject(byte[] bytes) throws IOException, ClassNotFoundException {
        final ClassLoader loader = this.classLoader;
        ObjectInputStream oo = new ObjectInputStream(new ByteArrayInputStream(bytes)){

            protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                return Class.forName(desc.getName(), false, loader);
            }
        };
        return oo.readObject();
    }
}

