/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.reportitem.BIRTCubeResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

public class BIRTChartXtabResultSetEvaluator
extends BIRTCubeResultSetEvaluator {
    private final ExtendedItemHandle handle;
    private boolean bSubCursor = false;
    private boolean bTransposed = false;

    public BIRTChartXtabResultSetEvaluator(ICubeResultSet rs, ExtendedItemHandle handle) {
        super(rs);
        this.handle = handle;
    }

    protected void initCubeCursor() throws OLAPException, BirtException {
        ICubeCursor parent;
        this.cubeCursor = parent = this.getCubeCursor();
        try {
            AggregationCellHandle cellHandle = ChartCubeUtil.getXtabContainerCell(this.handle);
            LevelHandle levelAggColumn = cellHandle.getAggregationOnColumn();
            LevelHandle levelAggRow = cellHandle.getAggregationOnRow();
            Chart cm = ChartItemUtil.getChartFromHandle(this.handle);
            this.bTransposed = ((ChartWithAxes)cm).isTransposed();
            if (!this.bTransposed) {
                if (levelAggColumn != null && levelAggRow != null) {
                    List edges = this.cubeCursor.getOrdinateEdge();
                    this.mainEdgeCursor = (EdgeCursor)edges.get(1);
                    this.subEdgeCursor = (EdgeCursor)edges.get(0);
                    this.bSubCursor = true;
                } else {
                    this.cubeCursor = parent;
                }
            } else if (cellHandle.getSpanOverOnRow() != null) {
                if (levelAggColumn != null && levelAggRow != null) {
                    List edges = this.cubeCursor.getOrdinateEdge();
                    this.mainEdgeCursor = (EdgeCursor)edges.get(0);
                    this.subEdgeCursor = (EdgeCursor)edges.get(1);
                    this.bSubCursor = true;
                } else {
                    this.cubeCursor = parent;
                }
            } else {
                this.cubeCursor = parent;
            }
        }
        catch (BirtException e) {
            logger.log(e);
            this.cubeCursor = parent;
        }
        if (!this.bSubCursor) {
            List edges = this.cubeCursor.getOrdinateEdge();
            if (edges.size() == 1) {
                this.mainEdgeCursor = (EdgeCursor)edges.get(0);
            } else if (edges.size() > 1) {
                this.mainEdgeCursor = (EdgeCursor)edges.get(this.bTransposed ? 1 : 0);
            }
            this.subEdgeCursor = null;
        }
    }

    protected ICubeCursor getCubeCursor() throws BirtException {
        return (ICubeCursor)this.rs.getCubeCursor();
    }

    public boolean first() {
        try {
            this.initCubeCursor();
            if (!this.bSubCursor) {
                return this.mainEdgeCursor.first();
            }
            this.mainEdgeCursor.first();
            return this.subEdgeCursor.first();
        }
        catch (OLAPException e) {
            logger.log(e);
        }
        catch (BirtException e) {
            logger.log(e);
        }
        return false;
    }

    public boolean next() {
        try {
            if (!this.bSubCursor) {
                return this.hasNext(this.mainEdgeCursor);
            }
            return this.hasNext(this.subEdgeCursor);
        }
        catch (OLAPException e) {
            logger.log(e);
            return false;
        }
    }
}

