/*
 *************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *  
 *************************************************************************
 */ 
package org.eclipse.birt.data.engine.api.querydefn;

import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;

/**
 * Default implementation of {@link org.eclipse.birt.data.engine.api.IInputParameterBinding} interface. <p>
 */
public class InputParameterBinding implements IInputParameterBinding
{
    protected String		name;
    protected int			position = -1;
    protected IBaseExpression expr;
    
    /**
     * Constructs a binding based on parameter name
     */
    public InputParameterBinding( String paramName, IBaseExpression boundExpression )
    {
        name = paramName;
        expr = boundExpression;
    }
    
    /**
     * Constructs a binding based on parameter position
     */
    public InputParameterBinding( int paramPosn, IBaseExpression boundExpression )
    {
        position = paramPosn;
        expr = boundExpression;
    }
    
    
	/**
	 * Returns the expression that provides the value of the parameter.
	 * 
	 * @return the bound expression
	 */
	
	public IBaseExpression getExpr( )
	{
	    return expr;
	}
	
	/**
	 * Returns the parameter name.
	 * 
	 * @return the name. If null, this parameter is bound by position
	 */
	
	public String getName( )
	{
	    return name;
	}

	/**
	 * Returns the parameter position.
	 * 
	 * @return the name. If -1, this parameter is bound by name
	 */
	public int getPosition()
	{
	    return position;
	}
	
}
