/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.namespace.GeneralModuleNameContext;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class CubeNameContext
extends GeneralModuleNameContext {
    private static final IElementDefn HIERARCHY_DEFN = MetaDataDictionary.getInstance().getElement("Hierarchy");
    private static final IElementDefn DIMENSION_DEFN = MetaDataDictionary.getInstance().getElement("Dimension");
    private static final int NAMESPACE_INDEX = 0;
    private static final int NAME_INDEX = 1;

    CubeNameContext(Module module, int nameSpaceID) {
        super(module, nameSpaceID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ElementRefValue resolve(DesignElement focus, DesignElement element, PropertyDefn propDefn, ElementDefn elementDefn) {
        DesignElement retElement;
        Cube referredCube;
        if (element == null) {
            return null;
        }
        ElementDefn targetDefn = this.getTargetDefn(propDefn, elementDefn);
        if (targetDefn == null || this.isCubeReferred(targetDefn)) {
            return super.resolve(focus, element, propDefn, elementDefn);
        }
        int nameSpaceID = targetDefn.getNameSpaceID();
        if (nameSpaceID == 10 && focus instanceof Dimension) {
            return super.resolve(focus, element, propDefn, elementDefn);
        }
        String namespace = null;
        Module root = element.getRoot();
        if (root instanceof Library) {
            namespace = root.getNamespace();
        }
        String name = element.getName();
        if (focus != null && focus.canDynamicExtends() && (referredCube = (Cube)focus.getDynamicExtendsElement(focus.getRoot())) == null) {
            return new ElementRefValue(namespace, name);
        }
        Cube cube = this.findTarget(focus);
        if (cube == null) {
            return super.resolve(focus, element, propDefn, elementDefn);
        }
        if (cube.canDynamicExtends()) {
            Cube referredCube2 = (Cube)cube.getDynamicExtendsElement(cube.getRoot());
            if (referredCube2 == null) {
                return new ElementRefValue(namespace, name);
            }
            DesignElement retElement2 = cube.findLocalElement(name, targetDefn);
            if (retElement2 == null) return new ElementRefValue(namespace, name);
            return new ElementRefValue(namespace, retElement2);
        }
        if (!targetDefn.isKindOf(HIERARCHY_DEFN) && !targetDefn.isKindOf(DIMENSION_DEFN)) return super.resolve(focus, element, propDefn, elementDefn);
        String tmpName = name;
        if (namespace != null) {
            Module tmpRoot = cube.getRoot();
            if (!(tmpRoot instanceof Library)) return super.resolve(focus, element, propDefn, elementDefn);
            if (!namespace.equals(((Library)tmpRoot).getNamespace())) return super.resolve(focus, element, propDefn, elementDefn);
            tmpName = name;
        }
        if ((retElement = cube.findLocalElement(tmpName, targetDefn)) == null) return new ElementRefValue(namespace, name);
        return new ElementRefValue(namespace, retElement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ElementRefValue resolve(DesignElement focus, String elementName, PropertyDefn propDefn, ElementDefn elementDefn) {
        DesignElement retElement;
        Cube referredCube;
        if (StringUtil.isBlank(elementName)) {
            return null;
        }
        ElementDefn targetDefn = this.getTargetDefn(propDefn, elementDefn);
        if (targetDefn == null || this.isCubeReferred(targetDefn)) {
            return super.resolve(focus, elementName, propDefn, elementDefn);
        }
        int nameSpaceID = targetDefn.getNameSpaceID();
        if (nameSpaceID == 10 && focus instanceof Dimension) {
            return super.resolve(focus, elementName, propDefn, elementDefn);
        }
        String[] rets = this.splitName(elementName, Integer.MAX_VALUE);
        String namespace = rets[0];
        String name = rets[1];
        if (focus != null && focus.canDynamicExtends() && (referredCube = (Cube)focus.getDynamicExtendsElement(focus.getRoot())) == null) {
            return new ElementRefValue(namespace, name);
        }
        Cube cube = this.findTarget(focus);
        if (cube == null) {
            return super.resolve(focus, elementName, propDefn, elementDefn);
        }
        if (cube.canDynamicExtends()) {
            Cube referredCube2 = (Cube)cube.getDynamicExtendsElement(cube.getRoot());
            if (referredCube2 == null) {
                return new ElementRefValue(namespace, name);
            }
            DesignElement retElement2 = cube.findLocalElement(name, targetDefn);
            if (retElement2 == null) return new ElementRefValue(namespace, name);
            return new ElementRefValue(namespace, retElement2);
        }
        if (!targetDefn.isKindOf(HIERARCHY_DEFN) && !targetDefn.isKindOf(DIMENSION_DEFN)) return super.resolve(focus, elementName, propDefn, elementDefn);
        String tmpName = elementName;
        if (namespace != null) {
            Module tmpRoot = cube.getRoot();
            if (!(tmpRoot instanceof Library)) return super.resolve(focus, elementName, propDefn, elementDefn);
            if (!namespace.equals(((Library)tmpRoot).getNamespace())) return super.resolve(focus, elementName, propDefn, elementDefn);
            tmpName = name;
        }
        if ((retElement = cube.findLocalElement(tmpName, targetDefn)) == null) return new ElementRefValue(namespace, name);
        return new ElementRefValue(namespace, retElement);
    }

    private boolean isCubeReferred(IElementDefn targetDefn) {
        assert (targetDefn != null);
        return targetDefn.isKindOf(MetaDataDictionary.getInstance().getElement("Cube"));
    }

    private Cube findTarget(DesignElement focus) {
        if (focus == null) {
            return null;
        }
        DesignElement element = focus;
        while (element != null) {
            ReportItem item;
            Cube cube;
            if (element instanceof Cube) {
                return (Cube)element;
            }
            if (element instanceof ReportItem && (cube = (Cube)(item = (ReportItem)element).getCubeElement(item.getRoot())) != null) {
                return cube;
            }
            element = element.getContainer();
        }
        return null;
    }

    private ElementDefn getTargetDefn(PropertyDefn propDefn, ElementDefn elementDefn) {
        if (elementDefn != null) {
            return elementDefn;
        }
        return (ElementDefn)(propDefn == null ? null : propDefn.getTargetElementType());
    }

    private String[] splitName(String elementName, int level) {
        String namespace = StringUtil.extractNamespace(elementName);
        String name = StringUtil.extractName(elementName);
        Module moduleToSearch = this.module;
        if (namespace != null) {
            moduleToSearch = this.module.getLibraryWithNamespace(namespace, level);
        } else if (moduleToSearch instanceof Library) {
            namespace = ((Library)moduleToSearch).getNamespace();
        }
        String[] names = new String[]{namespace, name};
        return names;
    }
}

