/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.impl.RenderTask;
import org.eclipse.birt.report.engine.content.ContentFactory;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.PageHintReader;
import org.eclipse.birt.report.engine.internal.document.v3.CachedReportContentReaderV3;
import org.eclipse.birt.report.engine.internal.executor.doc.ReportItemReader;
import org.eclipse.birt.report.engine.internal.executor.doc.ReportItemReaderManager;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.toc.ITreeNode;

public abstract class AbstractReportReader
implements IReportExecutor {
    protected static Logger logger = Logger.getLogger(AbstractReportReader.class.getName());
    protected ExecutionContext context;
    protected IDataEngine dataEngine;
    protected CachedReportContentReaderV3 reader;
    protected PageHintReader hintReader;
    protected CachedReportContentReaderV3 pageReader;
    protected Report report;
    protected IReportDocument reportDoc;
    protected ReportContent reportContent;
    ReportItemReaderManager manager;

    public AbstractReportReader(ExecutionContext context) throws IOException, BirtException {
        assert (context.getDesign() != null);
        assert (context.getReportDocument() != null);
        this.context = context;
        this.report = context.getReport();
        this.reportContent = (ReportContent)ContentFactory.createReportContent(this.report);
        this.reportContent.setExecutionContext(context);
        context.setReportContent(this.reportContent);
        this.reportDoc = context.getReportDocument();
        IEngineTask engineTask = context.getEngineTask();
        if (engineTask instanceof RenderTask) {
            RenderTask renderTask = (RenderTask)engineTask;
            ITreeNode tocTree = renderTask.getRawTOCTree();
            this.reportContent.setTOCTree(tocTree);
        }
        long totalPage = this.reportDoc.getPageCount();
        context.setTotalPage(totalPage);
        this.reportContent.setTotalPage(totalPage);
        this.dataEngine = context.getDataEngine();
        this.dataEngine.prepare(this.report, context.getAppContext());
        this.manager = new ReportItemReaderManager(context);
        try {
            this.openReaders();
        }
        catch (IOException ex) {
            this.closeReaders();
            throw ex;
        }
    }

    public void close() {
        this.closeReaders();
    }

    protected void openReaders() throws IOException {
        IDocArchiveReader archive = this.reportDoc.getArchive();
        RAInputStream in = archive.getStream("/content/content.dat");
        this.reader = new CachedReportContentReaderV3(this.reportContent, in, this.context);
        this.hintReader = new PageHintReader(this.reportDoc);
        in = archive.getStream("/content/page.dat");
        this.pageReader = new CachedReportContentReaderV3(this.reportContent, in, this.context);
    }

    protected void closeReaders() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.hintReader != null) {
            this.hintReader.close();
            this.hintReader = null;
        }
        if (this.pageReader != null) {
            this.pageReader.close();
            this.pageReader = null;
        }
    }

    public IReportItemExecutor createPageExecutor(long pageNumber, MasterPageDesign pageDesign) {
        try {
            IPageHint hint;
            long totalPage = this.hintReader.getTotalPage();
            if (pageNumber > totalPage) {
                hint = this.hintReader.getPageHint(1L);
            } else {
                hint = this.hintReader.getPageHint(pageNumber);
                if (hint == null) {
                    hint = this.hintReader.getPageHint(1L);
                }
            }
            if (hint != null) {
                long offset = hint.getOffset();
                ReportItemReader pageExecutor = this.manager.createExecutor(null, offset);
                pageExecutor.reader = this.pageReader;
                return pageExecutor;
            }
        }
        catch (IOException ex) {
            this.context.addException(pageDesign, (BirtException)new EngineException("Error.PagesLoadingError", (Object)pageNumber, (Throwable)ex));
        }
        return null;
    }

    public IReportContent execute() {
        return this.reportContent;
    }
}

