/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.lang.reflect.Array;
import org.eclipse.birt.data.engine.olap.data.util.BaseDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IStructure;
import org.eclipse.birt.data.engine.olap.data.util.IStructureCreator;
import org.eclipse.birt.data.engine.olap.data.util.ObjectReader;
import org.eclipse.birt.data.engine.olap.data.util.ObjectWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureDiskArray
extends BaseDiskArray {
    private IStructureCreator creator;
    private ObjectWriter[] fieldWriters;
    private ObjectReader[] fieldReaders;

    public StructureDiskArray(IStructureCreator creator) throws IOException {
        this.creator = creator;
    }

    @Override
    protected void writeObject(Object object) throws IOException {
        if (object == null) {
            this.randomAccessFile.writeShort(-1);
            return;
        }
        IStructure cachedObject = (IStructure)object;
        Object[] objects = cachedObject.getFieldValues();
        this.randomAccessFile.writeShort((short)objects.length);
        if (this.fieldWriters == null || this.fieldWriters.length < objects.length) {
            this.createReadersAndWriters(objects.length);
        }
        int i = 0;
        while (i < objects.length) {
            if (i >= this.fieldWriters.length) {
                this.fieldWriters[this.fieldWriters.length - 1].write(this.randomAccessFile, objects[i]);
            } else {
                this.fieldWriters[i].write(this.randomAccessFile, objects[i]);
            }
            ++i;
        }
    }

    private void createReadersAndWriters(int size) {
        if (this.fieldWriters == null && this.fieldReaders == null) {
            this.fieldWriters = new ObjectWriter[size];
            this.fieldReaders = new ObjectReader[size];
            int i = 0;
            while (i < size) {
                this.fieldWriters[i] = new ObjectWriter();
                this.fieldReaders[i] = new ObjectReader();
                ++i;
            }
        } else {
            int i = this.fieldWriters.length;
            this.fieldReaders = (ObjectReader[])StructureDiskArray.copyOf(this.fieldReaders, size);
            this.fieldWriters = (ObjectWriter[])StructureDiskArray.copyOf(this.fieldWriters, size);
            while (i < this.fieldReaders.length) {
                this.fieldWriters[i] = new ObjectWriter();
                this.fieldReaders[i] = new ObjectReader();
                ++i;
            }
        }
    }

    public static <T, U> T[] copyOf(U[] original, int newLength) {
        Object[] copy = original.getClass() == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(original.getClass().getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    @Override
    protected Object readObject() throws IOException {
        short fieldCount = this.randomAccessFile.readShort();
        if (fieldCount == -1) {
            return null;
        }
        Object[] objects = new Object[fieldCount];
        int i = 0;
        while (i < objects.length) {
            if (i < this.fieldReaders.length && this.fieldReaders[i].getDataType() != this.fieldWriters[i].getDataType()) {
                this.fieldReaders[i].setDataType(this.fieldWriters[i].getDataType());
            }
            objects[i] = i >= this.fieldReaders.length ? this.fieldReaders[this.fieldReaders.length - 1].read(this.randomAccessFile) : this.fieldReaders[i].read(this.randomAccessFile);
            ++i;
        }
        return this.creator.createInstance(objects);
    }

    @Override
    public void clear() throws IOException {
        this.fieldWriters = null;
        this.fieldReaders = null;
        super.clear();
    }
}

