/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.device.IScriptMenuHelper;
import org.eclipse.birt.chart.model.attribute.ScriptValue;
import org.eclipse.birt.core.script.JavascriptEvalUtil;

public class ScriptMenuHelper
implements IScriptMenuHelper {
    private static IScriptMenuHelper factory = new ScriptMenuHelper();

    public static void initInstance(IScriptMenuHelper tFactory) {
        factory = tFactory;
    }

    public static IScriptMenuHelper instance() {
        return factory;
    }

    public String getScriptValueJS(int index, ScriptValue sv, ULocale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t mii.text = '" + sv.getLabel().getCaption().getValue() + "';\n");
        sb.append("\t mii.actionType = BirtChartInteractivityActions.INVOKE_SCRIPTS;\n");
        String script = sv.getScript();
        sb.append("\t mii.actionValue = \"" + ScriptMenuHelper.wrapScriptsAsFunction(script) + "\"\n");
        sb.append("\t\t menuInfo.addItemInfo(mii);\n");
        return sb.toString();
    }

    public static String wrapScriptsAsFunction(String script) {
        String f = "var _callScripts=function(evt, categoryData, valueData, valueSeriesName, legendItemText, legendItemValue, axisLabel, menuInfo) {" + JavascriptEvalUtil.transformToJsConstants(script) + "}; _callScripts(evt, " + "categoryData" + ", " + "valueData" + ", " + "valueSeriesName" + ", " + "legendItemText" + ", " + "legendItemValue" + ", " + "axisLabel" + ", menuInfo);";
        return f;
    }
}

