/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import java.util.regex.Pattern;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.core.EnumerableAssert;
import org.fest.assertions.internal.Strings;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringAssert
extends AbstractAssert<StringAssert, String>
implements EnumerableAssert<StringAssert, String> {
    @VisibleForTesting
    Strings strings = Strings.instance();

    protected StringAssert(String actual) {
        super(actual, StringAssert.class);
    }

    @Override
    public void isNullOrEmpty() {
        this.strings.assertNullOrEmpty(this.info, (String)this.actual);
    }

    @Override
    public void isEmpty() {
        this.strings.assertEmpty(this.info, (String)this.actual);
    }

    @Override
    public StringAssert isNotEmpty() {
        this.strings.assertNotEmpty(this.info, (String)this.actual);
        return this;
    }

    @Override
    public StringAssert hasSize(int expected) {
        this.strings.assertHasSize(this.info, (String)this.actual, expected);
        return this;
    }

    @Override
    public StringAssert hasSameSizeAs(Object[] other) {
        this.strings.assertHasSameSizeAs((AssertionInfo)this.info, (String)this.actual, other);
        return this;
    }

    @Override
    public StringAssert hasSameSizeAs(Iterable<?> other) {
        this.strings.assertHasSameSizeAs((AssertionInfo)this.info, (String)this.actual, other);
        return this;
    }

    public StringAssert isEqualToIgnoringCase(String expected) {
        this.strings.assertEqualsIgnoringCase(this.info, (String)this.actual, expected);
        return this;
    }

    public StringAssert contains(String sequence) {
        this.strings.assertContains(this.info, (String)this.actual, sequence);
        return this;
    }

    public StringAssert containsIgnoringCase(String sequence) {
        this.strings.assertContainsIgnoringCase(this.info, (String)this.actual, sequence);
        return this;
    }

    public StringAssert doesNotContain(String sequence) {
        this.strings.assertDoesNotContain(this.info, (String)this.actual, sequence);
        return this;
    }

    public StringAssert startsWith(String prefix) {
        this.strings.assertStartsWith(this.info, (String)this.actual, prefix);
        return this;
    }

    public StringAssert endsWith(String suffix) {
        this.strings.assertEndsWith(this.info, (String)this.actual, suffix);
        return this;
    }

    public StringAssert matches(String regex) {
        this.strings.assertMatches((AssertionInfo)this.info, (String)this.actual, regex);
        return this;
    }

    public StringAssert doesNotMatch(String regex) {
        this.strings.assertDoesNotMatch((AssertionInfo)this.info, (String)this.actual, regex);
        return this;
    }

    public StringAssert matches(Pattern pattern) {
        this.strings.assertMatches((AssertionInfo)this.info, (String)this.actual, pattern);
        return this;
    }

    public StringAssert doesNotMatch(Pattern pattern) {
        this.strings.assertDoesNotMatch((AssertionInfo)this.info, (String)this.actual, pattern);
        return this;
    }

    @Override
    public StringAssert usingElementComparator(Comparator<? super String> customComparator) {
        throw new UnsupportedOperationException("custom element Comparator is not supported for String comparison");
    }

    @Override
    public StringAssert usingDefaultElementComparator() {
        throw new UnsupportedOperationException("custom element Comparator is not supported for String comparison");
    }

    @Override
    public StringAssert usingComparator(Comparator<? super String> customComparator) {
        super.usingComparator(customComparator);
        this.strings = new Strings((ComparisonStrategy)new ComparatorBasedComparisonStrategy(customComparator));
        return (StringAssert)this.myself;
    }

    @Override
    public StringAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.strings = Strings.instance();
        return (StringAssert)this.myself;
    }
}

