/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.BaseTrainingListener;
import org.nd4j.common.util.ThreadUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SleepyTrainingListener
extends BaseTrainingListener
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SleepyTrainingListener.class);
    protected final transient ThreadLocal<AtomicLong> lastEE = new ThreadLocal();
    protected final transient ThreadLocal<AtomicLong> lastES = new ThreadLocal();
    protected final transient ThreadLocal<AtomicLong> lastFF = new ThreadLocal();
    protected final transient ThreadLocal<AtomicLong> lastBP = new ThreadLocal();
    protected final transient ThreadLocal<AtomicLong> lastIteration = new ThreadLocal();
    protected long timerEE;
    protected long timerES;
    protected long timerFF;
    protected long timerBP;
    protected long timerIteration;
    protected SleepMode sleepMode;
    protected TimeMode timeMode;

    protected void sleep(long sleepTimeMs) {
        if (sleepTimeMs < 1L) {
            return;
        }
        switch (this.sleepMode) {
            case PARK: {
                ThreadUtils.uncheckedSleep((long)sleepTimeMs);
                break;
            }
            case BUSY: {
                long target = System.currentTimeMillis() + sleepTimeMs;
                while (System.currentTimeMillis() < target) {
                    Thread.yield();
                }
                break;
            }
            case SLEEP: {
                try {
                    Thread.sleep(sleepTimeMs);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new IllegalStateException("Unknown SleepMode value passed in: " + (Object)((Object)this.sleepMode));
            }
        }
    }

    protected void sleep(AtomicLong lastTime, long sleepTime) {
        if (sleepTime == 0L) {
            return;
        }
        if (this.timeMode == TimeMode.SIMPLE) {
            this.sleep(sleepTime);
            return;
        }
        if (lastTime == null) {
            this.sleep(sleepTime);
            return;
        }
        long currentTime = System.currentTimeMillis();
        long delta = sleepTime - (currentTime - lastTime.get());
        this.sleep(delta);
    }

    @Override
    public void onEpochStart(Model model) {
        this.sleep(this.lastES.get(), this.timerES);
        if (this.lastES.get() == null) {
            this.lastES.set(new AtomicLong(System.currentTimeMillis()));
        } else {
            this.lastES.get().set(System.currentTimeMillis());
        }
    }

    @Override
    public void onEpochEnd(Model model) {
        this.sleep(this.lastEE.get(), this.timerEE);
        if (this.lastEE.get() == null) {
            this.lastEE.set(new AtomicLong(System.currentTimeMillis()));
        } else {
            this.lastEE.get().set(System.currentTimeMillis());
        }
    }

    @Override
    public void onForwardPass(Model model, List<INDArray> activations) {
        this.sleep(this.lastFF.get(), this.timerFF);
        if (this.lastFF.get() == null) {
            this.lastFF.set(new AtomicLong(System.currentTimeMillis()));
        } else {
            this.lastFF.get().set(System.currentTimeMillis());
        }
    }

    @Override
    public void onForwardPass(Model model, Map<String, INDArray> activations) {
        this.sleep(this.lastFF.get(), this.timerFF);
        if (this.lastFF.get() == null) {
            this.lastFF.set(new AtomicLong(System.currentTimeMillis()));
        } else {
            this.lastFF.get().set(System.currentTimeMillis());
        }
    }

    @Override
    public void iterationDone(Model model, int iteration, int epoch) {
        this.sleep(this.lastIteration.get(), this.timerIteration);
        if (this.lastIteration.get() == null) {
            this.lastIteration.set(new AtomicLong(System.currentTimeMillis()));
        } else {
            this.lastIteration.get().set(System.currentTimeMillis());
        }
    }

    @Override
    public void onBackwardPass(Model model) {
        this.sleep(this.lastBP.get(), this.timerBP);
        if (this.lastBP.get() == null) {
            this.lastBP.set(new AtomicLong(System.currentTimeMillis()));
        } else {
            this.lastBP.get().set(System.currentTimeMillis());
        }
    }

    @Override
    public void onGradientCalculation(Model model) {
    }

    private static long $default$timerEE() {
        return 0L;
    }

    private static long $default$timerES() {
        return 0L;
    }

    private static long $default$timerFF() {
        return 0L;
    }

    private static long $default$timerBP() {
        return 0L;
    }

    private static long $default$timerIteration() {
        return 0L;
    }

    private static SleepMode $default$sleepMode() {
        return SleepMode.PARK;
    }

    private static TimeMode $default$timeMode() {
        return TimeMode.SIMPLE;
    }

    public static SleepyTrainingListenerBuilder builder() {
        return new SleepyTrainingListenerBuilder();
    }

    public SleepyTrainingListener(long timerEE, long timerES, long timerFF, long timerBP, long timerIteration, SleepMode sleepMode, TimeMode timeMode) {
        this.timerEE = timerEE;
        this.timerES = timerES;
        this.timerFF = timerFF;
        this.timerBP = timerBP;
        this.timerIteration = timerIteration;
        this.sleepMode = sleepMode;
        this.timeMode = timeMode;
    }

    public SleepyTrainingListener() {
        this.timerEE = SleepyTrainingListener.$default$timerEE();
        this.timerES = SleepyTrainingListener.$default$timerES();
        this.timerFF = SleepyTrainingListener.$default$timerFF();
        this.timerBP = SleepyTrainingListener.$default$timerBP();
        this.timerIteration = SleepyTrainingListener.$default$timerIteration();
        this.sleepMode = SleepyTrainingListener.$default$sleepMode();
        this.timeMode = SleepyTrainingListener.$default$timeMode();
    }

    public long getTimerEE() {
        return this.timerEE;
    }

    public long getTimerES() {
        return this.timerES;
    }

    public long getTimerFF() {
        return this.timerFF;
    }

    public long getTimerBP() {
        return this.timerBP;
    }

    public long getTimerIteration() {
        return this.timerIteration;
    }

    public SleepMode getSleepMode() {
        return this.sleepMode;
    }

    public TimeMode getTimeMode() {
        return this.timeMode;
    }

    public void setTimerEE(long timerEE) {
        this.timerEE = timerEE;
    }

    public void setTimerES(long timerES) {
        this.timerES = timerES;
    }

    public void setTimerFF(long timerFF) {
        this.timerFF = timerFF;
    }

    public void setTimerBP(long timerBP) {
        this.timerBP = timerBP;
    }

    public void setTimerIteration(long timerIteration) {
        this.timerIteration = timerIteration;
    }

    public void setSleepMode(SleepMode sleepMode) {
        this.sleepMode = sleepMode;
    }

    public void setTimeMode(TimeMode timeMode) {
        this.timeMode = timeMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SleepyTrainingListener)) {
            return false;
        }
        SleepyTrainingListener other = (SleepyTrainingListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimerEE() != other.getTimerEE()) {
            return false;
        }
        if (this.getTimerES() != other.getTimerES()) {
            return false;
        }
        if (this.getTimerFF() != other.getTimerFF()) {
            return false;
        }
        if (this.getTimerBP() != other.getTimerBP()) {
            return false;
        }
        if (this.getTimerIteration() != other.getTimerIteration()) {
            return false;
        }
        SleepMode this$sleepMode = this.getSleepMode();
        SleepMode other$sleepMode = other.getSleepMode();
        if (this$sleepMode == null ? other$sleepMode != null : !((Object)((Object)this$sleepMode)).equals((Object)other$sleepMode)) {
            return false;
        }
        TimeMode this$timeMode = this.getTimeMode();
        TimeMode other$timeMode = other.getTimeMode();
        return !(this$timeMode == null ? other$timeMode != null : !((Object)((Object)this$timeMode)).equals((Object)other$timeMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SleepyTrainingListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timerEE = this.getTimerEE();
        result = result * 59 + (int)($timerEE >>> 32 ^ $timerEE);
        long $timerES = this.getTimerES();
        result = result * 59 + (int)($timerES >>> 32 ^ $timerES);
        long $timerFF = this.getTimerFF();
        result = result * 59 + (int)($timerFF >>> 32 ^ $timerFF);
        long $timerBP = this.getTimerBP();
        result = result * 59 + (int)($timerBP >>> 32 ^ $timerBP);
        long $timerIteration = this.getTimerIteration();
        result = result * 59 + (int)($timerIteration >>> 32 ^ $timerIteration);
        SleepMode $sleepMode = this.getSleepMode();
        result = result * 59 + ($sleepMode == null ? 43 : ((Object)((Object)$sleepMode)).hashCode());
        TimeMode $timeMode = this.getTimeMode();
        result = result * 59 + ($timeMode == null ? 43 : ((Object)((Object)$timeMode)).hashCode());
        return result;
    }

    public String toString() {
        return "SleepyTrainingListener(lastEE=" + this.lastEE + ", lastES=" + this.lastES + ", lastFF=" + this.lastFF + ", lastBP=" + this.lastBP + ", lastIteration=" + this.lastIteration + ", timerEE=" + this.getTimerEE() + ", timerES=" + this.getTimerES() + ", timerFF=" + this.getTimerFF() + ", timerBP=" + this.getTimerBP() + ", timerIteration=" + this.getTimerIteration() + ", sleepMode=" + (Object)((Object)this.getSleepMode()) + ", timeMode=" + (Object)((Object)this.getTimeMode()) + ")";
    }

    public static class SleepyTrainingListenerBuilder {
        private boolean timerEE$set;
        private long timerEE$value;
        private boolean timerES$set;
        private long timerES$value;
        private boolean timerFF$set;
        private long timerFF$value;
        private boolean timerBP$set;
        private long timerBP$value;
        private boolean timerIteration$set;
        private long timerIteration$value;
        private boolean sleepMode$set;
        private SleepMode sleepMode$value;
        private boolean timeMode$set;
        private TimeMode timeMode$value;

        SleepyTrainingListenerBuilder() {
        }

        public SleepyTrainingListenerBuilder timerEE(long timerEE) {
            this.timerEE$value = timerEE;
            this.timerEE$set = true;
            return this;
        }

        public SleepyTrainingListenerBuilder timerES(long timerES) {
            this.timerES$value = timerES;
            this.timerES$set = true;
            return this;
        }

        public SleepyTrainingListenerBuilder timerFF(long timerFF) {
            this.timerFF$value = timerFF;
            this.timerFF$set = true;
            return this;
        }

        public SleepyTrainingListenerBuilder timerBP(long timerBP) {
            this.timerBP$value = timerBP;
            this.timerBP$set = true;
            return this;
        }

        public SleepyTrainingListenerBuilder timerIteration(long timerIteration) {
            this.timerIteration$value = timerIteration;
            this.timerIteration$set = true;
            return this;
        }

        public SleepyTrainingListenerBuilder sleepMode(SleepMode sleepMode) {
            this.sleepMode$value = sleepMode;
            this.sleepMode$set = true;
            return this;
        }

        public SleepyTrainingListenerBuilder timeMode(TimeMode timeMode) {
            this.timeMode$value = timeMode;
            this.timeMode$set = true;
            return this;
        }

        public SleepyTrainingListener build() {
            long timerEE$value = this.timerEE$value;
            if (!this.timerEE$set) {
                timerEE$value = SleepyTrainingListener.$default$timerEE();
            }
            long timerES$value = this.timerES$value;
            if (!this.timerES$set) {
                timerES$value = SleepyTrainingListener.$default$timerES();
            }
            long timerFF$value = this.timerFF$value;
            if (!this.timerFF$set) {
                timerFF$value = SleepyTrainingListener.$default$timerFF();
            }
            long timerBP$value = this.timerBP$value;
            if (!this.timerBP$set) {
                timerBP$value = SleepyTrainingListener.$default$timerBP();
            }
            long timerIteration$value = this.timerIteration$value;
            if (!this.timerIteration$set) {
                timerIteration$value = SleepyTrainingListener.$default$timerIteration();
            }
            SleepMode sleepMode$value = this.sleepMode$value;
            if (!this.sleepMode$set) {
                sleepMode$value = SleepyTrainingListener.$default$sleepMode();
            }
            TimeMode timeMode$value = this.timeMode$value;
            if (!this.timeMode$set) {
                timeMode$value = SleepyTrainingListener.$default$timeMode();
            }
            return new SleepyTrainingListener(timerEE$value, timerES$value, timerFF$value, timerBP$value, timerIteration$value, sleepMode$value, timeMode$value);
        }

        public String toString() {
            return "SleepyTrainingListener.SleepyTrainingListenerBuilder(timerEE$value=" + this.timerEE$value + ", timerES$value=" + this.timerES$value + ", timerFF$value=" + this.timerFF$value + ", timerBP$value=" + this.timerBP$value + ", timerIteration$value=" + this.timerIteration$value + ", sleepMode$value=" + (Object)((Object)this.sleepMode$value) + ", timeMode$value=" + (Object)((Object)this.timeMode$value) + ")";
        }
    }

    public static enum TimeMode {
        ADDITIVE,
        SIMPLE;

    }

    public static enum SleepMode {
        PARK,
        SLEEP,
        BUSY;

    }
}

